#include-once

Func _Util_StartFloodFill($hBitmap, $iX, $iY, $iColor)
	Local $iW = _GDIPlus_ImageGetWidth($hBitmap)
	Local $iH = _GDIPlus_ImageGetHeight($hBitmap)

	Local $tBitmapData = _GDIPlus_BitmapLockBits($hBitmap, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBitmapData, "Scan0")
	Local $tPixel = DllStructCreate("int data[" & $iW * $iH & "];", $iScan0)

	If $tPixel.data($iX + $iY*$iW + 1) <> $iColor Then _Util_FloodFillStep($tPixel, $iX, $iY, $iW, $iH, $tPixel.data($iX + $iY*$iW + 1), $iColor)

	_GDIPlus_BitmapUnlockBits($hBitmap, $tBitmapData)
EndFunc

Func _Util_FloodFillStep($tScan0, $iX, $iY, $iW, $iH, $iSearch, $iReplace)
	If $tScan0.data($iX + $iY*$iW + 1) = $iSearch Then
		$tScan0.data($iX + $iY*$iW + 1) = $iReplace

		If $iX >= 0 Then _Util_FloodFillStep($tScan0, $iX-1, $iY, $iW, $iH, $iSearch, $iReplace)
		If $iX < $iW Then _Util_FloodFillStep($tScan0, $iX+1, $iY, $iW, $iH, $iSearch, $iReplace)
		If $iY >= 0 Then _Util_FloodFillStep($tScan0, $iX, $iY-1, $iW, $iH, $iSearch, $iReplace)
		If $iY < $iH Then _Util_FloodFillStep($tScan0, $iX, $iY+1, $iW, $iH, $iSearch, $iReplace)
	EndIf
EndFunc

Func _Util_StartMagicWand($hBitmap, $iX, $iY)
	Local $hRgn = _GDIPlus_RegionCreateFromRect(0, 0, 0, 0)

	Local $iColor = _GDIPlus_BitmapGetPixel($hBitmap, $iX, $iY)

	_Util_MagicWandStep($hBitmap, $iX, $iY, $hRgn, $iColor)

	Return $hRgn
EndFunc

Func _Util_MagicWandStep($hBitmap, $iX, $iY, $hRgn, $iColor)
	If _GDIPlus_BitmapGetPixel($hBitmap, $iX, $iY) = $iColor Then
		_GDIPlus_RegionCombineRect($hRgn, $iX, $iY, 1, 1, 2)

		If $iX >= 0 Then _Util_MagicWandStep($hBitmap, $iX-1, $iY, $hRgn, $iColor)
		If $iX < _GDIPlus_ImageGetWidth($hBitmap) Then _Util_MagicWandStep($hBitmap, $iX+1, $iY, $hRgn, $iColor)
		If $iY >= 0 Then _Util_MagicWandStep($hBitmap, $iX, $iY-1, $hRgn, $iColor)
		If $iY < _GDIPlus_ImageGetHeight($hBitmap) Then _Util_MagicWandStep($hBitmap, $iX, $iY+1, $hRgn, $iColor)
	EndIf
EndFunc

Func _Util_SetNewSelection($hRegion)
	$oSelection = $oCurrentThread.thread.selections.at($oCurrentThread.thread.currentSelection)
	_GDIPlus_RegionDispose($oSelection.rgn)
	$oSelection.rgn = $hRegion

	$oCurrentThread.thread.selection = $oSelection.rgn
EndFunc

Func _Util_PopulateLayerListComboBox($hCombo, $iDesiredType)
	For $oLayer In $oCurrentThread.thread.layers
		If $oLayer.type = $iDesiredType Then
			_GUICtrlComboBox_AddString($hCombo, $oLayer.name)
		EndIf
	Next
EndFunc

Func _Util_LayerNameToObject($sName)
	Local $i = 0
	For $oLayer In $oCurrentThread.thread.layers
		If $oLayer.name = $sName Then Return SetExtended($i, $oLayer)
		$i += 1
	Next
	Return False
EndFunc

Func _Util_SelectionNameToObject($sName)
	Local $i = 0
	For $oSelection In $oCurrentThread.thread.selections
		If $oSelection.name = $sName Then Return SetExtended($i, $oSelection)
		$i += 1
	Next
	Return False
EndFunc

Func _Util_PathNameToObject($sName)
	Local $i = 0
	For $oSelection In $oCurrentThread.thread.paths
		If $oSelection.name = $sName Then Return SetExtended($i, $oSelection)
		$i += 1
	Next
	Return False
EndFunc

Func _Util_GenerateRandomPrefix($iLength = 7)
	Return StringTrimRight(StringTrimLeft(_TempFile("C:", "~", ".tmp", $iLength), 3), 4)
EndFunc

Func _Util_IsolateSelection()
	Local $ret[2]

	$hRgn1 = $oCurrentThread.thread.selection
	$hRgn2 = _GDIPlus_RegionCreate()
	_GDIPlus_RegionCombineRegion($hRgn2, $oCurrentThread.thread.selection, 3)

	$tBmp1 = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp1)
	_GDIPlus_GraphicsSetClipRegion($tGpx, $hRgn2)

	_GDIPlus_GraphicsDrawImageRect($tGpx, $oCurrentThread.thread.currentLayer.bmp, 0, 0, $oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)

	_GDIPlus_GraphicsDispose($tGpx)

	$tBmp2 = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp2)
	_GDIPlus_GraphicsSetClipRegion($tGpx, $hRgn1)

	_GDIPlus_GraphicsDrawImageRect($tGpx, $oCurrentThread.thread.currentLayer.bmp, 0, 0, $oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)

	_GDIPlus_GraphicsDispose($tGpx)

	$ret[0] = $tBmp1
	$ret[1] = $tBmp2

	Return $ret
EndFunc

Func _Util_ConvertClientToBitmap(ByRef $x, ByRef $y, $iSubtract = 1)
	$aPos = ControlGetPos($hMainUI, "", $cidDrawingArea)
	$cW = $aPos[2]
	$cH = $aPos[3]
	$iX = $x*$iSubtract
	$iY = $y*$iSubtract
	$iW = $oCurrentThread.thread.width*$oCurrentThread.zoom ; zoom in/out image
	$iH = $oCurrentThread.thread.height*$oCurrentThread.zoom
	$iX0 = ($cW-$iW)/2 + $oCurrentThread.viewDx*$oCurrentThread.zoom
	$iY0 = ($cH-$iH)/2 + $oCurrentThread.viewDy*$oCurrentThread.zoom
	$x = ($iX-$iX0)/$oCurrentThread.zoom
	$y = ($iY-$iY0)/$oCurrentThread.zoom

	If $iSnapToGrid Then
		$x = Round($x/8)*8
		$y = Round($y/8)*8
	EndIf

	If $isEasterEgg Then
		$x += Random(-100, 100)
		$y += Random(-100, 100)
	EndIf
EndFunc

Func _Util_ConvertBitmapToClient(ByRef $x, ByRef $y, $iAdd = 0)
	$aPos = ControlGetPos($hMainUI, "", $cidDrawingArea)
	$cW = $aPos[2]
	$cH = $aPos[3]

	$iW = Int($oCurrentThread.thread.width*$oCurrentThread.zoom) ; zoom in/out image
	$iH = Int($oCurrentThread.thread.height*$oCurrentThread.zoom)
	$iX = Int(($cW-$iW)/2 + $oCurrentThread.viewDx*$oCurrentThread.zoom) ; convert image coordinates (0, 0) to control coordinates
	$iY = Int(($cH-$iH)/2 + $oCurrentThread.viewDy*$oCurrentThread.zoom)

	$x = $iX + $x*$oCurrentThread.zoom+$aPos[0]*$iAdd
	$y = $iY + $y*$oCurrentThread.zoom+$aPos[1]*$iAdd

	If $isEasterEgg Then
		$x += Random(-100, 100)
		$y += Random(-100, 100)
	EndIf
EndFunc

Func _Util_GetCurrentGraphics()
	$tGpx = _GDIPlus_ImageGetGraphicsContext($oCurrentThread.thread.currentLayer.bmp)
	_GDIPlus_GraphicsSetSmoothingMode($tGpx, 5)
	_GDIPlus_GraphicsSetCompositingQuality($tGpx, 3)
	_GDIPlus_GraphicsSetPixelOffsetMode($tGpx, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)


	_GDIPlus_GraphicsSetClipRegion($tGpx, $oCurrentThread.thread.selection)

	Return $tGpx
EndFunc

Func _Util_CreateImage($iW, $iH)
	$oThread = _CreateThread($iW, $iH)

	$tBmp = _GDIPlus_BitmapCreateFromScan0($iW, $iH)
	$oLayer = _CreateImageLayer($tBmp)
	$oThread.addLayer($oLayer)

	$oThread.currentLayer = $oThread.getLayer(0)

	Return $oThread
EndFunc

Func _Util_CreateTransparencyGrid()
	$tBmp = _GDIPlus_BitmapCreateFromScan0(16, 16)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	$tBrush = _GDIPlus_BrushCreateSolid($isEasterEgg ? 0xFFCCFFCC : 0xFFFFFFFF)

	_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 8, 8, $tBrush)
	_GDIPlus_GraphicsFillRect($tGpx, 8, 8, 8, 8, $tBrush)

	_GDIPlus_BrushSetSolidColor($tBrush, $isEasterEgg ? 0xFFFFCCFF : 0xFFCCCCCC)

	_GDIPlus_GraphicsFillRect($tGpx, 0, 8, 8, 8, $tBrush)
	_GDIPlus_GraphicsFillRect($tGpx, 8, 0, 8, 8, $tBrush)

	_GDIPlus_BrushDispose($tBrush)

	_GDIPlus_GraphicsDispose($tGpx)
	$bTex = _GDIPlus_TextureCreate($tBmp)
	_GDIPlus_BitmapDispose($tBmp)

	Return $bTex
EndFunc

Func _Util_SecondsToTime($iSec)
	$iSec = Int($iSec) ; just a precaution
	$sRet = Int($iSec/60)
	If $sRet < 10 Then $sRet = "0"&$sRet
	$iSec = Mod($iSec, 60)
	$sRet &= ":"&StringRight("0"&$iSec, 2)

	Return $sRet
EndFunc

Func _Util_CreatePixelGrid()
	If $oCurrentThread.zoomGrid <> 0 Then _GDIPlus_BrushDispose($oCurrentThread.zoomGrid)

	$tTex = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.zoom, $oCurrentThread.zoom)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tTex)

	$tPen = _GDIPlus_PenCreate(0x50808080)
	_GDIPlus_GraphicsDrawRect($tGpx, -1, -1, $oCurrentThread.zoom, $oCurrentThread.zoom, $tPen)
	_GDIPlus_PenDispose($tPen)

	_GDIPlus_GraphicsDispose($tGpx)
	$oCurrentThread.zoomGrid = _GDIPlus_TextureCreate($tTex)
	_GDIPlus_BitmapDispose($tTex)
EndFunc

Func _Util_DrawFrame($hGpx, $hFrame, $iMTop, $iMLeft, $iMBottom, $iMRight, $iX, $iY, $iW, $iH)
	Local $iFW = _GDIPlus_ImageGetWidth($hFrame)
	Local $iFH = _GDIPlus_ImageGetHeight($hFrame)

	_GDIPlus_GraphicsDrawImageRectRect($hGpx, $hFrame, 0, 0, $iMLeft, $iMTop, $iX, $iY, $iMLeft, $iMTop)
	_GDIPlus_GraphicsDrawImageRectRect($hGpx, $hFrame, $iMLeft, 0, $iFW-$iMLeft-$iMRight, $iMTop, $iX+$iMLeft, $iY, $iW-$iMLeft-$iMRight, $iMTop)
	_GDIPlus_GraphicsDrawImageRectRect($hGpx, $hFrame, $iFW-$iMRight, 0, $iMRight, $iMTop, $iX+$iW-$iMRight, $iY, $iMRight, $iMTop)
	_GDIPlus_GraphicsDrawImageRectRect($hGpx, $hFrame, $iFW-$iMRight, $iMTop, $iMRight, $iFH-$iMTop-$iMBottom, $iX+$iW-$iMRight, $iY+$iMTop, $iMRight, $iH-$iMTop-$iMBottom+1)
	_GDIPlus_GraphicsDrawImageRectRect($hGpx, $hFrame, $iFW-$iMRight, $iFH-$iMBottom, $iMRight, $iMBottom, $iX+$iW-$iMRight, $iY+$iH-$iMBottom, $iMRight, $iMBottom)
	_GDIPlus_GraphicsDrawImageRectRect($hGpx, $hFrame, $iMLeft, $iFH-$iMBottom, $iFW-$iMLeft-$iMRight, $iMBottom, $iX+$iMLeft, $iY+$iH-$iMBottom, $iW-$iMLeft-$iMRight, $iMBottom)
	_GDIPlus_GraphicsDrawImageRectRect($hGpx, $hFrame, 0, $iFH-$iMBottom, $iMLeft, $iMBottom, $iX, $iY+$iH-$iMBottom, $iMLeft, $iMBottom)
	_GDIPlus_GraphicsDrawImageRectRect($hGpx, $hFrame, 0, $iMTop, $iMLeft, $iFH-$iMTop-$iMBottom, $iX, $iY+$iMTop, $iMLeft, $iH-$iMTop-$iMBottom+1)
EndFunc

Func _Util_Distance($iX1, $iY1, $iX2, $iY2)
	Return Sqrt(($iX1-$iX2)^2 + ($iY1-$iY2)^2)
EndFunc
