#include-once
Func _RenderDrawingArea_Gen()
	Switch $oCurrentThread.type
		Case $V4_TT_IMAGE
			_RenderDrawingArea()
		Case $V4_TT_AUDIO
			_RenderDrawingArea_Audio()
	EndSwitch
EndFunc

Func _RenderDrawingAreaD2D($aPos, $iTemporary, $cInfo, $iNoCtrlRepaint)
	$cW = $aPos[2]
	$cH = $aPos[3]

	$tTargetProps = _D2D1_CreateRenderTargetProperties($D2D1_RENDER_TARGET_TYPE_HARDWARE)
	$tHwndProps = _D2D1_CreateHWNDRenderTargetProperties(GUICtrlGetHandle($cidDrawingArea), $cW, $cH, 0)

	$oRenderTarget = _D2D1_CreateHWNDRenderTarget($oD2DFactory, $tTargetProps, $tHwndProps)

	_D2D1_BeginDraw($oRenderTarget)
	_D2D1_Clear($oRenderTarget, _D2D1_CreateColorF(0.76, 0.76, 0.76, 1))

	;$oWICFactory

	If IsObj($oCurrentThread) And IsObj($oCurrentThread.thread) Then
		$iW = Int($oCurrentThread.thread.width*$oCurrentThread.zoom) ; zoom in/out image
		$iH = Int($oCurrentThread.thread.height*$oCurrentThread.zoom)
		$iX = Int(($cW-$iW)/2 + $oCurrentThread.viewDx*$oCurrentThread.zoom) ; convert image coordinates (0, 0) to control coordinates
		$iY = Int(($cH-$iH)/2 + $oCurrentThread.viewDy*$oCurrentThread.zoom)
		If $oCurrentThread.zoom > 1 Then
			$iW += $oCurrentThread.zoom/2
			$iH += $oCurrentThread.zoom/2
		EndIf

		If $iViewportRenderEnabled = 0 Then
			If $iTemporary = 0 Then $oCurrentThread.thread.render(1)
			$hHBITMAP = _GDIPlus_BitmapCreateHBITMAPFromBitmap($oCurrentThread.thread.tempRender)

			$Shadow = _D2D1_CreateSolidBrush($oRenderTarget, _D2D1_CreateColorF(0, 0, 0, 0.3))

			; Shadow!!!! (kind of...)
			_D2D1_FillRect($oRenderTarget, _D2D1_CreateRectF($iX-1, $iY-1, $iW+2, $iH+2), $Shadow)

			$hD2DBitmap = _D2D1_CreateBitmapFromHBITMAP($oRenderTarget, $oWICFactory, $hHBITMAP)
			_D2D1_DrawBitmap($oRenderTarget, $hD2DBitmap, _D2D1_CreateRectF($iX, $iY, $iW, $iH))


			_WinAPI_DeleteObject($hHBITMAP)

			If $sNotificationHeader <> "" Then
				Switch $iNotificationType
					Case $V4_NT_INFORMATION
						$BkColor = _D2D1_CreateColorF(1, 1, 1, 0.9)
						$TxtColor = _D2D1_CreateColorF(0.08, 0.08, 0.08, 1)
					Case $V4_NT_SUCCESS
						$BkColor = _D2D1_CreateColorF(0.16, 0.71, 0, 0.9)
						$TxtColor = _D2D1_CreateColorF(1, 1, 1, 1)
					Case $V4_NT_ERROR
						$BkColor = _D2D1_CreateColorF(1, 0, 0, 0.9)
						$TxtColor = _D2D1_CreateColorF(1, 1, 1, 1)
				EndSwitch
				$bNotif = _D2D1_CreateSolidBrush($oRenderTarget, $BkColor)
				$bNotifText = _D2D1_CreateSolidBrush($oRenderTarget, $TxtColor)

				_D2D1_FillRect($oRenderTarget, _D2D1_CreateRectF(0, 0, $cW, 50), $bNotif)

				$oFormat = _DWrite_CreateTextFormat($oDWFactory, "Segoe UI", 0, 600, 0, 5, 14)
				$oTypography = _DWrite_CreateTypography($oDWFactory)
				$oTextLayout = _DWrite_CreateTextLayout($oDWFactory, $sNotificationHeader, $oFormat, $cW, $cH)

				_D2D1_DrawTextLayout($oRenderTarget, 10, 8, $oTextLayout, $bNotifText)

				$oFormat = _DWrite_CreateTextFormat($oDWFactory, "Segoe UI", 0, 350, 0, 5, 14)
				$oTypography = _DWrite_CreateTypography($oDWFactory)
				$oTextLayout = _DWrite_CreateTextLayout($oDWFactory, $sNotificationContent, $oFormat, $cW, $cH)

				_D2D1_DrawTextLayout($oRenderTarget, 10, 25, $oTextLayout, $bNotifText)
			EndIf

			If $iNoCtrlRepaint Then ; draw HUD pointer
				$iHudX = $cInfo[0]-$aPos[0]
				$iHudY = $cInfo[1]-$aPos[1]
				If $oCurrentTool.supportsD2DHUD Then $oCurrentTool.drawD2DHUD($oRenderTarget, $iHudX, $iHudY)
			EndIf
		Else
			If $oCurrentThread.compBmp <> 0 Then
				$BkColor = _D2D1_CreateColorF(1, 0, 0, 0.9)
				$TxtColor = _D2D1_CreateColorF(1, 1, 1, 1)

				$bNotif = _D2D1_CreateSolidBrush($oRenderTarget, $BkColor)
				$bNotifText = _D2D1_CreateSolidBrush($oRenderTarget, $TxtColor)

				_D2D1_FillRect($oRenderTarget, _D2D1_CreateRectF(0, 0, $cW, 50), $bNotif)

				$oFormat = _DWrite_CreateTextFormat($oDWFactory, "Segoe UI", 0, 600, 0, 5, 14)
				$oTypography = _DWrite_CreateTypography($oDWFactory)
				$oTextLayout = _DWrite_CreateTextLayout($oDWFactory, "Not yet supported", $oFormat, $cW, $cH)

				_D2D1_DrawTextLayout($oRenderTarget, 10, 8, $oTextLayout, $bNotifText)

				$oFormat = _DWrite_CreateTextFormat($oDWFactory, "Segoe UI", 0, 350, 0, 5, 14)
				$oTypography = _DWrite_CreateTypography($oDWFactory)
				$oTextLayout = _DWrite_CreateTextLayout($oDWFactory, "Compositing preview is not yet supported in the Direct2D-rendered viewport.", $oFormat, $cW, $cH)

				_D2D1_DrawTextLayout($oRenderTarget, 10, 25, $oTextLayout, $bNotifText)
			EndIf
		EndIf
	EndIf

	_D2D1_EndDraw($oRenderTarget)
EndFunc

; render image viewport
Func _RenderDrawingArea($iTemporary = 0, $cInfo = 0, $iNoCtrlRepaint = 0)
	If $isClosing Then Return 0
	If $isWorkingOnHistory Then Return 0

	If $cInfo = 0 Then $cInfo = GUIGetCursorInfo($hMainUI)

	$aPos = ControlGetPos($hMainUI, "", $cidDrawingArea)
	; before we start
	$cW = $aPos[2]
	$cH = $aPos[3]

	If $v4Setting_GraphicLibrary = $V4_LIBRARY_DIRECT2D Then Return _RenderDrawingAreaD2D($aPos, $iTemporary, $cInfo, $iNoCtrlRepaint)

	; we make a bitmap to store our render
	$tRenderBmp = _GDIPlus_BitmapCreateFromScan0($aPos[2], $aPos[3])
	; and a graphics object
	$tRenderGpx = _GDIPlus_ImageGetGraphicsContext($tRenderBmp)
	_GDIPlus_GraphicsSetInterpolationMode($tRenderGpx, 5)
	_GDIPlus_GraphicsClear($tRenderGpx, 0xFFC0C0C0) ; make it gray
	; if we have an image, ...
	If IsObj($oCurrentThread) And IsObj($oCurrentThread.thread) Then
		; ... we render
		$iW = Int($oCurrentThread.thread.width*$oCurrentThread.zoom) ; zoom in/out image
		$iH = Int($oCurrentThread.thread.height*$oCurrentThread.zoom)
		$iX = Int(($cW-$iW)/2 + $oCurrentThread.viewDx*$oCurrentThread.zoom) ; convert image coordinates (0, 0) to control coordinates
		$iY = Int(($cH-$iH)/2 + $oCurrentThread.viewDy*$oCurrentThread.zoom)
		If $oCurrentThread.zoom > 1 Then
			$iW += $oCurrentThread.zoom/2
			$iH += $oCurrentThread.zoom/2
		EndIf

		;_GDIPlus_GraphicsFillRect($tRenderGpx, $iX, $iY, $iW, $iH, $hTransparency)
		If $iViewportRenderEnabled = 0 Then
			If $iTemporary = 0 Then $oCurrentThread.thread.render(1)
			_GDIPlus_GraphicsDrawImageRect($tRenderGpx, $oCurrentThread.thread.tempRender, $iX, $iY, $iW, $iH)

			; Shadow!!!!
			_Util_DrawFrame($tRenderGpx, $hViewportShadow, 32, 32, 32, 32, $iX-32, $iY-32, $iW+64, $iH+64)

			If $sNotificationHeader <> "" Then
				$hBlurFX = _GDIPlus_EffectCreateBlur(20)
				_GDIPlus_BitmapApplyEffect($tRenderBmp, $hBlurFX, _WinAPI_CreateRect(0, 0, $cW, 50))
				_GDIPlus_EffectDispose($hBlurFX)
				Switch $iNotificationType
					Case $V4_NT_INFORMATION
						$iBkColor = 0xB0FFFFFF
						$iTxtColor = 0xFF111111
					Case $V4_NT_SUCCESS
						$iBkColor = 0xB02AB400
						$iTxtColor = 0xFFFFFFFF
					Case $V4_NT_ERROR
						$iBkColor = 0xB0FF0000
						$iTxtColor = 0xFFFFFFFF
				EndSwitch
				$bNotif = _GDIPlus_BrushCreateSolid($iBkColor)
				_GDIPlus_GraphicsFillRect($tRenderGpx, 0, 0, $cW, 50, $bNotif)
				_GDIPlus_BrushDispose($bNotif)
				_GDIPlus_GraphicsDrawString_($tRenderGpx, $sNotificationHeader, 10, 8, "Segoe UI Semibold", 10, 0, 0, $iTxtColor)
				_GDIPlus_GraphicsDrawString_($tRenderGpx, $sNotificationContent, 10, 25, "Segoe UI Semilight", 10, 0, 0, $iTxtColor)
			EndIf
			_GDIPlus_GraphicsSetSmoothingMode($tRenderGpx, 5)
			If $iNoCtrlRepaint Then ; draw HUD pointer
				$iHudX = $cInfo[0]-$aPos[0]
				$iHudY = $cInfo[1]-$aPos[1]
				$oCurrentTool.drawHUD($tRenderGpx, $iHudX, $iHudY)
			EndIf
		Else
			If $oCurrentThread.compBmp <> 0 Then
				_GDIPlus_GraphicsFillRect($tRenderGpx, $iX, $iY, $iW, $iH, $hTransparency)
				_GDIPlus_GraphicsDrawImageRect($tRenderGpx, $oCurrentThread.compBmp, $iX, $iY, $iW, $iH)

				; Shadow!!!!
				_Util_DrawFrame($tRenderGpx, $hViewportShadow, 32, 32, 32, 32, $iX-32, $iY-32, $iW+64, $iH+64)
			EndIf
			If $sNotificationHeader <> "" Then
				$hBlurFX = _GDIPlus_EffectCreateBlur(20)
				_GDIPlus_BitmapApplyEffect($tRenderBmp, $hBlurFX, _WinAPI_CreateRect(0, 0, $cW, 50))
				_GDIPlus_EffectDispose($hBlurFX)
				Switch $iNotificationType
					Case $V4_NT_INFORMATION
						$iBkColor = 0xB0FFFFFF
						$iTxtColor = 0xFF111111
					Case $V4_NT_SUCCESS
						$iBkColor = 0xB02AB400
						$iTxtColor = 0xFFFFFFFF
					Case $V4_NT_ERROR
						$iBkColor = 0xB0FF0000
						$iTxtColor = 0xFFFFFFFF
				EndSwitch
				$bNotif = _GDIPlus_BrushCreateSolid($iBkColor)
				_GDIPlus_GraphicsFillRect($tRenderGpx, 0, 0, $cW, 50, $bNotif)
				_GDIPlus_BrushDispose($bNotif)
				_GDIPlus_GraphicsDrawString_($tRenderGpx, $sNotificationHeader, 10, 8, "Segoe UI Semibold", 10, 0, 0, $iTxtColor)
				_GDIPlus_GraphicsDrawString_($tRenderGpx, $sNotificationContent, 10, 25, "Segoe UI Semilight", 10, 0, 0, $iTxtColor)
			EndIf
		EndIf
	EndIf

	; we don't need graphics
	_GDIPlus_GraphicsDispose($tRenderGpx)
	If $iNoCtrlRepaint Then
		$hGUIGpx = _GDIPlus_GraphicsCreateFromHWND($hMainUI)
		_GDIPlus_GraphicsDrawImageRect($hGUIGpx, $tRenderBmp, $aPos[0], $aPos[1], $cW, $cH)
		_GDIPlus_GraphicsDispose($hGUIGpx)
	Else
		; we'll use _SetCtrlBmp from IconButtons.au3
		_SetCtrlBmp($cidDrawingArea, $tRenderBmp)
	EndIf

	; done!
	_GDIPlus_BitmapDispose($tRenderBmp)
EndFunc

; render audio viewport
Func _RenderDrawingArea_Audio($iTemporary = 0, $cInfo = 0, $iNoCtrlRepaint = 0)
	If $isClosing Then Return 0

	; before we start
	$cW = _WinAPI_GetClientWidth($hMainUI)
	$cH = _WinAPI_GetClientHeight($hMainUI)
	; we make a bitmap to store our render
	$tRenderBmp = _GDIPlus_BitmapCreateFromScan0($cW-40, $cH-89)
	; and a graphics object
	$tRenderGpx = _GDIPlus_ImageGetGraphicsContext($tRenderBmp)
	_GDIPlus_GraphicsSetInterpolationMode($tRenderGpx, 5)
	_GDIPlus_GraphicsClear($tRenderGpx, 0xFFC0C0C0) ; make it gray
	_GDIPlus_GraphicsSetSmoothingMode($tRenderGpx, 5)
	$cW -= 40
	$cH -= 89 ; to make math more clear

	; if we have an audio thread, we render
	If IsObj($oCurrentThread) Then
		; from Tiles UDF
		_GDIPlus_GraphicsDrawString_($tRenderGpx, $oCurrentThread.name, 30, 30, "Segoe UI Semilight", 24, 0, 0, 0xFF444444)
		$pos = _BASS_ChannelBytes2Seconds($oCurrentThread.stream, _BASS_ChannelGetPosition($oCurrentThread.stream, $BASS_POS_BYTE))
		$len = $oCurrentThread.length
		_GDIPlus_GraphicsDrawString_($tRenderGpx, _Util_SecondsToTime($pos)&" / "&_Util_SecondsToTime($len), 30, 60, "Segoe UI Semilight", 18, 0, 0, 0xFF666666)
		If $oCurrentThread.isPlaying Then
			$tFft = DllStructCreate("float[128]")
			_BASS_ChannelGetData($oCurrentThread.stream, DllStructGetPtr($tFft), $BASS_DATA_FFT256+$BASS_DATA_FFT_NOWINDOW)
			Local $aPoints[1][2] = [[0, 0]]
			$tPen = _GDIPlus_PenCreate(0xFF808080, 4)
			_GDIPlus_PenSetLineCap($tPen, 2, 2, 2)
			$tPath = _GDIPlus_PathCreate()
			For $i = 1 To 128 Step +8
				$x = ($i/128)*$cW
				$fVal = DllStructGetData($tFft, 1, $i)
				$fVal = Sqrt($fVal)
				$y = 300 - $fVal*125
				Local $arr[1][2] = [[$x, $y]]
				_ArrayAdd($aPoints, $arr)
				$aPoints[0][0] += 1
			Next
			_GDIPlus_PathAddCurve($tPath, $aPoints)
			_GDIPlus_GraphicsDrawPath($tRenderGpx, $tPath, $tPen)
			_GDIPlus_PathDispose($tPath)
			_GDIPlus_PenDispose($tPen)
		EndIf
	EndIf

	; we don't need graphics
	_GDIPlus_GraphicsDispose($tRenderGpx)
	If $iNoCtrlRepaint Then
		$hGUIGpx = _GDIPlus_GraphicsCreateFromHWND($hMainUI)
		_GDIPlus_GraphicsDrawImageRect($hGUIGpx, $tRenderBmp, 0, 84, $cW, $cH)
		_GDIPlus_GraphicsDispose($hGUIGpx)
	Else
		; we'll use _SetCtrlBmp from IconButtons.au3
		_SetCtrlBmp($cidDrawingArea, $tRenderBmp)
	EndIf

	; done!
	_GDIPlus_BitmapDispose($tRenderBmp)
EndFunc
