#include-once

Func _Pixelize($iStep, ByRef $hBmp)
	$tBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	_ProgressOn("Applying effect...", "Row 0 of "&Int($oCurrentThread.thread.currentLayer.width/$iStep))

	For $x = 0 To $oCurrentThread.thread.currentLayer.width Step $iStep
		For $y = 0 To $oCurrentThread.thread.currentLayer.height Step $iStep
			$pixel = _GDIPlus_BitmapGetPixel($hBmp, $x+$iStep/2, $y+$iStep/2)

			$tBrush = _GDIPlus_BrushCreateSolid($pixel)
			_GDIPlus_GraphicsFillRect($tGpx, $x, $y, $iStep, $iStep, $tBrush)
			_GDIPlus_BrushDispose($tBrush)
		Next
		_ProgressSet("Applying effect...", "Row "&Int($x/$iStep+1)&" of "&Int($oCurrentThread.thread.currentLayer.width/$iStep), 100*Int($x/$iStep+1)/Int($oCurrentThread.thread.currentLayer.width/$iStep))
	Next

	_ProgressOff()

	_GDIPlus_GraphicsDispose($tGpx)
	_GDIPlus_BitmapDispose($hBmp)
	$hBmp = $tBmp
EndFunc

Func _Pixelize_Event()
	If Not $isOpen Then Return 0

	$hBmp = $oCurrentThread.thread.currentLayer.bmp
	_Pixelize(10, $hBmp)
	$oCurrentThread.thread.currentLayer.bmp = $hBmp

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc
