#include-once
#include <GUIConstants.au3>
#include <Array.au3>
#include <WinAPI.au3>
#include <GDIPlus.au3>
#include <Date.au3>

#include "TilesConstants.au3"
#include "TilesProperties.au3"

#include "TilesButtons.au3"

; #INDEX# =======================================================================================================================
; Title .........: Tiles
; AutoIt Version : 3.3.10.2++
; Description ...: Creating and management of Windows 8-8.1 tile-like GUI controls.
; Author(s) .....: scintilla4evr
; UDF Version ...: 1.0
; ===============================================================================================================================

; #VARIABLES# ===================================================================================================================
Global $__Tiles_aTileObjectList[1] = [0]
Global $__Tiles_iStyle = $TS_WINDOWS8
Global $__Tiles_fScale = 1
Global $__Tiles_iTextRenderingHint = 5
; ===============================================================================================================================

#Region Startup

Func _Tiles_Startup()
	_GDIPlus_Startup()
	_AutoItObject_Startup()
	Return True
EndFunc

Func _Tiles_Shutdown($bShutdownUDFS = True)
	If _Tiles_GetTileCount() <> 0 Then
		For $i = 1 To _Tiles_GetTileCount()
			_Tiles_DeleteTileByIndex($i)
		Next
	EndIf

	If $bShutdownUDFS Then _GDIPlus_Shutdown()
	If $bShutdownUDFS Then _AutoItObject_Shutdown()
	Return True
EndFunc

Func _Tiles_SetStyle($iStyle)
	$__Tiles_iStyle = $iStyle
EndFunc

#EndRegion

#Region Settings

Func _Tiles_SetTileBkColor($cidCtrl, $iColor)
	Local $oObj = $__Tiles_aTileObjectList[_Tiles_GetTileIndexFromCtrl($cidCtrl)]

	$oObj.color = $iColor
	$oObj.RenderTile($TEV_NORMAL)
EndFunc

Func _Tiles_SetTileProps($cidCtrl, $hProps = 0)
	Local $oObj = $__Tiles_aTileObjectList[_Tiles_GetTileIndexFromCtrl($cidCtrl)]

	$oObj.props = $hProps
	$oObj.RenderTile($TEV_NORMAL)

EndFunc

Func _Tiles_RepaintTile($cidCtrl)
	Local $oObj = $__Tiles_aTileObjectList[_Tiles_GetTileIndexFromCtrl($cidCtrl)]

	$oObj.RenderTile($TEV_NORMAL)
EndFunc

#EndRegion

#Region Tile Deleting, Retrieving Informations

Func _Tiles_DeleteTileByIndex($iIndex)
	Local $oObj
	If $iIndex > (UBound($__Tiles_aTileObjectList)-1) Then Return False

	$oObj = $__Tiles_aTileObjectList[$iIndex]
	$oObj.DisposeData()

	_ArrayDelete($__Tiles_aTileObjectList, $iIndex)
	$__Tiles_aTileObjectList[0] -= 1
	Return True
EndFunc

Func _Tiles_DeleteTile($cidCtrl)
	Local $oObj
	Local $iIndex = _Tiles_GetTileIndexFromCtrl($cidCtrl)
	If $iIndex > (UBound($__Tiles_aTileObjectList)-1) Then Return False

	$oObj = $__Tiles_aTileObjectList[$iIndex]
	$oObj.DisposeData()

	_ArrayDelete($__Tiles_aTileObjectList, $iIndex)
	$__Tiles_aTileObjectList[0] -= 1
	Return True
EndFunc

Func _Tiles_DeleteTileByName($sName)
	Local $oObj
	If $__Tiles_aTileObjectList[0] = 0 Then Return False

	For $i = 1 To $__Tiles_aTileObjectList[0]
		$oObj = $__Tiles_aTileObjectList[$i]
		If $oObj.name = $sName Then Return _Tiles_DeleteTileByIndex($i)
	Next

	Return True
EndFunc

Func _Tiles_GetTileIndexFromCtrl($cidCtrl)
	Local $oObj

	If _Tiles_GetTileCount() = 0 Then Return False

	For $i = 1 To _Tiles_GetTileCount()
		$oObj = $__Tiles_aTileObjectList[$i]
		If $oObj.ctrl = $cidCtrl Then Return $i
	Next

	Return False
EndFunc

Func _Tiles_GetTileCount()
	Return $__Tiles_aTileObjectList[0]
EndFunc

#EndRegion

#Region Tile Creation

Func _Tiles_CreateLegacyTile($sName, $sText, $sIcon, $iColor, $iX, $iY)
	Local $cidTile, $oObj

	$cidTile = GUICtrlCreateLabel($sText, $iX, $iY, 150*$__Tiles_fScale, 150*$__Tiles_fScale, $SS_BITMAP)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKTOP+$GUI_DOCKSIZE)
	GUICtrlSetTip(-1, $sText)

	$oObj = _AutoItObject_Create()
	_AutoItObject_AddProperty($oObj, "ctrl", Default, $cidTile)
	_AutoItObject_AddProperty($oObj, "name", Default, $sName)
	_AutoItObject_AddProperty($oObj, "text", Default, $sText)
	_AutoItObject_AddProperty($oObj, "icon", Default, (IsString($sIcon) ? _GDIPlus_ImageLoadFromFile($sIcon) : $sIcon))
	_AutoItObject_AddProperty($oObj, "color", Default, $iColor)

	_AutoItObject_AddMethod($oObj, "DisposeData", "__Tiles_LegacyTile_DisposeData")
	_AutoItObject_AddMethod($oObj, "RenderTile", "__Tiles_LegacyTile_RenderTile")

	$oObj.RenderTile($TEV_NORMAL)
	_GUICtrl_OnHoverRegister($cidTile, "_Tiles_RenderOnHoverLeave", "_Tiles_RenderOnHoverLeave", "_Tiles_RenderOnPress", "_Tiles_RenderOnPress")

	_ArrayAdd($__Tiles_aTileObjectList, $oObj)
	$__Tiles_aTileObjectList[0] += 1

	Return $cidTile
EndFunc

Func _Tiles_CreateGeneralTile($sName, $sText, $sIcon, $iColor, $iX, $iY, $oTileProps = 0)
	Local $cidTile, $oObj

	$cidTile = GUICtrlCreateLabel($sText, $iX, $iY, 150*$__Tiles_fScale, 150*$__Tiles_fScale, $SS_BITMAP, $WS_EX_COMPOSITED)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKTOP+$GUI_DOCKSIZE)
	GUICtrlSetTip(-1, $sText)

	$oObj = _AutoItObject_Create()
	_AutoItObject_AddProperty($oObj, "ctrl", Default, $cidTile)
	_AutoItObject_AddProperty($oObj, "name", Default, $sName)
	_AutoItObject_AddProperty($oObj, "text", Default, $sText)
	_AutoItObject_AddProperty($oObj, "icon", Default, (IsString($sIcon) ? _GDIPlus_ImageLoadFromFile($sIcon) : $sIcon))
	_AutoItObject_AddProperty($oObj, "color", Default, $iColor)
	_AutoItObject_AddProperty($oObj, "props", Default, _Tiles_PropertiesClone($oTileProps))

	_AutoItObject_AddMethod($oObj, "DisposeData", "__Tiles_GenTile_DisposeData")
	_AutoItObject_AddMethod($oObj, "RenderTile", "__Tiles_GenTile_RenderTile")

	$oObj.RenderTile($TEV_NORMAL)
	_GUICtrl_OnHoverRegister($cidTile, "_Tiles_RenderOnHoverLeave", "_Tiles_RenderOnHoverLeave", "_Tiles_RenderOnPress", "_Tiles_RenderOnPress")

	_ArrayAdd($__Tiles_aTileObjectList, $oObj)
	$__Tiles_aTileObjectList[0] += 1

	Return $cidTile
EndFunc

Func _Tiles_CreateWideTile($sName, $sText, $sIcon, $iColor, $iX, $iY, $oTileProps = 0)
	Local $cidTile, $oObj

	$cidTile = GUICtrlCreateLabel($sText, $iX, $iY, 310*$__Tiles_fScale, 150*$__Tiles_fScale, $SS_BITMAP)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKTOP+$GUI_DOCKSIZE)
	GUICtrlSetTip(-1, $sText)

	$oObj = _AutoItObject_Create()
	_AutoItObject_AddProperty($oObj, "ctrl", Default, $cidTile)
	_AutoItObject_AddProperty($oObj, "name", Default, $sName)
	_AutoItObject_AddProperty($oObj, "text", Default, $sText)
	_AutoItObject_AddProperty($oObj, "icon", Default, (IsString($sIcon) ? _GDIPlus_ImageLoadFromFile($sIcon) : $sIcon))
	_AutoItObject_AddProperty($oObj, "color", Default, $iColor)
	_AutoItObject_AddProperty($oObj, "props", Default, _Tiles_PropertiesClone($oTileProps))

	_AutoItObject_AddMethod($oObj, "DisposeData", "__Tiles_GenTile_DisposeData")
	_AutoItObject_AddMethod($oObj, "RenderTile", "__Tiles_GenTileW_RenderTile")

	$oObj.RenderTile($TEV_NORMAL)
	_GUICtrl_OnHoverRegister($cidTile, "_Tiles_RenderOnHoverLeave", "_Tiles_RenderOnHoverLeave", "_Tiles_RenderOnPress", "_Tiles_RenderOnPress")

	_ArrayAdd($__Tiles_aTileObjectList, $oObj)
	$__Tiles_aTileObjectList[0] += 1

	Return $cidTile
EndFunc

Func _Tiles_CreateLargeTile($sName, $sText, $sIcon, $iColor, $iX, $iY, $oTileProps = 0)
	Local $cidTile, $oObj

	$cidTile = GUICtrlCreateLabel($sText, $iX, $iY, 310*$__Tiles_fScale, 310*$__Tiles_fScale, $SS_BITMAP)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKTOP+$GUI_DOCKSIZE)
	GUICtrlSetTip(-1, $sText)

	$oObj = _AutoItObject_Create()
	_AutoItObject_AddProperty($oObj, "ctrl", Default, $cidTile)
	_AutoItObject_AddProperty($oObj, "name", Default, $sName)
	_AutoItObject_AddProperty($oObj, "text", Default, $sText)
	_AutoItObject_AddProperty($oObj, "icon", Default, (IsString($sIcon) ? _GDIPlus_ImageLoadFromFile($sIcon) : $sIcon))
	_AutoItObject_AddProperty($oObj, "color", Default, $iColor)
	_AutoItObject_AddProperty($oObj, "props", Default, _Tiles_PropertiesClone($oTileProps))

	_AutoItObject_AddMethod($oObj, "DisposeData", "__Tiles_GenTile_DisposeData")
	_AutoItObject_AddMethod($oObj, "RenderTile", "__Tiles_GenTileL_RenderTile")

	$oObj.RenderTile($TEV_NORMAL)
	_GUICtrl_OnHoverRegister($cidTile, "_Tiles_RenderOnHoverLeave", "_Tiles_RenderOnHoverLeave", "_Tiles_RenderOnPress", "_Tiles_RenderOnPress")

	_ArrayAdd($__Tiles_aTileObjectList, $oObj)
	$__Tiles_aTileObjectList[0] += 1

	Return $cidTile
EndFunc

Func _Tiles_CreateSmallTile($sName, $sText, $sIcon, $iColor, $iX, $iY)
	Local $cidTile, $oObj

	$cidTile = GUICtrlCreateLabel($sText, $iX, $iY, 70*$__Tiles_fScale, 70*$__Tiles_fScale, $SS_BITMAP)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKTOP+$GUI_DOCKSIZE)
	GUICtrlSetTip(-1, $sText)

	$oObj = _AutoItObject_Create()
	_AutoItObject_AddProperty($oObj, "ctrl", Default, $cidTile)
	_AutoItObject_AddProperty($oObj, "name", Default, $sName)
	_AutoItObject_AddProperty($oObj, "text", Default, $sText)
	_AutoItObject_AddProperty($oObj, "icon", Default, (IsString($sIcon) ? _GDIPlus_ImageLoadFromFile($sIcon) : $sIcon))
	_AutoItObject_AddProperty($oObj, "color", Default, $iColor)

	_AutoItObject_AddMethod($oObj, "DisposeData", "__Tiles_GenTile_DisposeData")
	_AutoItObject_AddMethod($oObj, "RenderTile", "__Tiles_GenTileS_RenderTile")

	$oObj.RenderTile($TEV_NORMAL)
	_GUICtrl_OnHoverRegister($cidTile, "_Tiles_RenderOnHoverLeave", "_Tiles_RenderOnHoverLeave", "_Tiles_RenderOnPress", "_Tiles_RenderOnPress")

	_ArrayAdd($__Tiles_aTileObjectList, $oObj)
	$__Tiles_aTileObjectList[0] += 1

	Return $cidTile
EndFunc

#EndRegion

#Region LegacyTile

Func __Tiles_LegacyTile_DisposeData($obj)
	_GDIPlus_ImageDispose($obj.icon)
EndFunc

Func __Tiles_LegacyTile_RenderTile($obj, $event)
	Local $tBmp = _GDIPlus_BitmapCreateFromScan0(150*$__Tiles_fScale, 150*$__Tiles_fScale)

	Local $tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)
	_GDIPlus_GraphicsClear($tGpx, $obj.color)
	_GDIPlus_GraphicsSetTextRenderingHint($tGpx, $__Tiles_iTextRenderingHint)

	Local $aSize = _StringSize(String($obj.text), 16*$__Tiles_fScale, 400, 0, "Segoe UI Semilight", 120)
	_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 14, 19, "Segoe UI Semilight", 16*$__Tiles_fScale, 0, 0, 0xFFFFFFFF)

	_GDIPlus_GraphicsDrawImageRect($tGpx, $obj.icon, 19, 109*$__Tiles_fScale, 32*$__Tiles_fScale, 32*$__Tiles_fScale)

	If $event = $TEV_HOVER Then
		Local $tBrush = _GDIPlus_BrushCreateSolid(0x10FFFFFF)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 150*$__Tiles_fScale, 150*$__Tiles_fScale, $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	ElseIf $event = $TEV_PRESSED Then
		Local $tBrush = _GDIPlus_BrushCreateSolid(0x10000000)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 150*$__Tiles_fScale, 150*$__Tiles_fScale, $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	EndIf

	If $__Tiles_iStyle <> $TS_FLAT Then
		Local $tBrush = _GDIPlus_LineBrushCreate(0, 0, 150*$__Tiles_fScale, 0, 0, 0x0FFFFFFF)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 150*$__Tiles_fScale, 150*$__Tiles_fScale, $tBrush)
		_GDIPlus_BrushDispose($tBrush)

		Local $tPen = _GDIPlus_PenCreate(0x1FFFFFFF, 1)
		_GDIPlus_GraphicsDrawRect($tGpx, 0, 0, 149*$__Tiles_fScale, 149*$__Tiles_fScale, $tPen)
		_GDIPlus_PenDispose($tPen)
	EndIf

	_GDIPlus_GraphicsDispose($tGpx)

	Local $tHbmp = _GDIPlus_BitmapCreateHBITMAPFromBitmap($tBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $tHbmp))
	_WinAPI_DeleteObject($tHbmp)

	_GDIPlus_BitmapDispose($tBmp)
EndFunc

#EndRegion

#Region GenTile & GenTileW

Func __Tiles_GenTile_DisposeData($obj)
	_GDIPlus_ImageDispose($obj.icon)
EndFunc

Func __Tiles_GenTile_RenderTile($obj, $event)
	Local $tBmp = _GDIPlus_BitmapCreateFromScan0(150*$__Tiles_fScale, 150*$__Tiles_fScale)

	Local $tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)
	_GDIPlus_GraphicsClear($tGpx, $obj.color)
	_GDIPlus_GraphicsSetTextRenderingHint($tGpx, $__Tiles_iTextRenderingHint)

	If Not $obj.props.list And Not $obj.props.daymonth Then _GDIPlus_GraphicsDrawImageRect($tGpx, $obj.icon, 0, 0, 150*$__Tiles_fScale, 150*$__Tiles_fScale)

	If $obj.props.smallicon Then
		Local $tIcon = _GDIPlus_ImageLoadFromFile($obj.props.iconsrc)
		_GDIPlus_GraphicsDrawImageRect($tGpx, $tIcon, 19, 109*$__Tiles_fScale, 30*$__Tiles_fScale, 30*$__Tiles_fScale)
		_GDIPlus_ImageDispose($tIcon)
	Else
		$str = $obj.props.altname ? $obj.props.altnamedata : $obj.text
		Local $aSize = _StringSize(String($str), 9, 400, 0, "Segoe UI Semilight", 120*$__Tiles_fScale)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 14*$__Tiles_fScale, 145*$__Tiles_fScale-$aSize[3], "Segoe UI Semilight", 9, 0, 0, 0xFFFFFFFF)
	EndIf

	If $obj.props.list And Not $obj.props.daymonth Then
		Local $aSize = _StringSize(String($obj.props.listdata), 9, 400, 0, "Segoe UI", 120*$__Tiles_fScale)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 14*$__Tiles_fScale, 14*$__Tiles_fScale+($obj.props.header*24), "Segoe UI", 9, 0, 0, 0xFFFFFFFF)
	EndIf

	If $obj.props.header And Not $obj.props.daymonth Then
		Local $aSize = _StringSize(String($obj.props.headerdata), 14, 400, 0, "Segoe UI Light", 120*$__Tiles_fScale)
		Local $aSplit = StringSplit($aSize[0], @CRLF, 1)
		_GDIPlus_GraphicsDrawString_($tGpx, ($obj.props.list) ? $aSplit[1] : $aSize[0], 12*$__Tiles_fScale, 12*$__Tiles_fScale, "Segoe UI Light", 14, 0, 0, 0xFFFFFFFF)
	EndIf

	If $obj.props.daymonth Then
		Local $aSize = _StringSize(String($obj.props.daymonth_txt1), 48*$__Tiles_fScale, 400, 0, "Segoe UI Light", 120*$__Tiles_fScale)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 6*$__Tiles_fScale, 4*$__Tiles_fScale, "Segoe UI Light", 48*$__Tiles_fScale, 0, 0, 0xFFFFFFFF)

		Local $aSize = _StringSize(String($obj.props.daymonth_txt2), 9, 400, 0, "Segoe UI", 120*$__Tiles_fScale)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 14*$__Tiles_fScale, 80*$__Tiles_fScale, "Segoe UI", 9, 0, 0, 0xFFFFFFFF)
	EndIf

	If $obj.props.badge Then
		Local $tBrush = _GDIPlus_BrushCreateSolid($obj.color)
		_GDIPlus_GraphicsFillRect($tGpx, 107*$__Tiles_fScale, 120*$__Tiles_fScale, 35, 30, $tBrush)
		_GDIPlus_BrushDispose($tBrush)

		Local $aSize = _StringSize(String($obj.props.badgedata), 10, 800, 0, "Segoe UI", 35)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 104*$__Tiles_fScale+(35-$aSize[2])/2, 120*$__Tiles_fScale+(30-$aSize[3])/2, "Segoe UI", 10, 1, 0, 0xFFFFFFFF)
	EndIf

	If $event = $TEV_HOVER Then
		Local $tBrush = _GDIPlus_BrushCreateSolid(0x10FFFFFF)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 150*$__Tiles_fScale, 150*$__Tiles_fScale, $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	ElseIf $event = $TEV_PRESSED Then
		Local $tBrush = _GDIPlus_BrushCreateSolid(0x10000000)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 150*$__Tiles_fScale, 150*$__Tiles_fScale, $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	EndIf

	If $__Tiles_iStyle <> $TS_FLAT Then
		Local $tBrush = _GDIPlus_LineBrushCreate(0, 0, 150, 0, 0, 0x0FFFFFFF)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 150*$__Tiles_fScale, 150*$__Tiles_fScale, $tBrush)
		_GDIPlus_BrushDispose($tBrush)

		Local $tPen = _GDIPlus_PenCreate(0x1FFFFFFF, 1)
		_GDIPlus_GraphicsDrawRect($tGpx, 0, 0, 149*$__Tiles_fScale, 149*$__Tiles_fScale, $tPen)
		_GDIPlus_PenDispose($tPen)
	EndIf

	_GDIPlus_GraphicsDispose($tGpx)

	Local $tHbmp = _GDIPlus_BitmapCreateHBITMAPFromBitmap($tBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $tHbmp))
	_WinAPI_DeleteObject($tHbmp)

	_GDIPlus_BitmapDispose($tBmp)
EndFunc

Func __Tiles_GenTileW_RenderTile($obj, $event)
	Local $tBmp = _GDIPlus_BitmapCreateFromScan0(310*$__Tiles_fScale, 150*$__Tiles_fScale)

	Local $tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)
	_GDIPlus_GraphicsClear($tGpx, $obj.color)
	_GDIPlus_GraphicsSetTextRenderingHint($tGpx, $__Tiles_iTextRenderingHint)

	_GDIPlus_GraphicsDrawImageRect($tGpx, $obj.icon, 0, 0, 310*$__Tiles_fScale, 150*$__Tiles_fScale)

	If $obj.props.smallicon Then
		Local $tIcon = _GDIPlus_ImageLoadFromFile($obj.props.iconsrc)
		_GDIPlus_GraphicsDrawImageRect($tGpx, $tIcon, 19, 109, 32, 32)
		_GDIPlus_ImageDispose($tIcon)
	Else
		Local $aSize = _StringSize(String($obj.text), 9, 400, 0, "Segoe UI Semilight", 280)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 14*$__Tiles_fScale, 145*$__Tiles_fScale-$aSize[3], "Segoe UI Semilight", 9, 0, 0, 0xFFFFFFFF)
	EndIf

	If $obj.props.badge Then
		Local $tBrush = _GDIPlus_BrushCreateSolid($obj.color)
		_GDIPlus_GraphicsFillRect($tGpx, (310-43)*$__Tiles_fScale, 120*$__Tiles_fScale, 35, 30, $tBrush)
		_GDIPlus_BrushDispose($tBrush)

		Local $aSize = _StringSize(String($obj.props.badgedata), 10, 800, 0, "Segoe UI", 35)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], (310-46)*$__Tiles_fScale+(35-$aSize[2])/2, 120*$__Tiles_fScale+(30-$aSize[3])/2, "Segoe UI", 10, 1, 0, 0xFFFFFFFF)
	EndIf

	If $obj.props.list Then
		Local $aSize = _StringSize(String($obj.props.listdata), 11, 400, 0, "Segoe UI Semilight", 180)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 14+($obj.props.thumb*85), 14+($obj.props.header*24), "Segoe UI Semilight", 11, 0, 0, 0xFFFFFFFF)
	EndIf

	If $obj.props.header Then
		Local $aSize = _StringSize(String($obj.props.headerdata), 16, 400, 0, "Segoe UI Light", 180)
		Local $aSplit = StringSplit($aSize[0], @CRLF, 1)
		_GDIPlus_GraphicsDrawString_($tGpx, ($obj.props.list) ? $aSplit[1] : $aSize[0], 12+($obj.props.thumb*85), 12, "Segoe UI Light", 16, 0, 0, 0xFFFFFFFF)
	EndIf

	If $obj.props.thumb Then
		Local $tThumb = _GDIPlus_ImageLoadFromFile($obj.props.thumbsrc)
		_GDIPlus_GraphicsDrawImageRect($tGpx, $tThumb, 12, 22, 80, 80)
		_GDIPlus_ImageDispose($tThumb)
	EndIf

	If $obj.props.daymonth And Not $obj.props.thumb Then
		Local $aSize = _StringSize(String(@MDAY), 48, 400, 0, "Segoe UI Light", 70)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 310-$aSize[2]-20, 4, "Segoe UI Light", 48, 0, 0, 0xFFFFFFFF)

		Local $aSize = _StringSize(String(_DateToMonth(@MON)), 9, 400, 0, "Segoe UI", 70)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 310-$aSize[2]-15, 84, "Segoe UI", 9, 0, 0, 0xFFFFFFFF)
	EndIf

	If $event = $TEV_HOVER Then
		Local $tBrush = _GDIPlus_BrushCreateSolid(0x10FFFFFF)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 310*$__Tiles_fScale, 150*$__Tiles_fScale, $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	ElseIf $event = $TEV_PRESSED Then
		Local $tBrush = _GDIPlus_BrushCreateSolid(0x10000000)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 310*$__Tiles_fScale, 150*$__Tiles_fScale, $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	EndIf

	If $__Tiles_iStyle <> $TS_FLAT Then
		Local $tBrush = _GDIPlus_LineBrushCreate(0, 0, 310*$__Tiles_fScale, 0, 0, 0x0FFFFFFF)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 310*$__Tiles_fScale, 150*$__Tiles_fScale, $tBrush)
		_GDIPlus_BrushDispose($tBrush)

		Local $tPen = _GDIPlus_PenCreate(0x1FFFFFFF, 1)
		_GDIPlus_GraphicsDrawRect($tGpx, 0, 0, 309*$__Tiles_fScale, 149*$__Tiles_fScale, $tPen)
		_GDIPlus_PenDispose($tPen)
	EndIf

	_GDIPlus_GraphicsDispose($tGpx)

	Local $tHbmp = _GDIPlus_BitmapCreateHBITMAPFromBitmap($tBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $tHbmp))
	_WinAPI_DeleteObject($tHbmp)

	_GDIPlus_BitmapDispose($tBmp)
EndFunc

Func __Tiles_GenTileL_RenderTile($obj, $event)
	Local $tBmp = _GDIPlus_BitmapCreateFromScan0(310*$__Tiles_fScale, 310*$__Tiles_fScale)

	Local $tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)
	_GDIPlus_GraphicsClear($tGpx, $obj.color)
	_GDIPlus_GraphicsSetTextRenderingHint($tGpx, $__Tiles_iTextRenderingHint)

	_GDIPlus_GraphicsDrawImageRect($tGpx, $obj.icon, 0, 0, 310*$__Tiles_fScale, 310*$__Tiles_fScale)

	If $obj.props.smallicon Then
		Local $tIcon = _GDIPlus_ImageLoadFromFile($obj.props.iconsrc)
		_GDIPlus_GraphicsDrawImageRect($tGpx, $tIcon, 19, 109, 32, 32)
		_GDIPlus_ImageDispose($tIcon)
	Else
		Local $aSize = _StringSize(String($obj.text), 9, 400, 0, "Segoe UI Semilight", 280)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 14*$__Tiles_fScale, 305*$__Tiles_fScale-$aSize[3], "Segoe UI Semilight", 9, 0, 0, 0xFFFFFFFF)
	EndIf

	If $obj.props.badge Then
		Local $tBrush = _GDIPlus_BrushCreateSolid($obj.color)
		_GDIPlus_GraphicsFillRect($tGpx, (310-43)*$__Tiles_fScale, 280*$__Tiles_fScale, 35, 30, $tBrush)
		_GDIPlus_BrushDispose($tBrush)

		Local $aSize = _StringSize(String($obj.props.badgedata), 10, 800, 0, "Segoe UI", 35)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], (310-46)*$__Tiles_fScale+(35-$aSize[2])/2, 280*$__Tiles_fScale+(30-$aSize[3])/2, "Segoe UI", 10, 1, 0, 0xFFFFFFFF)
	EndIf

	If $obj.props.list Then
		Local $aSize = _StringSize(String($obj.props.listdata), 11, 400, 0, "Segoe UI Semilight", 180)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 14*$__Tiles_fScale, 14*$__Tiles_fScale+($obj.props.header*24)+($obj.props.thumb*105), "Segoe UI Semilight", 11, 0, 0, 0xFFFFFFFF)
	EndIf

	If $obj.props.header Then
		Local $aSize = _StringSize(String($obj.props.headerdata), 16, 400, 0, "Segoe UI Light", 180)
		Local $aSplit = StringSplit($aSize[0], @CRLF, 1)
		_GDIPlus_GraphicsDrawString_($tGpx, ($obj.props.list) ? $aSplit[1] : $aSize[0], 12*$__Tiles_fScale, 12*$__Tiles_fScale+($obj.props.thumb*105), "Segoe UI Light", 16, 0, 0, 0xFFFFFFFF)
	EndIf

	If $obj.props.thumb Then
		Local $tThumb = _GDIPlus_ImageLoadFromFile($obj.props.thumbsrc)
		_GDIPlus_GraphicsDrawImageRect($tGpx, $tThumb, 12, 12, 100*$__Tiles_fScale, 100*$__Tiles_fScale)
		_GDIPlus_ImageDispose($tThumb)
	EndIf

	If $obj.props.daymonth Then
		Local $aSize = _StringSize(String(@MDAY), 48, 400, 0, "Segoe UI Light", 70)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 310*$__Tiles_fScale-$aSize[2]-20, 154*$__Tiles_fScale, "Segoe UI Light", 48, 0, 0, 0xFFFFFFFF)

		Local $aSize = _StringSize(String(_DateToMonth(@MON)), 9, 400, 0, "Segoe UI", 70)
		_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 310*$__Tiles_fScale-$aSize[2]-15, 234*$__Tiles_fScale, "Segoe UI", 9, 0, 0, 0xFFFFFFFF)
	EndIf

	If $event = $TEV_HOVER Then
		Local $tBrush = _GDIPlus_BrushCreateSolid(0x10FFFFFF)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 310, 310, $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	ElseIf $event = $TEV_PRESSED Then
		Local $tBrush = _GDIPlus_BrushCreateSolid(0x10000000)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 310, 310, $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	EndIf

	If $__Tiles_iStyle <> $TS_FLAT Then
		Local $tBrush = _GDIPlus_LineBrushCreate(0, 0, 310, 0, 0, 0x0FFFFFFF)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 310, 310, $tBrush)
		_GDIPlus_BrushDispose($tBrush)

		Local $tPen = _GDIPlus_PenCreate(0x1FFFFFFF, 1)
		_GDIPlus_GraphicsDrawRect($tGpx, 0, 0, 309, 309, $tPen)
		_GDIPlus_PenDispose($tPen)
	EndIf

	_GDIPlus_GraphicsDispose($tGpx)

	Local $tHbmp = _GDIPlus_BitmapCreateHBITMAPFromBitmap($tBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $tHbmp))
	_WinAPI_DeleteObject($tHbmp)

	_GDIPlus_BitmapDispose($tBmp)
EndFunc

Func __Tiles_GenTileS_RenderTile($obj, $event)
	Local $tBmp = _GDIPlus_BitmapCreateFromScan0(70*$__Tiles_fScale, 70*$__Tiles_fScale)

	Local $tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)
	_GDIPlus_GraphicsClear($tGpx, $obj.color)
	_GDIPlus_GraphicsSetTextRenderingHint($tGpx, $__Tiles_iTextRenderingHint)

	_GDIPlus_GraphicsDrawImageRect($tGpx, $obj.icon, 0, 0, 70*$__Tiles_fScale, 70*$__Tiles_fScale)

	If $event = $TEV_HOVER Then
		Local $tBrush = _GDIPlus_BrushCreateSolid(0x10FFFFFF)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 70*$__Tiles_fScale, 70*$__Tiles_fScale, $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	ElseIf $event = $TEV_PRESSED Then
		Local $tBrush = _GDIPlus_BrushCreateSolid(0x10000000)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 70*$__Tiles_fScale, 70*$__Tiles_fScale, $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	EndIf

	If $__Tiles_iStyle <> $TS_FLAT Then
		Local $tBrush = _GDIPlus_LineBrushCreate(0, 0, 70*$__Tiles_fScale, 0, 0, 0x0FFFFFFF)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, 70*$__Tiles_fScale, 70*$__Tiles_fScale, $tBrush)
		_GDIPlus_BrushDispose($tBrush)

		Local $tPen = _GDIPlus_PenCreate(0x1FFFFFFF, 1)
		_GDIPlus_GraphicsDrawRect($tGpx, 0, 0, 69*$__Tiles_fScale, 69*$__Tiles_fScale, $tPen)
		_GDIPlus_PenDispose($tPen)
	EndIf

	_GDIPlus_GraphicsDispose($tGpx)

	Local $tHbmp = _GDIPlus_BitmapCreateHBITMAPFromBitmap($tBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $tHbmp))
	_WinAPI_DeleteObject($tHbmp)

	_GDIPlus_BitmapDispose($tBmp)
EndFunc

#EndRegion

#Region Working on Properties

Func _Tiles_GetProperties($idTile)
	Return _Tiles_PropertiesClone(($__Tiles_aTileObjectList[$idTile]).props)
EndFunc

Func _Tiles_SetProperties($idTile, $hProps)
	($__Tiles_aTileObjectList[$idTile]).props = _Tiles_PropertiesClone($hProps)
	($__Tiles_aTileObjectList[$idTile]).RenderTile(0)
EndFunc

#EndRegion

#Region Misc

Func _Tiles_RenderOnHoverLeave($ctrl, $mode)
	Local $iIndex = _Tiles_GetTileIndexFromCtrl($ctrl)
	Local $oObj = $__Tiles_aTileObjectList[$iIndex]

	Switch $mode
		Case 1
			$oObj.RenderTile($TEV_HOVER)
		Case 2
			$oObj.RenderTile($TEV_NORMAL)
	EndSwitch
EndFunc

Func _Tiles_RenderOnPress($ctrl, $mode)
	Local $iIndex = _Tiles_GetTileIndexFromCtrl($ctrl)
	Local $oObj = $__Tiles_aTileObjectList[$iIndex]

	Switch $mode
		Case 1
			$oObj.RenderTile($TEV_PRESSED)
		Case 2
			$oObj.RenderTile($TEV_HOVER)
	EndSwitch
EndFunc

Func _GDIPlus_GraphicsDrawString_($hGraphics, $sString, $nX, $nY, $sFont = "Arial", $nSize = 10, $iStyle = 0, $iFormat = 0, $iColor = 0xFF000000)
	Local $hBrush = _GDIPlus_BrushCreateSolid($iColor)
	Local $hFormat = _GDIPlus_StringFormatCreate($iFormat)
	If $sFont = $v4Setting_UI_FontFamily Or $sFont = "vPaint UI Glyphs" Then
		Local $hCollection = _GDIPlus_FontPrivateCreateCollection()
		_GDIPlus_FontPrivateAddFont($hCollection, @ScriptDir&"\Data\Fonts\"&$sFont&".ttf")
		Local $hFamily = _GDIPlus_FontFamilyCreateFromCollection($sFont, $hCollection)
	Else
		Local $hFamily = _GDIPlus_FontFamilyCreate($sFont)
	EndIf
	Local $hFont = _GDIPlus_FontCreate($hFamily, $nSize, $iStyle)
	Local $tLayout = _GDIPlus_RectFCreate($nX, $nY, 0.0, 0.0)
	Local $aInfo = _GDIPlus_GraphicsMeasureString($hGraphics, $sString, $hFont, $tLayout, $hFormat)
	If @error Then Return SetError(@error, @extended, 0)
	Local $aResult = _GDIPlus_GraphicsDrawStringEx($hGraphics, $sString, $hFont, $aInfo[0], $hFormat, $hBrush)
	Local $iError = @error, $iExtended = @extended
	_GDIPlus_FontDispose($hFont)
	_GDIPlus_FontFamilyDispose($hFamily)
	If IsDeclared("hCollection") Then _GDIPlus_FontPrivateCollectionDispose($hCollection)
	_GDIPlus_StringFormatDispose($hFormat)
	_GDIPlus_BrushDispose($hBrush)
	Return SetError($iError, $iExtended, $aResult)
EndFunc

#EndRegion
