#include-once

Func _CreatePath($sName, $iClosed = 0)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "name", $ELSCOPE_PUBLIC, $sName)
	_AutoItObject_AddProperty($obj, "closed", $ELSCOPE_PUBLIC, $iClosed)
	_AutoItObject_AddProperty($obj, "isVisible", $ELSCOPE_PUBLIC, 1)

	_AutoItObject_AddProperty($obj, "points", $ELSCOPE_PUBLIC, LinkedList())

	_AutoItObject_AddMethod($obj, "clone", "_Path_Clone")
	_AutoItObject_AddMethod($obj, "dispose", "_Path_Dispose")
	_AutoItObject_AddMethod($obj, "createGdipPath", "_Path_CreateGdipPath")

	_AutoItObject_AddDestructor($obj, "_Path_Dispose")

	Return $obj
EndFunc

Func _Path_Dispose(ByRef $oSelf)
	$oSelf = 0
EndFunc

Func _Path_Clone($oSelf)
	Local $obj = _CreatePath($oSelf.name, $oSelf.closed)
	$obj.isVisible = $oSelf.isVisible

	For $point In $oSelf.points
		$obj.points.add(_CreatePathPoint($point.baseX, $point.baseY, $point.arm1X, $point.arm1Y, $point.arm2X, $point.arm2Y))
	Next

	Return $obj
EndFunc

Func _Path_CreateGdipPath($oSelf)
	Local $hPath = _GDIPlus_PathCreate()

	For $i = 0 To ($oSelf.points.count-2)
		$p1 = $oSelf.points.at($i)
		$p2 = $oSelf.points.at($i+1)

		_GDIPlus_PathAddBezier($hPath, $p1.baseX, $p1.baseY, $p1.arm1X, $p1.arm1Y, $p2.arm2X, $p2.arm2Y, $p2.baseX, $p2.baseY)
	Next

	If $oSelf.closed = 1 Then
		$p1 = $oSelf.points.at($oSelf.points.count-1)
		$p2 = $oSelf.points.at(0)

		_GDIPlus_PathAddBezier($hPath, $p1.baseX, $p1.baseY, $p1.arm1X, $p1.arm1Y, $p2.arm2X, $p2.arm2Y, $p2.baseX, $p2.baseY)
		_GDIPlus_PathCloseFigure($hPath)
	EndIf

	Return $hPath
EndFunc

; Order:
; behind: Arm2
; "handle?": Base
; after: Arm1

; Linking with other points:
; p1.Base p1.Arm1 p2.Arm2 p2.Base ...
Func _CreatePathPoint($BaseX, $BaseY, $Arm1X, $Arm1Y, $Arm2X, $Arm2Y)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "baseX", $ELSCOPE_PUBLIC, $BaseX)
	_AutoItObject_AddProperty($obj, "baseY", $ELSCOPE_PUBLIC, $BaseY)

	_AutoItObject_AddProperty($obj, "arm1X", $ELSCOPE_PUBLIC, $Arm1X)
	_AutoItObject_AddProperty($obj, "arm1Y", $ELSCOPE_PUBLIC, $Arm1Y)

	_AutoItObject_AddProperty($obj, "arm2X", $ELSCOPE_PUBLIC, $Arm2X)
	_AutoItObject_AddProperty($obj, "arm2Y", $ELSCOPE_PUBLIC, $Arm2Y)

	Return $obj
EndFunc