#include-once

Func _CreateThread($iW, $iH)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "width", $ELSCOPE_PUBLIC, $iW)
	_AutoItObject_AddProperty($obj, "height", $ELSCOPE_PUBLIC, $iH)

	_AutoItObject_AddProperty($obj, "tempRender", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "currentLayer", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "currentLayerId", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "historyDescription", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "selection", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "selections", $ELSCOPE_PUBLIC, LinkedList())
	_AutoItObject_AddProperty($obj, "currentSelection", $ELSCOPE_PUBLIC, 0)

	$obj.selections.add(_CreateSelection("Selection 1"))
	$obj.selection = ($obj.selections.at($obj.currentSelection)).rgn

	_AutoItObject_AddProperty($obj, "paths", $ELSCOPE_PUBLIC, LinkedList())
	_AutoItObject_AddProperty($obj, "currentPath", $ELSCOPE_PUBLIC, -1)

	_AutoItObject_AddProperty($obj, "layers", $ELSCOPE_PUBLIC, LinkedList())

	_AutoItObject_AddMethod($obj, "getLayer", "_Thread_GetLayer")
	_AutoItObject_AddMethod($obj, "addLayer", "_Thread_AddLayer")
	_AutoItObject_AddMethod($obj, "removeLayer", "_Thread_DelLayer")
	_AutoItObject_AddMethod($obj, "selectLayer", "_Thread_SelLayer")

	_AutoItObject_AddMethod($obj, "clone", "_Thread_Clone")
	_AutoItObject_AddMethod($obj, "save", "_Thread_SaveToFile")

	_AutoItObject_AddMethod($obj, "render", "_Thread_Render")
	_AutoItObject_AddMethod($obj, "renderFull", "_Thread_RenderFull")
	_AutoItObject_AddMethod($obj, "renderRaw", "_Thread_RenderRaw")

	_AutoItObject_AddMethod($obj, "dispose", "_Thread_Dispose")

	_AutoItObject_AddMethod($obj, "debugOut", "_Thread_DebugOut")

	_AutoItObject_AddMethod($obj, "serialize", "_Thread_Serialize")
	_AutoItObject_AddMethod($obj, "deserialize", "_Thread_Deserialize")

	_AutoItObject_AddDestructor($obj, "_Thread_Dispose")

	Return $obj
EndFunc

Func _Thread_Serialize($oSelf, $hXML, $sDir, $sZipfile)
	$hNode = _AXml_CreateNode($hXML, 1, 1, "thread")

	_AXml_CreateAttribute($hXML, "width", $oSelf.width)
	_AXml_CreateAttribute($hXML, "height", $oSelf.height)

	$hLayers = _AXml_CreateNode($hXML, 1, 1, "layers")
	_AXml_CreateAttribute($hXML, "current", $oSelf.currentLayerId)

	$iInsertMode = 1
	For $oLayer In $oSelf.layers
		$hLayer = _AXml_CreateNode($hXML, 1, $iInsertMode, "layer")
		_AXml_CreateAttribute($hXML, "visible", $oLayer.isVisible)
		_AXml_CreateAttribute($hXML, "name", $oLayer.name)
		_AXml_CreateAttribute($hXML, "opacity", $oLayer.opacity)
		_AXml_CreateAttribute($hXML, "type", $oLayer.type)

		Switch $oLayer.type
			Case $V4_LT_IMAGE
				$sTempImg = _TempFile($sDir, "", ".png")
				_GDIPlus_ImageSaveToFile($oLayer.bmp, $sTempImg)
				_AXml_CreateAttribute($hXML, "image", _WinAPI_PathFindFileName($sTempImg))
				_Zip_AddFile($sZipfile, $sTempImg)

				_AXml_CreateAttribute($hXML, "blendMode", $oLayer.blendMode)
				_AXml_CreateAttribute($hXML, "enableRouting", $oLayer.enableRouting)
				_AXml_CreateAttribute($hXML, "routeFlags", $oLayer.routeFlags)
		EndSwitch

		$iInsertMode = 3
	Next

	_AXml_XPathNode($hXML, "/v4i/thread")
	$hPaths = _AXml_CreateNode($hXML, 1, 1, "paths")
	_AXml_CreateAttribute($hXML, "current", $oSelf.currentPath)

	$iInsertMode = 1
	For $oPath In $oSelf.paths
		_AXml_XPathNode($hXML, "/v4i/thread/paths")
		$hPath = _AXml_CreateNode($hXML, 1, $iInsertMode, "path")
		_AXml_CreateAttribute($hXML, "name", $oPath.name)
		_AXml_CreateAttribute($hXML, "visible", $oPath.isVisible)
		_AXml_CreateAttribute($hXML, "closed", $oPath.closed)

		$iInsertMode2 = 1
		For $oPoint In $oPath.points
			_AXml_CreateNode($hXML, 1, $iInsertMode2, "point")
			_AXml_CreateAttribute($hXML, "baseX", $oPoint.baseX)
			_AXml_CreateAttribute($hXML, "baseY", $oPoint.baseY)
			_AXml_CreateAttribute($hXML, "arm1X", $oPoint.arm1X)
			_AXml_CreateAttribute($hXML, "arm1Y", $oPoint.arm1Y)
			_AXml_CreateAttribute($hXML, "arm2X", $oPoint.arm2X)
			_AXml_CreateAttribute($hXML, "arm2Y", $oPoint.arm2Y)

			$iInsertMode2 = 3
		Next

		$iInsertMode = 3
	Next
EndFunc

Func _Thread_Deserialize($oSelf, $hXML, $sDir)
	_AXml_XPathNode($hXML, "/v4i/thread")
	$oSelf.width = _AXml_GetAttribute($hXML, "width")
	$oSelf.height = _AXml_GetAttribute($hXML, "height")

	_AXml_XPathNode($hXML, "/v4i/thread/layers")
	$iCurLayer = _AXml_GetAttribute($hXML, "current")

	$bFirst = True
	For $i = 1 To _AXml_NumChildren($hXML)
		If $bFirst Then
			_AXml_FirstChild($hXML)
		Else
			_AXml_NextSibling($hXML)
		EndIf

		$type = _AXml_GetAttribute($hXML, "type")
		Switch $type
			Case $V4_LT_IMAGE
				$hImage = _GDIPlus_ImageLoadFromFile($sDir&"\"&_AXml_GetAttribute($hXML, "image"))
				$oLayer = _CreateImageLayer($hImage)
				$oLayer.name = _AXml_GetAttribute($hXML, "name")
				$oLayer.isVisible = _AXml_GetAttribute($hXML, "visible")
				$oLayer.opacity = _AXml_GetAttribute($hXML, "opacity")
				$oLayer.enableRouting = _AXml_GetAttribute($hXML, "enableRouting")
				$oLayer.routeFlags = _AXml_GetAttribute($hXML, "routeFlags")
				$oLayer.blendMode = _AXml_GetAttribute($hXML, "blendMode")

				$oSelf.addLayer($oLayer)
		EndSwitch

		$bFirst = False
	Next
	$oSelf.selectLayer($iCurLayer)

	_AXml_XPathNode($hXML, "/v4i/thread/paths")
	$oSelf.currentPath = _AXml_GetAttribute($hXML, "current")

	$bFirst = True
	For $i = 1 To _AXml_NumChildren($hXML)
		If $bFirst Then
			_AXml_FirstChild($hXML)
		Else
			_AXml_NextSibling($hXML)
		EndIf

		$oPath = _CreatePath(_AXml_GetAttribute($hXML, "name"))
		$oPath.isVisible = _AXml_GetAttribute($hXML, "visible")
		$oPath.closed = _AXml_GetAttribute($hXML, "closed")

		$bFirst2 = True
		$n = _AXml_NumChildren($hXML)
		For $j = 1 To _AXml_NumChildren($hXML)
			If $bFirst2 Then
				_AXml_FirstChild($hXML)
			Else
				_AXml_NextSibling($hXML)
			EndIf

			$oPath.points.add(_CreatePathPoint(_AXml_GetAttribute($hXML, "baseX"), _AXml_GetAttribute($hXML, "baseY"), _AXml_GetAttribute($hXML, "arm1X"), _AXml_GetAttribute($hXML, "arm1Y"), _AXml_GetAttribute($hXML, "arm2X"), _AXml_GetAttribute($hXML, "arm2Y")))

			$bFirst2 = False
		Next

		If $n > 0 Then _AXml_Parent($hXML)

		$oSelf.paths.add($oPath)

		$bFirst = False
	Next
EndFunc

Func _Thread_DebugOut($oSelf)
	ConsoleWrite("+> Thread Debug @ "&_Date_Time_SystemTimeToDateTimeStr(_Date_Time_GetSystemTime())&@CRLF)
	ConsoleWrite("+> CURRENT LAYER:"&@CRLF)
	ConsoleWrite("+> Type: "&$oSelf.currentLayer.type&@CRLF)
	ConsoleWrite("+> Render Bitmap: "&$oSelf.currentLayer.bmp&@CRLF)
EndFunc

Func _Thread_SelLayer($oSelf, $iLayer)
	$oSelf.currentLayer = $oSelf.getLayer($iLayer)
	$oSelf.currentLayerId = $iLayer
EndFunc

Func _Thread_RenderRaw($oSelf)
	$tRender = _GDIPlus_BitmapCreateFromScan0($oSelf.width, $oSelf.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tRender)

	$hIA = _GDIPlus_ImageAttributesCreate()
	For $layer In $oSelf.layers
		If $layer.isVisible = 0 Then ContinueLoop
		Switch $layer.type
			Case $V4_LT_EFFECT
				$layer.apply($tRender)
			Case $V4_LT_IMAGE, $V4_LT_PATH
				$layer.render()
				If $layer.blendMode = $IF_NORMAL Then
					$tCm = _GDIPlus_ColorMatrixCreate()
					If $layer.enableRouting Then
						DllStructSetData($tCM, "m", 0, 1)
						DllStructSetData($tCM, "m", 0, 7)
						DllStructSetData($tCM, "m", 0, 13)
						DllStructSetData($tCM, "m", 0, 19)
						DllStructSetData($tCM, "m", 1, 25)

						$iRouteRed = BitAND(BitShift($layer.routeFlags, 24), 0xFF)
						$iRouteGreen = BitAND(BitShift($layer.routeFlags, 16), 0xFF)
						$iRouteBlue = BitAND(BitShift($layer.routeFlags, 8), 0xFF)
						$iRouteAlpha = BitAND($layer.routeFlags, 0xFF)
						DllStructSetData($tCM, "m", 1, $iRouteRed*5+1)
						DllStructSetData($tCM, "m", 1, $iRouteGreen*5+2)
						DllStructSetData($tCM, "m", 1, $iRouteBlue*5+3)
						DllStructSetData($tCM, "m", 1, $iRouteAlpha*5+4)
					EndIf
					_GDIPlus_ColorMatrixScale($tCm, 1, 1, 1, $Layer.opacity/100)
					_GDIPlus_ImageAttributesSetColorMatrix($hIA, 0, True, $tCm)
					_GDIPlus_GraphicsDrawImageRectRect($tGpx, $layer.bmp, 0, 0, $layer.width, $layer.height, $layer.x, $layer.y, $layer.width, $layer.height, $hIA)
				Else
					_Interference_Blend($tRender, $layer.bmp, $layer.blendMode, $Layer.opacity/100)
				EndIf
		EndSwitch
	Next
	_GDIPlus_ImageAttributesDispose($hIA)

	_GDIPlus_GraphicsDispose($tGpx)

	Return $tRender
EndFunc

Func _Thread_RenderFull($oSelf, $iTransGrid = 0)
	If $oSelf.tempRender <> 0 Then _GDIPlus_BitmapDispose($oSelf.tempRender)

	$tRender = _GDIPlus_BitmapCreateFromScan0($oSelf.width, $oSelf.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tRender)

	If $iTransGrid Then _GDIPlus_GraphicsFillRect($tGpx, 0, 0, $oSelf.width, $oSelf.height, $hTransparency)

	$tRawRender = $oSelf.renderRaw()
	_GDIPlus_GraphicsDrawImage($tGpx, $tRawRender, 0, 0)
	_GDIPlus_BitmapDispose($tRawRender)

	$tRgn = _GDIPlus_RegionCreate()
	_GDIPlus_RegionCombineRegion($tRgn, $oSelf.selection, 4)

	_GDIPlus_GraphicsSetClipRegion($tGpx, $tRgn)

	$tFog = _GDIPlus_BrushCreateSolid(0x80000000)
	_GDIPlus_GraphicsFillRect($tGpx, 0, 0, $oSelf.width, $oSelf.height, $tFog)
	_GDIPlus_BrushDispose($tFog)

	_GDIPlus_RegionDispose($tRgn)

	_GDIPlus_GraphicsResetClip($tGpx)

	For $path In $oSelf.paths
		If Not $path.isVisible Then ContinueLoop
		$hPath = $path.createGdipPath()
		_GDIPlus_GraphicsDrawPath($tGpx, $hPath)
		_GDIPlus_PathDispose($hPath)
	Next

	_GDIPlus_GraphicsDispose($tGpx)

	$oSelf.tempRender = $tRender
EndFunc

Func _Thread_Render($oSelf, $iTransGrid = 0, $iReturn = 0)
	If $oSelf.tempRender <> 0 Then _GDIPlus_BitmapDispose($oSelf.tempRender)

	$tRender = _GDIPlus_BitmapCreateFromScan0($oSelf.width, $oSelf.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tRender)

	If $iTransGrid Then _GDIPlus_GraphicsFillRect($tGpx, 0, 0, $oSelf.width, $oSelf.height, $hTransparency)

	$tRawRender = $oSelf.renderRaw()
	_GDIPlus_GraphicsDrawImage($tGpx, $tRawRender, 0, 0)
	_GDIPlus_BitmapDispose($tRawRender)

	$tRgn = _GDIPlus_RegionCreate()
	_GDIPlus_RegionCombineRegion($tRgn, $oSelf.selection, 4)

	_GDIPlus_GraphicsSetClipRegion($tGpx, $tRgn)

	$tFog = _GDIPlus_BrushCreateSolid(0x80000000)
	_GDIPlus_GraphicsFillRect($tGpx, 0, 0, $oSelf.width, $oSelf.height, $tFog)
	_GDIPlus_BrushDispose($tFog)

	_GDIPlus_RegionDispose($tRgn)

	_GDIPlus_GraphicsResetClip($tGpx)

	_GDIPlus_GraphicsSetSmoothingMode($tGpx, 5)

	$tPen1 = _GDIPlus_PenCreate(0xAAFFFFFF, 3)
	$tPen2 = _GDIPlus_PenCreate(0xAA000000)
	$tPen3 = _GDIPlus_PenCreate(0xAAFF0000)
	$tPen1d = _GDIPlus_PenCreate(0xAAFFFFFF, 3)
	_GDIPlus_PenSetDashStyle($tPen1d, 1)
	$tPen2d = _GDIPlus_PenCreate(0xAA000000)
	_GDIPlus_PenSetDashStyle($tPen2d, 1)
	$i = 0
	For $path In $oSelf.paths
		If Not $path.isVisible Then ContinueLoop
		$hPath = $path.createGdipPath()
		_GDIPlus_GraphicsDrawPath($tGpx, $hPath, $tPen1)
		_GDIPlus_GraphicsDrawPath($tGpx, $hPath, ($i = $oSelf.currentPath) ? $tPen3 : $tPen2)
		_GDIPlus_PathDispose($hPath)

		For $point In $path.points
			_GDIPlus_GraphicsDrawRect($tGpx, $point.baseX-3, $point.baseY-3, 6, 6, $tPen1)
			_GDIPlus_GraphicsDrawRect($tGpx, $point.baseX-3, $point.baseY-3, 6, 6, $tPen2)

			_GDIPlus_GraphicsDrawEllipse($tGpx, $point.arm1X-2, $point.arm1Y-2, 4, 4, $tPen1)
			_GDIPlus_GraphicsDrawEllipse($tGpx, $point.arm1X-2, $point.arm1Y-2, 4, 4, $tPen2)

			_GDIPlus_GraphicsDrawEllipse($tGpx, $point.arm2X-2, $point.arm2Y-2, 4, 4, $tPen1)
			_GDIPlus_GraphicsDrawEllipse($tGpx, $point.arm2X-2, $point.arm2Y-2, 4, 4, $tPen2)
		Next
		$i += 1
	Next
	_GDIPlus_PenDispose($tPen2)
	_GDIPlus_PenDispose($tPen1)

	_GDIPlus_GraphicsDispose($tGpx)

	If $iReturn = 1 Then Return $tRender
	$oSelf.tempRender = $tRender
EndFunc

Func _Thread_SaveToFile($oSelf, $sFile)
	$tBmp = _GDIPlus_BitmapCreateFromScan0($oSelf.width, $oSelf.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	For $layer In $oSelf.layers
		_GDIPlus_GraphicsDrawImageRect($tGpx, $layer.bmp, 0, 0, $layer.width, $layer.height)
	Next

	_GDIPlus_GraphicsDispose($tGpx)
	_GDIPlus_ImageSaveToFile($tBmp, $sFile)
	_GDIPlus_BitmapDispose($tBmp)
EndFunc

Func _Thread_AddLayer($oSelf, $oLayer)
	$oSelf.layers.add($oLayer)

	Switch $oLayer.type
		Case $V4_LT_IMAGE
			$oLayer.render()
	EndSwitch
EndFunc

Func _Thread_DelLayer($oSelf, $iLayer)
	$Layer = $oSelf.layers.at($iLayer)
	If $Layer.ref = 0 Then
		$layer.dispose()
	Else
		$Layer.ref -= 1
	EndIf

	$oSelf.layers.remove($iLayer)
EndFunc

Func _Thread_Dispose(ByRef $oSelf)
	For $Layer In $oSelf.layers
		If $Layer.ref = 0 Then
			$layer.dispose()
		Else
			$Layer.ref -= 1
		EndIf
	Next

	For $Region in $oSelf.selections
		$Region.dispose()
	Next

	$oSelf = 0
EndFunc

Func _Thread_Clone($oSelf)
	$obj = _CreateThread($oSelf.width, $oSelf.height)

	$obj.currentLayerId = $oSelf.currentLayerId

	For $layer In $oSelf.layers
		$obj.layers.add($layer.clone())
	Next

	($obj.selections.at(0)).dispose()
	$obj.selections.remove(0)

	For $region In $oSelf.selections
		$obj.selections.add($region.clone())
	Next

	For $path In $oSelf.paths
		$obj.paths.add($path.clone())
	Next

	$obj.currentPath = $oSelf.currentPath

	$obj.currentSelection = $oSelf.currentSelection
	$obj.selection = ($obj.selections.at($obj.currentSelection)).rgn

	$obj.currentLayer = $obj.getLayer($oSelf.currentLayerId)

	$obj.historyDescription = $oSelf.historyDescription

	_GDIPlus_RegionDispose($obj.selection)
	$obj.selection = _GDIPlus_RegionClone($oSelf.selection)

	Return $obj
EndFunc

Func _Thread_GetLayer($oSelf, $i)
	Return $oSelf.layers.at($i)
EndFunc
