#include-once
#include "Tools\Move.au3"
#include "Tools\Select.au3"
#include "Tools\Brush.au3"
#include "Tools\Eraser.au3"
#include "Tools\Eyedropper.au3"
#include "Tools\Gradient.au3"
#include "Tools\Crop.au3"
#include "Tools\Path.au3"

Func _CreateTool($sFunc, $iSupportsD2DHUD = 0)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddMethod($obj, "start", $sFunc & "_Start")
	_AutoItObject_AddMethod($obj, "draw", $sFunc & "_Draw")
	_AutoItObject_AddMethod($obj, "end", $sFunc & "_End")
	_AutoItObject_AddMethod($obj, "drawHUD", $sFunc & "_DrawHUD")
	_AutoItObject_AddMethod($obj, "showUI", $sFunc & "_ShowUI")
	_AutoItObject_AddMethod($obj, "canBypassLock", $sFunc & "_CanBypassLock")

	_AutoItObject_AddProperty($obj, "lastX", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "lastY", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "gpx", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "extra1", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "extra2", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "extra3", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "extra4", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "extra5", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "extra6", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "extra7", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "extra8", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "d2d_target", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "supportsD2DHUD", $ELSCOPE_PUBLIC, $iSupportsD2DHUD)
	If $iSupportsD2DHUD Then _AutoItObject_AddMethod($obj, "drawD2DHUD", $sFunc & "_DrawD2DHUD")

	Return $obj
EndFunc
