#include-once

#Region Gaussian Blur

Func _Blur($iRadius, ByRef $hBmp)
	$tEffect = _GDIPlus_EffectCreateBlur($iRadius, 1)
	_GDIPlus_BitmapApplyEffect($hBmp, $tEffect)
	_GDIPlus_EffectDispose($tEffect)
EndFunc

Func _Blur_Event()
	If Not $isOpen Then Return 0

	$iOpt = Opt("GUIOnEventMode", 0)

	$hGaussianUI = GUICreate("Gaussian blur", 314, 162, -1, -1, -1, -1, $hMainUI)

	GUICtrlCreateLabel("Blur radius:", 8, 8, 77, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidRadius = GUICtrlCreateSlider(8, 32, 297, 33)
	GUICtrlSetLimit(-1, 100, 1)
	GUICtrlSetData(-1, 10)

	$cidCancel = GUICtrlCreateButton("Cancel", 216, 120, 89, 33)
	$cidOK = GUICtrlCreateButton("OK", 120, 120, 89, 33)

	$cidUnpremul = GUICtrlCreateCheckbox("Unpremultiply", 8, 88, 297, 17)

	;$cidAddAsLayer = GUICtrlCreateCheckbox("Add as layer", 8, 120, 100, 33)
	$cidAddAsLayer = 0

	GUISetState()

	While 1
		Switch GUIGetMsg()
			Case -3, $cidCancel
				ExitLoop
			Case $cidOK
				If BitAND(GUICtrlRead($cidAddAsLayer), $GUI_CHECKED) Then
					;$oFXLayer = _CreateEffectLayer("Gaussian Blur;_Blur;"&GUICtrlRead($cidRadius))
					;$oCurrentThread.thread.addLayer($oFXLayer)
					;_RefreshLayerList()
				Else
					$hBmp = $oCurrentThread.thread.currentLayer.bmp
					_Blur(GUICtrlRead($cidRadius), $hBmp)
					If BitAND(GUICtrlRead($cidUnpremul), $GUI_CHECKED) Then _Interference_UnPremultiply($hBmp)

					$oCurrentThread.thread.currentLayer.bmp = $hBmp
				EndIf
				$oCurrentThread.historyAdd()

				ExitLoop
		EndSwitch
	WEnd

	GUIDelete($hGaussianUI)
	GUISwitch($hMainUI)

	_RenderDrawingArea()

	Opt("GUIOnEventMode", $iOpt)
EndFunc

#EndRegion

#Region Radial Blur

Func _RadialBlur_Event()
	If Not $isOpen Then Return 0

	$iOpt = Opt("GUIOnEventMode", 0)

	$hRadialBlurUI = GUICreate("Radial blur", 314, 211, -1, -1, -1, -1, $hMainUI)

	GUICtrlCreateLabel("Blur type:", 8, 8, 66, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidType = GUICtrlCreateCombo("", 8, 32, 297, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Radial|Zoom", "Radial")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	GUICtrlCreateLabel("Blur amount:", 8, 80, 77, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidAmount = GUICtrlCreateSlider(8, 104, 297, 33)
	GUICtrlSetLimit(-1, 100, 1)
	GUICtrlSetData(-1, 10)

	$cidCancel = GUICtrlCreateButton("Cancel", 216, 168, 89, 33)
	$cidOK = GUICtrlCreateButton("OK", 120, 168, 89, 33)

	GUISetState()

	While 1
		Switch GUIGetMsg()
			Case -3, $cidCancel
				ExitLoop
			Case $cidOK
				Switch GUICtrlRead($cidType)
					Case "Radial"
						_RadialBlur(GUICtrlRead($cidAmount), 1)
					Case "Zoom"
						_ZoomBlur(GUICtrlRead($cidAmount), 3)
				EndSwitch

				$oCurrentThread.historyAdd()
				ExitLoop
		EndSwitch
	WEnd

	GUIDelete($hRadialBlurUI)
	GUISwitch($hMainUI)

	_RenderDrawingArea()

	Opt("GUIOnEventMode", $iOpt)
EndFunc

#EndRegion

#Region Zoom Blur

Func _ZoomBlur($iSize = 50, $iStep = 5)
	$tBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	_ProgressOn("Applying effect...", "Iteration 0 of "&2*Int($iSize/$iStep))

	For $i = -$iSize To $iSize Step $iStep
		$a = 1-(($i+$iSize)/(2*$iSize+1))
		$tCm = _GDIPlus_ColorMatrixCreateScale(1, 1, 1, $a)
		$tEffect = _GDIPlus_EffectCreateColorMatrix($tCm)

		$tBmp2 = _GDIPlus_BitmapCreateApplyEffect($oCurrentThread.thread.currentLayer.bmp, $tEffect)

		_GDIPlus_GraphicsDrawImageRect($tGpx, $tBmp2, -$i, -$i, $oCurrentThread.thread.currentLayer.width+$i*2, $oCurrentThread.thread.currentLayer.height+$i*2)

		_GDIPlus_BitmapDispose($tBmp2)

		_GDIPlus_EffectDispose($tEffect)

		_ProgressSet("Applying effect...", "Iteration "&Int(($i+$iSize)/$iStep)&" of "&2*Int($iSize/$iStep), 100*Int(($i+$iSize)/$iStep)/(2*Int($iSize/$iStep)))
	Next

	_ProgressOff()

	_GDIPlus_GraphicsDispose($tGpx)
	_GDIPlus_BitmapDispose($oCurrentThread.thread.currentLayer.bmp)
	$oCurrentThread.thread.currentLayer.bmp = $tBmp
EndFunc

Func _ZoomBlur_Event()
	If Not $isOpen Then Return 0
	_ZoomBlur()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

#EndRegion

#Region Motion Blur

Func _MotionBlur($iAngle = 45, $iSize = 30, $iStep = 2)
	$tBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	$ang = _Radian($iAngle)
	$dX = Cos($ang)*($iSize/2)
	$dY = Sin($ang)*($iSize/2)

	_ProgressOn("Applying effect...", "Iteration 0 of "&Int($iSize/$iStep))

	For $i = 0 To $iSize Step $iStep
		$a = 1-(($i)/($iSize+1))

		$x = Cos($ang)*$i
		$y = Sin($ang)*$i

		$tCm = _GDIPlus_ColorMatrixCreateScale(1, 1, 1, $a)
		$tEffect = _GDIPlus_EffectCreateColorMatrix($tCm)

		$tBmp2 = _GDIPlus_BitmapCreateApplyEffect($oCurrentThread.thread.currentLayer.bmp, $tEffect)

		_GDIPlus_GraphicsDrawImageRect($tGpx, $tBmp2, $x-$dX, $y-$dY, $oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)

		_GDIPlus_BitmapDispose($tBmp2)

		_GDIPlus_EffectDispose($tEffect)

		_ProgressSet("Applying effect...", "Iteration "&Int($i/$iStep)&" of "&Int($iSize/$iStep), 100*Int($i/$iStep)/Int($iSize/$iStep))
	Next

	_ProgressOff()

	_GDIPlus_GraphicsDispose($tGpx)
	_GDIPlus_BitmapDispose($oCurrentThread.thread.currentLayer.bmp)
	$oCurrentThread.thread.currentLayer.bmp = $tBmp
EndFunc

Func _MotionBlur_Event()
	If Not $isOpen Then Return 0
	_MotionBlur()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

#EndRegion

#Region Radial Blur

Func _RadialBlur($iSize = 10, $iStep = 1)
	$tBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	_ProgressOn("Applying effect...", "Iteration 0 of "&Int($iSize/$iStep))

	For $i = -$iSize/2 To $iSize/2 Step $iStep
		$a = 1-(($i+$iSize/2)/($iSize+1))
		$tCm = _GDIPlus_ColorMatrixCreateScale(1, 1, 1, $a)
		$tEffect = _GDIPlus_EffectCreateColorMatrix($tCm)

		$tBmp2 = _GDIPlus_BitmapCreateApplyEffect($oCurrentThread.thread.currentLayer.bmp, $tEffect)

		_DrawRotated($tGpx, $tBmp2, $oCurrentThread.thread.currentLayer.width/2, $oCurrentThread.thread.currentLayer.height/2, 0, 0, $i)

		_GDIPlus_BitmapDispose($tBmp2)

		_GDIPlus_EffectDispose($tEffect)

		_ProgressSet("Applying effect...", "Iteration "&Int(($i+$iSize/2)/$iStep)&" of "&Int($iSize/$iStep), 100*Int(($i+$iSize/2)/$iStep)/Int($iSize/$iStep))
	Next

	_ProgressOff()

	_GDIPlus_GraphicsDispose($tGpx)
	_GDIPlus_BitmapDispose($oCurrentThread.thread.currentLayer.bmp)
	$oCurrentThread.thread.currentLayer.bmp = $tBmp
EndFunc

#EndRegion
