#include-once

Func _Tiles($iSize = 10, $iStep = 10)
	$tBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	_ProgressOn("Applying effect...", "Row 0 of "&Int($oCurrentThread.thread.currentLayer.width/$iStep))

	For $x = 0 To $oCurrentThread.thread.currentLayer.width Step $iStep
		For $y = 0 To $oCurrentThread.thread.currentLayer.height Step $iStep
			_GDIPlus_GraphicsDrawImageRectRect($tGpx, $oCurrentThread.thread.currentLayer.bmp, $x, $y, $iStep, $iStep, Random($x-$iSize, $x+$iSize), Random($y-$iSize, $y+$iSize), $iStep, $iStep)
		Next
		_ProgressSet("Applying effect...", "Row "&Int($x/$iStep+1)&" of "&Int($oCurrentThread.thread.currentLayer.width/$iStep), 100*Int($x/$iStep+1)/Int($oCurrentThread.thread.currentLayer.width/$iStep))
	Next

	_ProgressOff()

	_GDIPlus_GraphicsDispose($tGpx)
	_GDIPlus_BitmapDispose($oCurrentThread.thread.currentLayer.bmp)
	$oCurrentThread.thread.currentLayer.bmp = $tBmp
EndFunc

Func _Tiles_Event()
	If Not $isOpen Then Return 0
	_Tiles()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc
