#include-once

#cs
	REMARK: vPaint 4 Shaders [scintilla4evr]

	With the new Batch Processing tool, we have a tiny problem.
	Some of vPaint's effects are lousy when it comes to large
	images, while the Batch Processing tool is designed to work
	with large amounts of images without opening them in the app.
	Some of these images may be larger than others. So, some of the
	per-pixel effects will be done SIMULTANEOUSLY on all images.
	Now, Interference (helper library for vPaint, written in C) does
	not allow batch processing multiple images at once, so we need
	something else, something flexible enough to have the ability to
	work on multiple bitmaps at once. Answer? Shaders. These 'low-level'
	shaders are only PROCESSED by vPaint, before actual editing, to
	structures which are sent to one of the Interference modules to
	process.

#ce

#include <File.au3>
#include <Array.au3>

#include "V4SLEnum.au3"
#include "V4SLStruct.au3"

; (?i)([a-zA-Z0-9]+)\s+(.*)\s*>\s*([a-zA-Z0-9]+) for "putv4 0.3, 0.6, 0.1, 1 > VEC4SLOT1"
Func _V4SL_ProcessFile($sFile)
	Local $tRet = DllStructCreate($tagV4SL_SHADER)
	Local $aOps[0]

	For $i = 1 To _FileCountLines($sFile)
		$sLine = FileReadLine($sFile, $i)
		$sLine = StringStripWS($sLine, 7)

		If StringLeft($sLine, 2) = "//" Or $sLine = "" Then ContinueLoop

		$aRegexp = StringRegExp($sLine, "(?i)([a-zA-Z0-9]+)\s+(.*)\s*>\s*([a-zA-Z0-9]+)", 1)

		$tOp = DllStructCreate($tagV4SL_SHADEROPERATION)
		$tOp.opType = Eval(StringUpper("V4SL_OP_"&$aRegexp[0]))

		$aSplit = StringSplit($aRegexp[1], ",")
		For $j = 1 To $aSplit[0]
			$sVal = StringStripWS($aSplit[$j], 7)

			$vVal = Eval(StringUpper("V4SL_IO_"&$sVal))
			If @error Then $vVal = Number($sVal)

			$tOp.inputs($j) = $vVal
		Next

		$tOp.inputCount = $aSplit[0]
		$tOp.outSlot = Eval(StringUpper("V4SL_IO_"&$aRegexp[2]))

		_ArrayAdd($aOps, DllStructGetPtr($tOp))
	Next

	$tRet.itemCount = UBound($aOps)
	$tRet.version = $V4SL_VER_1_0

	For $i = 0 To UBound($aOps)-1
		$tRet.data($i+1) = $aOps[$i]
	Next

	Return $tRet
EndFunc