#include-once

Func _Whirl($iStep = 0.01, $iAngle = 180)
	$tBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	_ProgressOn("Applying effect...", "Iteration 0 of "&Int(1/$iStep))

	$tRgn = _GDIPlus_RegionCreate()
	$tPath = _GDIPlus_PathCreate()
	_GDIPlus_PathAddEllipse($tPath, 0, 0, $oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)

	_GDIPlus_RegionCombinePath($tRgn, $tPath, 3)

	_GDIPlus_GraphicsSetClipRegion($tGpx, $tRgn)
	;_GDIPlus_GraphicsDrawImageRect($tGpx, $oCurrentThread.thread.currentLayer.bmp, 0, 0, $oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)

	_GDIPlus_PathDispose($tPath)
	_GDIPlus_RegionDispose($tRgn)

	$angle = 0

	For $i = 1 To 0 Step -$iStep
		$angle = (1-$i)*$iAngle
		$tPath = _GDIPlus_PathCreate()

		$w = $oCurrentThread.thread.currentLayer.width*$i
		$h = $oCurrentThread.thread.currentLayer.height*$i
		_GDIPlus_PathAddEllipse($tPath, ($oCurrentThread.thread.currentLayer.width-$w)/2, ($oCurrentThread.thread.currentLayer.height-$h)/2, $w, $h)
		_GDIPlus_GraphicsSetClipPath($tGpx, $tPath, 0)

		_GDIPlus_PathReset($tPath)
		$w = $oCurrentThread.thread.currentLayer.width*($i-$iStep)
		$h = $oCurrentThread.thread.currentLayer.height*($i-$iStep)
		_GDIPlus_PathAddEllipse($tPath, ($oCurrentThread.thread.currentLayer.width-$w)/2, ($oCurrentThread.thread.currentLayer.height-$h)/2, $w, $h)

		_GDIPlus_GraphicsSetClipPath($tGpx, $tPath, 3)

		_GDIPlus_GraphicsDrawImageRect($tGpx, $oCurrentThread.thread.currentLayer.bmp, 0, 0, $oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
		_DrawRotated($tGpx, $oCurrentThread.thread.currentLayer.bmp, $oCurrentThread.thread.currentLayer.width/2, $oCurrentThread.thread.currentLayer.height/2, 0, 0, $angle)

		_GDIPlus_PathDispose($tPath)

		_ProgressSet("Applying effect...", "Iteration "&Int((1-$i)/$iStep)&" of "&Int(1/$iStep), 100*Int((1-$i)/$iStep)/Int(1/$iStep))
	Next

	_ProgressOff()

	_GDIPlus_GraphicsDispose($tGpx)
	_GDIPlus_BitmapDispose($oCurrentThread.thread.currentLayer.bmp)
	$oCurrentThread.thread.currentLayer.bmp = $tBmp
EndFunc

Func _Whirl_Event()
	If Not $isOpen Then Return 0
	_Whirl()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc
