#include-once

Func _StretchHistogram_Event()
	_Interference_HistogramStretch($oCurrentThread.thread.currentLayer.bmp)

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

Func _ConvertToPolar_Event()
	_Interference_ConvertToPolar($oCurrentThread.thread.currentLayer.bmp)

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

Func _GenerateXOR_Event()
	If Not $isOpen Then Return 0

	_ProgressOn("Applying effect...", "This can take a while.")
	_Interference_GenerateXOR($oCurrentThread.thread.currentLayer.bmp)
	_ProgressOff()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

Func _GenerateSTriangle_Event()
	If Not $isOpen Then Return 0

	_ProgressOn("Applying effect...", "This can take a while.")
	_Interference_GenerateSTriangle($oCurrentThread.thread.currentLayer.bmp)
	_ProgressOff()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

Func _ColorReplace_Event()
	If Not $isOpen Then Return 0

	_ProgressOn("Applying effect...", "This can take a while.")
	_Interference_ReplaceColor($oCurrentThread.thread.currentLayer.bmp, $iBackground, $iForeground)
	_ProgressOff()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

Func _Premultiply_Event()
	If Not $isOpen Then Return 0

	_ProgressOn("Applying effect...", "This can take a while.")
	_Interference_Premultiply($oCurrentThread.thread.currentLayer.bmp)
	_ProgressOff()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

Func _UnPremultiply_Event()
	If Not $isOpen Then Return 0

	_ProgressOn("Applying effect...", "This can take a while.")
	_Interference_UnPremultiply($oCurrentThread.thread.currentLayer.bmp)
	_ProgressOff()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

Func _GrayscaleNoise_Event()
	If Not $isOpen Then Return 0

	_ProgressOn("Applying effect...", "This can take a while.")
	_Interference_GenerateGrayscaleNoise($oCurrentThread.thread.currentLayer.bmp)
	_ProgressOff()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

Func _ColorNoise_Event()
	If Not $isOpen Then Return 0

	_ProgressOn("Applying effect...", "This can take a while.")
	_Interference_GenerateColorNoise($oCurrentThread.thread.currentLayer.bmp)
	_ProgressOff()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

Func _BlendEx_Event()
	If Not $isOpen Then Return 0

	_ProgressOn("Applying effect...", "This can take a while.")

	$iMode = $IF_NORMAL
	Switch @GUI_CtrlId
		Case $cidBlendDarken
			$iMode = $IF_DARKEN
		Case $cidBlendColorBurn
			$iMode = $IF_COLORBURN
		Case $cidBlendLighten
			$iMode = $IF_LIGHTEN
		Case $cidBlendScreen
			$iMode = $IF_SCREEN
		Case $cidBlendColorDodge
			$iMode = $IF_COLORDODGE
		Case $cidBlendSoftLight
			$iMode = $IF_SOFTLIGHT
		Case $cidBlendVividLight
			$iMode = $IF_VIVIDLIGHT
		Case $cidBlendDifference
			$iMode = $IF_DIFFERENCE
		Case $cidBlendExclusion
			$iMode = $IF_EXCLUSION
	EndSwitch
	_Interference_BlendColor($oCurrentThread.thread.currentLayer.bmp, $iForeground, $iMode)

	_ProgressOff()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

Func _BlurEx_Event()
	If Not $isOpen Then Return 0

	_ProgressOn("Applying effect...", "This can take a while.")
	_Blur()
	_Interference_UnPremultiply($oCurrentThread.thread.currentLayer.bmp)
	_ProgressOff()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

#cs
Global Enum $IF_NORMAL = 0, _
			$IF_DARKEN, _
			$IF_MULTIPLY, _
			$IF_COLORBURN, _
			$IF_LINEARBURN, _
			$IF_LIGHTEN, _
			$IF_SCREEN, _
			$IF_COLORDODGE, _
			$IF_LINEARDODGE, _
			$IF_OVERLAY, _
			$IF_SOFTLIGHT, _
			$IF_VIVIDLIGHT, _
			$IF_LINEARLIGHT, _
			$IF_PINLIGHT, _
			$IF_HARDMIX, _
			$IF_DIFFERENCE, _
			$IF_EXCLUSION, _
			$IF_SUBTRACT, _
			$IF_DIVIDE

	$cidBlendDarken = GUICtrlCreateMenuItem("Darken", $cidBlendFX, 0)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")
	$cidBlendColorBurn = GUICtrlCreateMenuItem("Color Burn", $cidBlendFX, 2)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")

	$cidBlendLighten = GUICtrlCreateMenuItem("Lighten", $cidBlendFX, 5)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")
	$cidBlendColorDodge = GUICtrlCreateMenuItem("Color Dodge", $cidBlendFX, 7)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")

	$cidBlendSoftLight = GUICtrlCreateMenuItem("Soft Light", $cidBlendFX, 10)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")
	$cidBlendVividLight = GUICtrlCreateMenuItem("Vivid Light", $cidBlendFX, 12)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")
#ce