#include-once

Global $aExtraCtrls[1] = [0], $oCurrentKnob = 0
Global $iSmoothValueChanging = 0

;_GUICtrl_OnHoverRegister($iCtrlID [, $sHover_Func="" [, $sLeaveHover_Func=-1 [, $sPrimaryDownFunc=-1 [, $sPrimaryUpFunc=-1 [, $iKeepCall_PrDn_Func=1 [, $iKeepCall_Hover_Func=0 ]]]]]])

Func _CreateKnob($fValue, $iX, $iY, $iW, $iH, $sCallFunc, $fCenterValue = 0, $iColor1 = 0xFF0080FF, $iColor2 = 0xFFDDDDDD, $iColor3 = 0xFFFFFFFF)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "value", $ELSCOPE_PUBLIC, $fValue)
	_AutoItObject_AddProperty($obj, "centerValue", $ELSCOPE_PUBLIC, $fCenterValue)
	_AutoItObject_AddProperty($obj, "func", $ELSCOPE_PUBLIC, $sCallFunc)

	_AutoItObject_AddProperty($obj, "ctrlX", $ELSCOPE_PUBLIC, $iX)
	_AutoItObject_AddProperty($obj, "ctrlY", $ELSCOPE_PUBLIC, $iY)

	_AutoItObject_AddProperty($obj, "width", $ELSCOPE_PUBLIC, $iW)
	_AutoItObject_AddProperty($obj, "height", $ELSCOPE_PUBLIC, $iH)

	_AutoItObject_AddProperty($obj, "color1", $ELSCOPE_PUBLIC, $iColor2)
	_AutoItObject_AddProperty($obj, "color2", $ELSCOPE_PUBLIC, $iColor1)
	_AutoItObject_AddProperty($obj, "color3", $ELSCOPE_PUBLIC, $iColor3)

	_AutoItObject_AddProperty($obj, "isPressed", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "y", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "oldValue", $ELSCOPE_PUBLIC, $fValue)

	$ctrl = GUICtrlCreateLabel("", $iX, $iY, $iW+1, $iH+1, $SS_BITMAP)

	_AutoItObject_AddProperty($obj, "ctrl", $ELSCOPE_PUBLIC, $ctrl)

	_AutoItObject_AddMethod($obj, "render", "_RenderKnob")

	$obj.render(0)

	_GUICtrl_OnHoverRegister($ctrl, "_OnHover", "_OnHover", "_Knob_OnPress", "_Knob_OnPress")

	_ArrayAdd($aExtraCtrls, $obj)
	$aExtraCtrls[0] += 1

	Return $ctrl
EndFunc

Func _RenderKnob($obj, $iState = 0)
	$hBmp = _GDIPlus_BitmapCreateFromScan0($obj.width+1, $obj.height+1)
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	_GDIPlus_GraphicsSetSmoothingMode($hGpx, 5)

	$width = _Min($obj.width, $obj.height)/8
	If $iState <> 0 Then $width *= 1.5

	$hBrush = _GDIPlus_BrushCreateSolid($obj.color1)
	_GDIPlus_GraphicsFillPie($hGpx, 0, 0, $obj.width, $obj.height, -225, 270, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	$hBrush = _GDIPlus_BrushCreateSolid(0x20000000)
	_GDIPlus_GraphicsFillPie($hGpx, $width*0.8, $width*0.8, $obj.width-$width*1.6, $obj.height-$width*1.6, -225, 270, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	$value = $obj.value-$obj.centerValue
	$angle = $value*270

	$hBrush = _GDIPlus_BrushCreateSolid($obj.color2)
	_GDIPlus_GraphicsFillPie($hGpx, 0, 0, $obj.width, $obj.height, -225+$obj.centerValue*270, $angle, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	$hBrush = _GDIPlus_BrushCreateSolid(0x10000000)
	_GDIPlus_GraphicsFillPie($hGpx, $width*0.9, $width*0.9, $obj.width-$width*1.8, $obj.height-$width*1.8, -225+$obj.centerValue*270, $angle, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	$hBrush = _GDIPlus_BrushCreateSolid(0x03000000)
	_GDIPlus_GraphicsFillPie($hGpx, $width*0.5, $width*0.5, $obj.width-$width, $obj.height-$width, 45, 90, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	$hBrush = _GDIPlus_BrushCreateSolid($obj.color3)
	_GDIPlus_GraphicsFillEllipse($hGpx, $width, $width, $obj.width-$width*2, $obj.height-$width*2, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	_GDIPlus_GraphicsDispose($hGpx)

	$hHBmp = _GDIPlus_BitmapCreateDIBFromBitmap($hBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $hHBmp))
	_WinAPI_DeleteObject($hHBmp)

	_GDIPlus_BitmapDispose($hBmp)
EndFunc

Func _Knob_OnPress($ctrlId, $iMode)
	$obj = _CtrlIDToObject($ctrlId)

	Switch $iMode
		Case 1
			If $obj.isPressed = 0 Then
				$obj.oldValue = $obj.value
				$obj.y = MouseGetPos(1)
				$obj.isPressed = 1
			Else
				$val = $obj.oldValue - (MouseGetPos(1)-$obj.y)/($obj.height*0.6)

				If $iSmoothValueChanging Then
					$obj.value = ($obj.value+_Max(_min($val, 1), 0))/2
				Else
					$obj.value = _Max(_min($val, 1), 0)
				EndIf
			EndIf
			$oCurrentKnob = $obj
			$obj.render(2)
			Call($obj.func, $obj)
		Case 2
			$obj.isPressed = 0
			$oCurrentKnob = 0
			$obj.render(1)
	EndSwitch
EndFunc

Func _CtrlIDToObject($ctrl)
	Local $idx = 0

	For $i = 1 To $aExtraCtrls[0]
		If $ctrl = ($aExtraCtrls[$i]).ctrl Then Return $aExtraCtrls[$i]
	Next

	Return 0
EndFunc

Func _CreateChannelLabel($sName, $iX, $iY, $iW, $iH, $iColor)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "name", $ELSCOPE_PUBLIC, $sName)

	_AutoItObject_AddProperty($obj, "ctrlX", $ELSCOPE_PUBLIC, $iX)
	_AutoItObject_AddProperty($obj, "ctrlY", $ELSCOPE_PUBLIC, $iY)

	_AutoItObject_AddProperty($obj, "width", $ELSCOPE_PUBLIC, $iW)
	_AutoItObject_AddProperty($obj, "height", $ELSCOPE_PUBLIC, $iH)

	_AutoItObject_AddProperty($obj, "color", $ELSCOPE_PUBLIC, $iColor)

	$ctrl = GUICtrlCreateLabel("", $iX, $iY, $iW+1, $iH+1, $SS_BITMAP)

	_AutoItObject_AddProperty($obj, "ctrl", $ELSCOPE_PUBLIC, $ctrl)

	_AutoItObject_AddMethod($obj, "render", "_RenderChannelLabel")

	$obj.render(0)

	_GUICtrl_OnHoverRegister($ctrl, "_OnHover", "_OnHover", "_OnPress", "_OnPress")

	_ArrayAdd($aExtraCtrls, $obj)
	$aExtraCtrls[0] += 1

	Return $ctrl
EndFunc

Func _ChannelLabelSetData($ctrl, $data)
	$obj = _CtrlIDToObject($ctrl)
	$obj.name = $data
	$obj.render()
EndFunc

Func _ChannelLabelSetColor($ctrl, $color)
	$obj = _CtrlIDToObject($ctrl)
	$obj.color = $color
	$obj.render()
EndFunc

;_GDIPlus_GraphicsDrawStringRect($hGraphics, $sString, $nX, $nY, $nWidth, $nHeight, $sFont = "Arial", $nSize = 10, $iStyle = 0, $iAlign = 0,$iFormat = 0, $iColor = 0xFF000000)

Func _RenderChannelLabel($obj, $iState = 0)
	$hBmp = _GDIPlus_BitmapCreateFromScan0($obj.width+1, $obj.height+1)
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	_GDIPlus_GraphicsSetSmoothingMode($hGpx, 5)

	$radius = $obj.height/6

	$hBrush = _GDIPlus_BrushCreateSolid($obj.color)
	_FillRoundRect($hGpx, 0, 0, $obj.width, $obj.height, $radius, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	$hBrush = _GDIPlus_LineBrushCreate(0, 0, 0, $obj.height, 0, 0x05000000)
	_FillRoundRect($hGpx, 0, 0, $obj.width, $obj.height, $radius, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	$hPen = _GDIPlus_PenCreate(0x55FFFFFF, 1)
	_DrawRoundRect($hGpx, 1, 1, $obj.width-2, $obj.height-2, $radius, $hPen)
	_GDIPlus_PenDispose($hPen)

	If $iState Then
		$hBrush = _GDIPlus_BrushCreateSolid(0x10000000)
		_FillRoundRect($hGpx, 0, 0, $obj.width, $obj.height, $radius, $hBrush)
		_GDIPlus_BrushDispose($hBrush)
	EndIf

	$hPen = _GDIPlus_PenCreate(0x4F000000, $iState+1)
	_DrawRoundRect($hGpx, $iState, $iState, $obj.width-$iState*2, $obj.height-$iState*2, $radius, $hPen)
	_GDIPlus_PenDispose($hPen)

	_GDIPlus_GraphicsDrawStringRect($hGpx, $obj.name, 0, $radius*0.67+1, $obj.width, $obj.height, "Segoe UI", $radius*2.5, 0, 1, 0, 0, 0x80000000)
	_GDIPlus_GraphicsDrawStringRect($hGpx, $obj.name, 0, $radius*0.67, $obj.width, $obj.height, "Segoe UI", $radius*2.5, 0, 1, 0, 0, 0xFFFFFFFF)

	_GDIPlus_GraphicsDispose($hGpx)

	$hHBmp = _GDIPlus_BitmapCreateDIBFromBitmap($hBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $hHBmp))
	_WinAPI_DeleteObject($hHBmp)

	_GDIPlus_BitmapDispose($hBmp)
EndFunc

Func _CreateStep($iX, $iY, $iW, $iH, $iColor)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "ctrlX", $ELSCOPE_PUBLIC, $iX)
	_AutoItObject_AddProperty($obj, "ctrlY", $ELSCOPE_PUBLIC, $iY)

	_AutoItObject_AddProperty($obj, "width", $ELSCOPE_PUBLIC, $iW)
	_AutoItObject_AddProperty($obj, "height", $ELSCOPE_PUBLIC, $iH)

	_AutoItObject_AddProperty($obj, "color", $ELSCOPE_PUBLIC, $iColor)

	_AutoItObject_AddProperty($obj, "active", $ELSCOPE_PUBLIC, 0)

	$ctrl = GUICtrlCreateLabel("", $iX, $iY, $iW+1, $iH+1, $SS_BITMAP)

	_AutoItObject_AddProperty($obj, "ctrl", $ELSCOPE_PUBLIC, $ctrl)

	_AutoItObject_AddMethod($obj, "render", "_RenderStep")

	$obj.render(0)

	_GUICtrl_OnHoverRegister($ctrl, "_OnHover", "_OnHover", "_OnPress", "_OnPress")

	_ArrayAdd($aExtraCtrls, $obj)
	$aExtraCtrls[0] += 1

	Return $ctrl
EndFunc

Func _StepActivate($ctrl, $state)
	$obj = _CtrlIDToObject($ctrl)
	$obj.active = $state
	$obj.render()
EndFunc

Func _StepSetColor($ctrl, $color)
	$obj = _CtrlIDToObject($ctrl)
	$obj.color = $color
	$obj.render()
EndFunc

Func _RenderStep($obj, $iState = 0)
	$hBmp = _GDIPlus_BitmapCreateFromScan0($obj.width+1, $obj.height+1)
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	_GDIPlus_GraphicsSetSmoothingMode($hGpx, 5)

	$radius = $obj.height/6

	$hBrush = _GDIPlus_BrushCreateSolid($obj.color)
	_FillRoundRect($hGpx, 0, 0, $obj.width, $obj.height, $radius, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	$hBrush = _GDIPlus_LineBrushCreate(0, 0, 0, $obj.height, 0, 0x05000000)
	_FillRoundRect($hGpx, 0, 0, $obj.width, $obj.height, $radius, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	$hPen = _GDIPlus_PenCreate(0x55FFFFFF, 1)
	_DrawRoundRect($hGpx, 1, 1, $obj.width-2, $obj.height-2, $radius, $hPen)
	_GDIPlus_PenDispose($hPen)

	If $iState Then
		$hBrush = _GDIPlus_BrushCreateSolid(0x10000000)
		_FillRoundRect($hGpx, 0, 0, $obj.width, $obj.height, $radius, $hBrush)
		_GDIPlus_BrushDispose($hBrush)
	EndIf

	$hPen = _GDIPlus_PenCreate(0x4F000000, $iState+1)
	_DrawRoundRect($hGpx, $iState, $iState, $obj.width-$iState*2, $obj.height-$iState*2, $radius, $hPen)
	_GDIPlus_PenDispose($hPen)

	If $obj.active = 0 Then
		$hPen = _GDIPlus_PenCreate(0x4F000000, 1)
		_GDIPlus_GraphicsDrawLine($hGpx, 4, 8, $obj.width-4, 8, $hPen)
		_GDIPlus_PenDispose($hPen)
	Else
		$hPen = _GDIPlus_PenCreate(0x4F000000, 3)
		_GDIPlus_GraphicsDrawLine($hGpx, 3, 8, $obj.width-3, 8, $hPen)
		_GDIPlus_PenDispose($hPen)

		$hPen = _GDIPlus_PenCreate(0xFFFFFFFF, 1)
		_GDIPlus_GraphicsDrawLine($hGpx, 4, 8, $obj.width-4, 8, $hPen)
		_GDIPlus_PenDispose($hPen)
	EndIf

	_GDIPlus_GraphicsDispose($hGpx)

	$hHBmp = _GDIPlus_BitmapCreateDIBFromBitmap($hBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $hHBmp))
	_WinAPI_DeleteObject($hHBmp)

	_GDIPlus_BitmapDispose($hBmp)
EndFunc

Func _CreateVertSlider($fValue, $hWnd, $iX, $iY, $iW, $iH, $sCallFunc, $iColor1 = 0xFF0080FF, $iColor2 = 0xFFDDDDDD, $iColor3 = 0xFFFFFFFF)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "value", $ELSCOPE_PUBLIC, $fValue)
	_AutoItObject_AddProperty($obj, "func", $ELSCOPE_PUBLIC, $sCallFunc)

	_AutoItObject_AddProperty($obj, "hWnd", $ELSCOPE_PUBLIC, $hWnd)

	_AutoItObject_AddProperty($obj, "ctrlX", $ELSCOPE_PUBLIC, $iX)
	_AutoItObject_AddProperty($obj, "ctrlY", $ELSCOPE_PUBLIC, $iY)

	_AutoItObject_AddProperty($obj, "width", $ELSCOPE_PUBLIC, $iW)
	_AutoItObject_AddProperty($obj, "height", $ELSCOPE_PUBLIC, $iH)

	_AutoItObject_AddProperty($obj, "color1", $ELSCOPE_PUBLIC, $iColor2)
	_AutoItObject_AddProperty($obj, "color2", $ELSCOPE_PUBLIC, $iColor1)
	_AutoItObject_AddProperty($obj, "color3", $ELSCOPE_PUBLIC, $iColor3)

	_AutoItObject_AddProperty($obj, "isPressed", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "y", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "oldValue", $ELSCOPE_PUBLIC, $fValue)

	$ctrl = GUICtrlCreateLabel("", $iX, $iY, $iW+1, $iH+1, $SS_BITMAP)

	_AutoItObject_AddProperty($obj, "ctrl", $ELSCOPE_PUBLIC, $ctrl)

	_AutoItObject_AddMethod($obj, "render", "_RenderVSlider")

	$obj.render(0)

	_GUICtrl_OnHoverRegister($ctrl, "_OnHover", "_OnHover", "_VSlider_OnPress", "_VSlider_OnPress")

	_ArrayAdd($aExtraCtrls, $obj)
	$aExtraCtrls[0] += 1

	Return $ctrl
EndFunc

Func _RenderVSlider($obj, $iState = 0)
	$hBmp = _GDIPlus_BitmapCreateFromScan0($obj.width+1, $obj.height+1)
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	_GDIPlus_GraphicsSetSmoothingMode($hGpx, 5)

	$width = _Min($obj.width, $obj.height)/8
	If $iState <> 0 Then $width *= 1.5

	$radius = $obj.width/4
	$y = (1-$obj.value)*($obj.height-$obj.width)
	$x = ($obj.width-$radius*2)/2
	$y += ($obj.width-$radius*2)/2

	$hBrush = _GDIPlus_BrushCreateSolid(0x09000000)
	_GDIPlus_GraphicsFillEllipse($hGpx, $x-$radius*0.5, $y-$radius*0.5, $radius*3, $radius*3, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	$x = ($obj.width-$obj.width/8)/2
	$y = $obj.width/4
	$h = $obj.height-$obj.width/2

	$hBrush = _GDIPlus_BrushCreateSolid($obj.color1)
	_FillRoundRect($hGpx, $x, $y, $obj.width/8, $h, $obj.width/16, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	$x = ($obj.width-$obj.width/8)/2
	$y = (1-$obj.value)*($obj.height-$obj.width)
	$h = Abs($y-($obj.height-$obj.width/2))-$radius
	$y += $obj.width/4+$radius

	$hBrush = _GDIPlus_BrushCreateSolid($obj.color2)
	_FillRoundRect($hGpx, $x, $y, $obj.width/8, $h, $obj.width/16, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	If $iState Then $radius *= 1 + 0.2*$iState
	$y = (1-$obj.value)*($obj.height-$obj.width)
	$x = ($obj.width-$radius*2)/2
	$y += ($obj.width-$radius*2)/2

	$hBrush = _GDIPlus_BrushCreateSolid($obj.color3)
	_GDIPlus_GraphicsFillEllipse($hGpx, $x, $y, $radius*2, $radius*2, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	_GDIPlus_GraphicsDispose($hGpx)

	$hHBmp = _GDIPlus_BitmapCreateDIBFromBitmap($hBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $hHBmp))
	_WinAPI_DeleteObject($hHBmp)

	_GDIPlus_BitmapDispose($hBmp)
EndFunc

Func _VSlider_OnPress($ctrlId, $iMode)
	$obj = _CtrlIDToObject($ctrlId)

	Switch $iMode
		Case 1
			$cInfo = GUIGetCursorInfo($obj.hwnd)
			$aPos = ControlGetPos(_WinAPI_GetParent(GUICtrlGetHandle($ctrlId)), "", $ctrlId)

			$y = $cInfo[1]-$aPos[1]-($obj.width/4)
			$val = 1 - $y/($aPos[3]-$obj.width/2)

			If $iSmoothValueChanging Then
				$obj.value = ($obj.value+_Max(_min($val, 1), 0))/2
			Else
				$obj.value = _Max(_min($val, 1), 0)
			EndIf

			$obj.render(2)
			Call($obj.func, $obj)
		Case 2
			$obj.isPressed = 0
			$oCurrentKnob = 0
			$obj.render(1)
	EndSwitch
EndFunc

Func _CreateHorzSlider($fValue, $hWnd, $iX, $iY, $iW, $iH, $sCallFunc, $iColor1 = 0xFF0080FF, $iColor2 = 0xFFDDDDDD, $iColor3 = 0xFFFFFFFF)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "value", $ELSCOPE_PUBLIC, $fValue)
	_AutoItObject_AddProperty($obj, "func", $ELSCOPE_PUBLIC, $sCallFunc)

	_AutoItObject_AddProperty($obj, "hWnd", $ELSCOPE_PUBLIC, $hWnd)

	_AutoItObject_AddProperty($obj, "ctrlX", $ELSCOPE_PUBLIC, $iX)
	_AutoItObject_AddProperty($obj, "ctrlY", $ELSCOPE_PUBLIC, $iY)

	_AutoItObject_AddProperty($obj, "width", $ELSCOPE_PUBLIC, $iW)
	_AutoItObject_AddProperty($obj, "height", $ELSCOPE_PUBLIC, $iH)

	_AutoItObject_AddProperty($obj, "color1", $ELSCOPE_PUBLIC, $iColor2)
	_AutoItObject_AddProperty($obj, "color2", $ELSCOPE_PUBLIC, $iColor1)
	_AutoItObject_AddProperty($obj, "color3", $ELSCOPE_PUBLIC, $iColor3)

	_AutoItObject_AddProperty($obj, "isPressed", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "y", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "oldValue", $ELSCOPE_PUBLIC, $fValue)

	$ctrl = GUICtrlCreateLabel("", $iX, $iY, $iW+1, $iH+1, $SS_BITMAP)

	_AutoItObject_AddProperty($obj, "ctrl", $ELSCOPE_PUBLIC, $ctrl)

	_AutoItObject_AddMethod($obj, "render", "_RenderHSlider")

	$obj.render(0)

	_GUICtrl_OnHoverRegister($ctrl, "_OnHover", "_OnHover", "_HSlider_OnPress", "_HSlider_OnPress")

	_ArrayAdd($aExtraCtrls, $obj)
	$aExtraCtrls[0] += 1

	Return $ctrl
EndFunc

Func _SliderSetValue($cidSlider, $fValue)
	$obj = _CtrlIDToObject($ctrlId)
	$obj.value = $fValue
	$obj.oldValue = $fValue
	$obj.render()
EndFunc

Func _RenderHSlider($obj, $iState = 0)
	$hBmp = _GDIPlus_BitmapCreateFromScan0($obj.width+1, $obj.height+1)
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	_GDIPlus_GraphicsSetSmoothingMode($hGpx, 5)

	$width = _Min($obj.width, $obj.height)/8
	If $iState <> 0 Then $width *= 1.5

	$radius = $obj.height/4
	$x = (1-$obj.value)*($obj.width-$obj.height)
	$y = ($obj.height-$radius*2)/2
	$x += ($obj.height-$radius*2)/2

	$hBrush = _GDIPlus_BrushCreateSolid(0x09000000)
	_GDIPlus_GraphicsFillEllipse($hGpx, $x-$radius*0.5, $y-$radius*0.5, $radius*3, $radius*3, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	$x = $obj.height/4
	$y = ($obj.height-$obj.height/8)/2
	$w = $obj.width-$obj.height/2

	$hBrush = _GDIPlus_BrushCreateSolid($obj.color1)
	_FillRoundRect($hGpx, $x, $y, $w, $obj.height/8, $obj.height/16, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	$x = $obj.height/4
	$y = ($obj.height-$obj.height/8)/2
	$w = (1-$obj.value)*($obj.width-$obj.height)+$radius

	$hBrush = _GDIPlus_BrushCreateSolid($obj.color2)
	_FillRoundRect($hGpx, $x, $y, $w, $obj.height/8, $obj.height/16, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	If $iState Then $radius *= 1 + 0.2*$iState
	$x = (1-$obj.value)*($obj.width-$obj.height)
	$y = ($obj.height-$radius*2)/2
	$x += ($obj.height-$radius*2)/2

	$hBrush = _GDIPlus_BrushCreateSolid($obj.color3)
	_GDIPlus_GraphicsFillEllipse($hGpx, $x, $y, $radius*2, $radius*2, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	_GDIPlus_GraphicsDispose($hGpx)

	$hHBmp = _GDIPlus_BitmapCreateDIBFromBitmap($hBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $hHBmp))
	_WinAPI_DeleteObject($hHBmp)

	_GDIPlus_BitmapDispose($hBmp)
EndFunc

Func _HSlider_OnPress($ctrlId, $iMode)
	$obj = _CtrlIDToObject($ctrlId)

	Switch $iMode
		Case 1
			$cInfo = GUIGetCursorInfo($obj.hwnd)
			$aPos = ControlGetPos(_WinAPI_GetParent(GUICtrlGetHandle($ctrlId)), "", $ctrlId)

			$y = $cInfo[0]-$aPos[0]-($obj.height/4)
			$val = 1 - $y/($aPos[2]-$obj.height/2)

			If $iSmoothValueChanging Then
				$obj.value = ($obj.value+_Max(_min($val, 1), 0))/2
			Else
				$obj.value = _Max(_min($val, 1), 0)
			EndIf

			$obj.render(2)
			Call($obj.func, $obj)
		Case 2
			$obj.isPressed = 0
			$oCurrentKnob = 0
			$obj.render(1)
	EndSwitch
EndFunc

Func _DrawRoundRect($hGpx, $iX, $iY, $iW, $iH, $iRadius, $hPen = 0)
	$tPath = _GDIPlus_PathCreate()

	$2r = $iRadius*2

	_GDIPlus_PathAddArc($tPath, $iX, $iY, $2r, $2r, -180, 90)
	_GDIPlus_PathAddLine($tPath, $iX+$iRadius, $iY, $iX+$iW-$iRadius, $iY)

	_GDIPlus_PathAddArc($tPath, $iX+$iW-$2r, $iY, $2r, $2r, -90, 90)
	_GDIPlus_PathAddLine($tPath, $iX+$iW, $iY+$iRadius, $iX+$iW, $iY+$iH-$iRadius)

	_GDIPlus_PathAddArc($tPath, $iX+$iW-$2r, $iY+$iH-$2r, $2r, $2r, 0, 90)
	_GDIPlus_PathAddLine($tPath, $iX+$iW-$iRadius, $iY+$iH, $iX+$iRadius, $iY+$iH)

	_GDIPlus_PathAddArc($tPath, $iX, $iY+$iH-$2r, $2r, $2r, 90, 90)
	_GDIPlus_PathAddLine($tPath, $iX, $iY+$iH-$iRadius, $iX, $iY+$iRadius)

	_GDIPlus_GraphicsDrawPath($hGpx, $tPath, $hPen)
	_GDIPlus_PathDispose($tPath)
EndFunc

Func _FillRoundRect($hGpx, $iX, $iY, $iW, $iH, $iRadius, $hBrush = 0)
	$tPath = _GDIPlus_PathCreate()

	$2r = $iRadius*2

	_GDIPlus_PathAddArc($tPath, $iX, $iY, $2r, $2r, -180, 90)
	_GDIPlus_PathAddLine($tPath, $iX+$iRadius, $iY, $iX+$iW-$iRadius, $iY)

	_GDIPlus_PathAddArc($tPath, $iX+$iW-$2r, $iY, $2r, $2r, -90, 90)
	_GDIPlus_PathAddLine($tPath, $iX+$iW, $iY+$iRadius, $iX+$iW, $iY+$iH-$iRadius)

	_GDIPlus_PathAddArc($tPath, $iX+$iW-$2r, $iY+$iH-$2r, $2r, $2r, 0, 90)
	_GDIPlus_PathAddLine($tPath, $iX+$iW-$iRadius, $iY+$iH, $iX+$iRadius, $iY+$iH)

	_GDIPlus_PathAddArc($tPath, $iX, $iY+$iH-$2r, $2r, $2r, 90, 90)
	_GDIPlus_PathAddLine($tPath, $iX, $iY+$iH-$iRadius, $iX, $iY+$iRadius)

	_GDIPlus_GraphicsFillPath($hGpx, $tPath, $hBrush)
	_GDIPlus_PathDispose($tPath)
EndFunc

Func _CreateSwitch($iValue, $iX, $iY, $iW, $iH, $sCallFunc, $iColor1 = 0xFF000000, $iColor2 = 0xFFFFFFFF, $iColor3 = 0xFF0080FF)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "value", $ELSCOPE_PUBLIC, $iValue)
	_AutoItObject_AddProperty($obj, "func", $ELSCOPE_PUBLIC, $sCallFunc)

	_AutoItObject_AddProperty($obj, "ctrlX", $ELSCOPE_PUBLIC, $iX)
	_AutoItObject_AddProperty($obj, "ctrlY", $ELSCOPE_PUBLIC, $iY)

	_AutoItObject_AddProperty($obj, "width", $ELSCOPE_PUBLIC, $iW)
	_AutoItObject_AddProperty($obj, "height", $ELSCOPE_PUBLIC, $iH)

	_AutoItObject_AddProperty($obj, "color1", $ELSCOPE_PUBLIC, $iColor1)
	_AutoItObject_AddProperty($obj, "color2", $ELSCOPE_PUBLIC, $iColor2)
	_AutoItObject_AddProperty($obj, "color3", $ELSCOPE_PUBLIC, $iColor3)

	_AutoItObject_AddProperty($obj, "isPressed", $ELSCOPE_PUBLIC, 0)

	$ctrl = GUICtrlCreateLabel("", $iX, $iY, $iW+1, $iH+1, $SS_BITMAP)

	_AutoItObject_AddProperty($obj, "ctrl", $ELSCOPE_PUBLIC, $ctrl)

	_AutoItObject_AddMethod($obj, "render", "_RenderSwitch")

	$obj.render(0)

	_GUICtrl_OnHoverRegister($ctrl, "_OnHover", "_OnHover", "_Switch_OnPress", "_Switch_OnPress")

	_ArrayAdd($aExtraCtrls, $obj)
	$aExtraCtrls[0] += 1

	Return $ctrl
EndFunc

Func _RenderSwitch($obj, $iState = 0)
	$hBmp = _GDIPlus_BitmapCreateFromScan0($obj.width+1, $obj.height+1)
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	_GDIPlus_GraphicsSetSmoothingMode($hGpx, 5)

	$r = $obj.height/2

	Switch $obj.value
		Case 0
			$hBrush = _GDIPlus_BrushCreateSolid($obj.color1)
			_FillRoundRect($hGpx, 0, 0, $obj.width, $obj.height, $r, $hBrush)
			_GDIPlus_BrushDispose($hBrush)

			$hBrush = _GDIPlus_BrushCreateSolid($obj.color2)
			_FillRoundRect($hGpx, 3, 3, $obj.width-6, $obj.height-6, $r-3, $hBrush)
			_GDIPlus_BrushDispose($hBrush)

			$hBrush = _GDIPlus_BrushCreateSolid($obj.color1)
			_GDIPlus_GraphicsFillEllipse($hGpx, 6, 6, $r*2-12, $r*2-12, $hBrush)
			_GDIPlus_BrushDispose($hBrush)
		Case 1
			$hBrush = _GDIPlus_BrushCreateSolid($obj.color3)
			_FillRoundRect($hGpx, 0, 0, $obj.width, $obj.height, $r, $hBrush)
			_GDIPlus_BrushDispose($hBrush)

			$hBrush = _GDIPlus_BrushCreateSolid($obj.color2)
			_GDIPlus_GraphicsFillEllipse($hGpx, $obj.width-$r*2+4, 6, $r*2-12, $r*2-12, $hBrush)
			_GDIPlus_BrushDispose($hBrush)
	EndSwitch

	_GDIPlus_GraphicsDispose($hGpx)

	$hHBmp = _GDIPlus_BitmapCreateDIBFromBitmap($hBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $hHBmp))
	_WinAPI_DeleteObject($hHBmp)

	_GDIPlus_BitmapDispose($hBmp)
EndFunc

Func _Switch_OnPress($ctrlId, $iMode)
	$obj = _CtrlIDToObject($ctrlId)

	Switch $iMode
		Case 1
			$obj.render(2)
		Case 2
			$obj.value = 1 - $obj.value
			$obj.render(1)
			Call($obj.func, $obj)
	EndSwitch
EndFunc

Func _OnHover($ctrlId, $iMode)
	$obj = _CtrlIDToObject($ctrlId)

	Switch $iMode
		Case 1
			$obj.render(1)
		Case 2
			$obj.isPressed = 0
			$obj.render(0)
	EndSwitch
EndFunc

Func _OnPress($ctrlId, $iMode)
	$obj = _CtrlIDToObject($ctrlId)

	Switch $iMode
		Case 1
			$obj.render(2)
		Case 2
			$obj.isPressed = 0
			$oCurrentKnob = 0
			$obj.render(1)
	EndSwitch
EndFunc

