#include-once

Func _ImgButtonDelete($oSelf)
	If Not IsObj($oSelf) Then Return
	_GDIPlus_ImageDispose($oSelf.img)
EndFunc

Func _CreateImgButton($sImg, $srcX, $srcY, $srcW, $srcH, $outX, $outY, $outW, $outH, $iColor1, $iColor2, $iColor3)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "imgsrc", Default, $sImg)
	_AutoItObject_AddProperty($obj, "img", Default, _GDIPlus_ImageLoadFromFile($sImg))

	_AutoItObject_AddProperty($obj, "srcX", Default, $srcX)
	_AutoItObject_AddProperty($obj, "srcY", Default, $srcY)
	_AutoItObject_AddProperty($obj, "srcW", Default, $srcW)
	_AutoItObject_AddProperty($obj, "srcH", Default, $srcH)

	_AutoItObject_AddProperty($obj, "outX", Default, $outX)
	_AutoItObject_AddProperty($obj, "outY", Default, $outY)
	_AutoItObject_AddProperty($obj, "outW", Default, $outW)
	_AutoItObject_AddProperty($obj, "outH", Default, $outH)

	_AutoItObject_AddProperty($obj, "color1", Default, $iColor1)
	_AutoItObject_AddProperty($obj, "color2", Default, $iColor2)
	_AutoItObject_AddProperty($obj, "color3", Default, $iColor3)

	_AutoItObject_AddProperty($obj, "extra", Default, 0)

	_AutoItObject_AddDestructor($obj, "_ImgButtonDelete")

	$ctrl = GUICtrlCreateLabel($aImgCtrls[0]+1, $outX, $outY, $outW, $outH, $SS_BITMAP)

	_AutoItObject_AddProperty($obj, "ctrl", Default, $ctrl)

	_ArrayAdd($aImgCtrls, $obj)
	$aImgCtrls[0] += 1

	_ImgButton_Render0($ctrl, 2)

	_GUICtrl_OnHoverRegister($ctrl, "_ImgButton_Render0", "_ImgButton_Render0", "_ImgButton_Render1", "_ImgButton_Render1")

	Return $ctrl
EndFunc

Func _ImgButton_SetColors($ctrl, $color1, $color2, $color3, $bRender = True)
	If $isClosing Then Return 0

	$i = Int(GUICtrlRead($ctrl))
	$obj = $aImgCtrls[$i]

	$obj.color1 = $color1
	$obj.color2 = $color2
	$obj.color3 = $color3

	If $bRender Then _ImgButton_Render0($ctrl, 2)
EndFunc

Func _ImgButton_SetExtra($ctrl, $extra)
	If $isClosing Then Return 0

	$i = Int(GUICtrlRead($ctrl))
	$obj = $aImgCtrls[$i]

	$obj.extra = $extra
EndFunc

Func _ImgButton_GetImageSource($ctrl)
	If $isClosing Then Return 0

	$i = Int(GUICtrlRead($ctrl))
	$obj = $aImgCtrls[$i]

	Return $obj.imgsrc
EndFunc

Func _ImgButton_SetImage($ctrl, $sImg, $bRender = True)
	If $isClosing Then Return 0

	$i = Int(GUICtrlRead($ctrl))
	$obj = $aImgCtrls[$i]

	_GDIPlus_ImageDispose($obj.img)
	$obj.img = _GDIPlus_ImageLoadFromFile($sImg)

	If $bRender Then _ImgButton_Render0($ctrl, 2)
EndFunc

Func _CreateImgButton2($sImg, $sText, $srcX, $srcY, $srcW, $srcH, $outX, $outY, $outW, $outH, $iSize, $iColor1, $iColor2, $iColor3, $iColor4)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "img", Default, _GDIPlus_ImageLoadFromFile($sImg))

	_AutoItObject_AddProperty($obj, "srcX", Default, $srcX)
	_AutoItObject_AddProperty($obj, "srcY", Default, $srcY)
	_AutoItObject_AddProperty($obj, "srcW", Default, $srcW)
	_AutoItObject_AddProperty($obj, "srcH", Default, $srcH)

	_AutoItObject_AddProperty($obj, "outX", Default, $outX)
	_AutoItObject_AddProperty($obj, "outY", Default, $outY)
	_AutoItObject_AddProperty($obj, "outW", Default, $outW)
	_AutoItObject_AddProperty($obj, "outH", Default, $outH)

	_AutoItObject_AddProperty($obj, "color1", Default, $iColor1)
	_AutoItObject_AddProperty($obj, "color2", Default, $iColor2)
	_AutoItObject_AddProperty($obj, "color3", Default, $iColor3)
	_AutoItObject_AddProperty($obj, "color4", Default, $iColor4)

	_AutoItObject_AddDestructor($obj, "_ImgButtonDelete")

	_AutoItObject_AddProperty($obj, "text", Default, $sText)
	_AutoItObject_AddProperty($obj, "size", Default, $iSize)

	$ctrl = GUICtrlCreateLabel($aImgCtrls[0]+1, $outX, $outY, $outW, $outH, $SS_BITMAP)

	_AutoItObject_AddProperty($obj, "ctrl", Default, $ctrl)

	_ArrayAdd($aImgCtrls, $obj)
	$aImgCtrls[0] += 1

	_ImgButton2_Render0($ctrl, 2)

	_GUICtrl_OnHoverRegister($ctrl, "_ImgButton2_Render0", "_ImgButton2_Render0", "_ImgButton2_Render1", "_ImgButton2_Render1")

	Return $ctrl
EndFunc

Func _ImgButton_Render0($ctrl, $state)
	If $isClosing Then Return 0

	$i = Int(GUICtrlRead($ctrl))
	$obj = $aImgCtrls[$i]

	If Not IsObj($obj) Then Return

	$hBmp = _GDIPlus_BitmapCreateFromScan0($obj.outW, $obj.outH)
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)

	Switch $state
		Case 1
			_GDIPlus_GraphicsClear($hGpx, $obj.color2)
		Case 2
			_GDIPlus_GraphicsClear($hGpx, $obj.color1)
	EndSwitch

	_GDIPlus_GraphicsDrawImageRectRect($hGpx, $obj.img, $obj.srcX, $obj.srcY, $obj.srcW, $obj.srcH, ($obj.outW-$obj.srcW)/2, ($obj.outH-$obj.srcH)/2, $obj.srcW, $obj.srcH)

	_GDIPlus_GraphicsDispose($hGpx)
	_SetCtrlBmp($ctrl, $hBmp)
	_GDIPlus_BitmapDispose($hBmp)
EndFunc

Func _ImgButton_Render1($ctrl, $state)
	If $isClosing Then Return 0

	$i = Int(GUICtrlRead($ctrl))
	$obj = $aImgCtrls[$i]

	If Not IsObj($obj) Then Return

	$hBmp = _GDIPlus_BitmapCreateFromScan0($obj.outW, $obj.outH)
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)

	Switch $state
		Case 1
			_GDIPlus_GraphicsClear($hGpx, $obj.color3)
		Case 2
			_GDIPlus_GraphicsClear($hGpx, $obj.color2)
	EndSwitch

	_GDIPlus_GraphicsDrawImageRectRect($hGpx, $obj.img, $obj.srcX, $obj.srcY, $obj.srcW, $obj.srcH, ($obj.outW-$obj.srcW)/2, ($obj.outH-$obj.srcH)/2, $obj.srcW, $obj.srcH)

	_GDIPlus_GraphicsDispose($hGpx)
	_SetCtrlBmp($ctrl, $hBmp)
	_GDIPlus_BitmapDispose($hBmp)
EndFunc

Func _ImgButton2_Render0($ctrl, $state)
	If $isClosing Then Return 0

	$i = Int(GUICtrlRead($ctrl))
	$obj = $aImgCtrls[$i]

	If Not IsObj($obj) Then Return

	$hBmp = _GDIPlus_BitmapCreateFromScan0($obj.outW, $obj.outH)
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	_GDIPlus_GraphicsSetTextRenderingHint($hGpx, 3)

	Switch $state
		Case 1
			_GDIPlus_GraphicsClear($hGpx, $obj.color2)
		Case 2
			_GDIPlus_GraphicsClear($hGpx, $obj.color1)
	EndSwitch

	_GDIPlus_GraphicsDrawImageRectRect($hGpx, $obj.img, $obj.srcX, $obj.srcY, $obj.srcW, $obj.srcH, ($obj.outH-$obj.srcW)/2, ($obj.outH-$obj.srcH)/2, $obj.srcW, $obj.srcH)

	Local $aSize = _StringSize(String($obj.text), $obj.size, 400, 0, $v4Setting_UI_FontFamily)
	_GDIPlus_GraphicsDrawString2($hGpx, $obj.text, $obj.outH-4, ($obj.outH-$aSize[3])/2, $v4Setting_UI_FontFamily, $obj.size, 0, $obj.color4)

	_GDIPlus_GraphicsDispose($hGpx)
	_SetCtrlBmp($ctrl, $hBmp)
	_GDIPlus_BitmapDispose($hBmp)
EndFunc

Func _ImgButton2_Render1($ctrl, $state)
	If $isClosing Then Return 0

	$i = Int(GUICtrlRead($ctrl))
	$obj = $aImgCtrls[$i]

	If Not IsObj($obj) Then Return

	$hBmp = _GDIPlus_BitmapCreateFromScan0($obj.outW, $obj.outH)
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	_GDIPlus_GraphicsSetTextRenderingHint($hGpx, 3)

	Switch $state
		Case 1
			_GDIPlus_GraphicsClear($hGpx, $obj.color3)
		Case 2
			_GDIPlus_GraphicsClear($hGpx, $obj.color2)
	EndSwitch

	_GDIPlus_GraphicsDrawImageRectRect($hGpx, $obj.img, $obj.srcX, $obj.srcY, $obj.srcW, $obj.srcH, ($obj.outH-$obj.srcW)/2, ($obj.outH-$obj.srcH)/2, $obj.srcW, $obj.srcH)

	Local $aSize = _StringSize(String($obj.text), $obj.size, 400, 0, $v4Setting_UI_FontFamily)
	_GDIPlus_GraphicsDrawString2($hGpx, $obj.text, $obj.outH-4, ($obj.outH-$aSize[3])/2, $v4Setting_UI_FontFamily, $obj.size, 0, $obj.color4)

	_GDIPlus_GraphicsDispose($hGpx)
	_SetCtrlBmp($ctrl, $hBmp)
	_GDIPlus_BitmapDispose($hBmp)
EndFunc

Func _SetCtrlBmp($ctrl, $bmp)
	$ghbmp = _GDIPlus_BitmapCreateHBITMAPFromBitmap($bmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($ctrl), 0x0172, 0, $ghbmp))
	_WinAPI_DeleteObject($ghbmp)
EndFunc

Func _GDIPlus_GraphicsDrawString2($hGraphics, $sString, $nX, $nY, $sFont = "Arial", $nSize = 10, $iFormat = 0, $iColor = 0xFF000000)
	Local $hBrush = _GDIPlus_BrushCreateSolid($iColor)
	Local $hFormat = _GDIPlus_StringFormatCreate($iFormat)
	Local $hFamily = _GDIPlus_FontFamilyCreate($sFont)
	Local $hFont = _GDIPlus_FontCreate($hFamily, $nSize)
	Local $tLayout = _GDIPlus_RectFCreate($nX, $nY, 0.0, 0.0)
	Local $aInfo = _GDIPlus_GraphicsMeasureString($hGraphics, $sString, $hFont, $tLayout, $hFormat)
	If @error Then Return SetError(@error, @extended, 0)
	Local $aResult = _GDIPlus_GraphicsDrawStringEx($hGraphics, $sString, $hFont, $aInfo[0], $hFormat, $hBrush)
	Local $iError = @error, $iExtended = @extended
	_GDIPlus_FontDispose($hFont)
	_GDIPlus_FontFamilyDispose($hFamily)
	_GDIPlus_StringFormatDispose($hFormat)
	_GDIPlus_BrushDispose($hBrush)
	Return SetError($iError, $iExtended, $aResult)
EndFunc
