#include-once
#include <GUIConstants.au3>
#include <GDIPlus.au3>
#include <WinAPIEx.au3>
#include <Array.au3>


Global $g_NODE_aCtrls[1] = [0]

Func _Node_CreateNodeUI($hWnd, $iX, $iY, $iW, $iH, $oList, $sOnChange = "")
	Local $obj = _AutoItObject_Create()

	$ctrl = GUICtrlCreateLabel("", $iX, $iY, $iW, $iH, $SS_BITMAP)

	_AutoItObject_AddProperty($obj, "ctrl", $ELSCOPE_PUBLIC, $ctrl)
	_AutoItObject_AddProperty($obj, "hwnd", $ELSCOPE_PUBLIC, $hWnd)

	_AutoItObject_AddProperty($obj, "ctrlX", $ELSCOPE_PUBLIC, $iX)
	_AutoItObject_AddProperty($obj, "ctrlY", $ELSCOPE_PUBLIC, $iY)

	_AutoItObject_AddProperty($obj, "viewX", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "viewY", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "list", $ELSCOPE_PUBLIC, $oList)

	_AutoItObject_AddProperty($obj, "isPressed", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "currentNode", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "renderOnce", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "isMoving", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "moveDx", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "moveDy", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "isConnecting", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "currentInput", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "connectX", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "connectY", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "isDisconnecting", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "currentNode2", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "currentOutput", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "fullBmp", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "change", $ELSCOPE_PUBLIC, $sOnChange)

	_AutoItObject_AddMethod($obj, "render", "__Node_RenderUI")
	_AutoItObject_AddMethod($obj, "renderOnMove", "__Node_RenderUI_OnMove")
	_AutoItObject_AddMethod($obj, "renderOnConnect", "__Node_RenderUI_OnConnect")

	_ArrayAdd($g_NODE_aCtrls, $obj)
	$g_NODE_aCtrls[0] += 1

	_GUICtrl_OnHoverRegister($ctrl, "__Blank", "__Blank", "__Node_UIOnPress", "__Node_UIOnPress")

	$obj.render()

	Return $ctrl
EndFunc

Func _Node_GetNodeFromXY($obj, $x, $y)
	$aSize = WinGetPos(GUICtrlGetHandle($obj.ctrl))

	For $node In $obj.list
		$nx = $aSize[2]/2 + $obj.viewX + $node.uiX
		$ny = $aSize[3]/2 + $obj.viewY + $node.uiY

		If $nx < $x And $ny < $y And $x < $nx+$node.uiWidth And $y < $ny+$node.uiHeight Then Return $node
	Next

	Return 0
EndFunc

Func _Node_GetNodePos($obj, $node)
	$aSize = WinGetPos(GUICtrlGetHandle($obj.ctrl))

	Local $nx = $aSize[2]/2 + $obj.viewX + $node.uiX
	Local $ny = $aSize[3]/2 + $obj.viewY + $node.uiY
	Local $arr[2] = [$nx, $ny]

	Return $arr
EndFunc

Func _Node_GetObjFromCtrl($ctrl)
	For $i = 1 To $g_NODE_aCtrls[0]
		If $ctrl = ($g_NODE_aCtrls[$i]).ctrl Then Return $g_NODE_aCtrls[$i]
	Next

	Return 0
EndFunc

Func __Node_RenderUI_OnMove($oSelf)
	$aSize = _ControlGetPos($oSelf.ctrl)

	$hBmp = _GDIPlus_BitmapCreateFromScan0($aSize[2], $aSize[3])
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	_GDIPlus_GraphicsClear($hGpx, 0xFFAAAAAA)
	_GDIPlus_GraphicsSetSmoothingMode($hGpx, 5)

	$pOutline = _GDIPlus_PenCreate(0xAAFFFFFF, 3)

	$aPos = _Node_GetNodePos($oSelf, $oSelf.currentNode)

	_GDIPlus_GraphicsDrawImageRect($hGpx, $oSelf.fullBmp, 0, 0, $aSize[2], $aSize[3])
	_DrawRoundRect($hGpx, $aPos[0], $aPos[1], $oSelf.currentNode.uiWidth, $oSelf.currentNode.uiHeight, 5, $pOutline)

	_GDIPlus_PenDispose($pOutline)

	_GDIPlus_GraphicsDispose($hGpx)

	$hGpx = _GDIPlus_GraphicsCreateFromHWND(GUICtrlGetHandle($oSelf.ctrl))
	_GDIPlus_GraphicsDrawImageRect($hGpx, $hBmp, 0, 0, $aSize[2], $aSize[3])
	_GDIPlus_GraphicsDispose($hGpx)

	_GDIPlus_BitmapDispose($hBmp)
EndFunc

Func __Node_RenderUI_OnConnect($oSelf, $iX, $iY)
	$aSize = _ControlGetPos($oSelf.ctrl)

	$hBmp = _GDIPlus_BitmapCreateFromScan0($aSize[2], $aSize[3])
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	_GDIPlus_GraphicsClear($hGpx, 0xFFAAAAAA)
	_GDIPlus_GraphicsSetSmoothingMode($hGpx, 5)

	$pOutline = _GDIPlus_PenCreate(0xAAFFFFFF, 3)
	_GDIPlus_PenSetLineCap($pOutline, 2, 2, 2)
	_GDIPlus_PenSetDashStyle($pOutline, 1)

	$aPos = _Node_GetNodePos($oSelf, $oSelf.currentNode)

	_GDIPlus_GraphicsDrawImageRect($hGpx, $oSelf.fullBmp, 0, 0, $aSize[2], $aSize[3])

	$dX = Abs($iX-$oSelf.connectX)

	;_GDIPlus_GraphicsDrawLine($hGpx, $oSelf.connectX, $oSelf.connectY, $iX, $iY, $pOutline)
	_GDIPlus_GraphicsDrawBezier($hGpx, $oSelf.connectX, $oSelf.connectY, $oSelf.connectX+$dX/2, $oSelf.connectY, $iX-$dX/2, $iY, $iX, $iY, $pOutline)

	_GDIPlus_PenDispose($pOutline)

	_GDIPlus_GraphicsDispose($hGpx)

	$hGpx = _GDIPlus_GraphicsCreateFromHWND(GUICtrlGetHandle($oSelf.ctrl))
	_GDIPlus_GraphicsDrawImageRect($hGpx, $hBmp, 0, 0, $aSize[2], $aSize[3])
	_GDIPlus_GraphicsDispose($hGpx)

	_GDIPlus_BitmapDispose($hBmp)
EndFunc

Func __Node_RenderUI($oSelf)
	$aSize = _ControlGetPos($oSelf.ctrl)
	If Not IsArray($aSize) Then Return

	If $oSelf.fullBmp <> 0 Then _GDIPlus_BitmapDispose($oSelf.fullBmp)

	$hBmp = _GDIPlus_BitmapCreateFromScan0($aSize[2], $aSize[3])
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	_GDIPlus_GraphicsClear($hGpx, 0xFFAAAAAA)
	_GDIPlus_GraphicsSetSmoothingMode($hGpx, 5)
	_GDIPlus_GraphicsSetTextRenderingHint($hGpx, 5)

	$bBg = _GDIPlus_HatchBrushCreate(43, 0x40000000, 0)
	_GDIPlus_GraphicsFillRect($hGpx, 0, 0, $aSize[2], $aSize[3], $bBg)
	_GDIPlus_BrushDispose($bBg)

	$bNodeFill = _GDIPlus_BrushCreateSolid(0xB0DDDDDD)
	$pOutline = _GDIPlus_PenCreate(0x70000000)

	$bInput = _GDIPlus_HatchBrushCreate(23, 0xFF224422, 0xFF336633)
	$bOutput = _GDIPlus_HatchBrushCreate(23, 0xFF223344, 0xFF334766)

	$pConnector = _GDIPlus_PenCreate(0xFF000000, 6)
	_GDIPlus_PenSetLineCap($pConnector, 2, 2, 0)

	For $oNode In $oSelf.list
		$x = $aSize[2]/2 + $oSelf.viewX + $oNode.uiX
		$y = $aSize[3]/2 + $oSelf.viewY + $oNode.uiY

		_FillRoundRect($hGpx, $x, $y, $oNode.uiWidth, $oNode.uiHeight, 5, $bNodeFill)
		_DrawRoundRect($hGpx, $x, $y, $oNode.uiWidth, $oNode.uiHeight, 5, $pOutline)

		_GDIPlus_GraphicsDrawStringRect($hGpx, $oNode.name, $x+5, $y+5, 190, 35, $v4Setting_UI_FontFamily, 11)

		$iYOffset = $oNode.crender(0, 0, 0, 0, 0)
		$oNode.crender(1, $hGpx, _GDIPlus_RectFCreate(0, 30, $oNode.uiWidth, $iYOffset), 0, 0)

		For $i = 0 To ($oNode.input.count-1)
			$aInPos = $oNode.calcInXY($i)

			_GDIPlus_GraphicsFillPie($hGpx, $x+$aInPos[0]-10, $y+$aInPos[1]+5, 20, 20, -90, 180, $bInput)
			_GDIPlus_GraphicsDrawArc($hGpx, $x+$aInPos[0]-10, $y+$aInPos[1]+5, 20, 20, -90, 180, $pOutline)

			_GDIPlus_GraphicsDrawStringRect($hGpx, StringUpper(($oNode.input.at($i)).name), $x+20, $y+$aInPos[1]+3, 160, 30, $v4Setting_UI_FontFamily, 12, 0, 0, 0, 0, 0xFF005500)

			If IsObj(($oNode.input.at($i)).node) Then
				$oPrevNode = ($oNode.input.at($i)).node
				$x2 = $aSize[2]/2 + $oSelf.viewX + $oPrevNode.uiX
				$y2 = $aSize[3]/2 + $oSelf.viewY + $oPrevNode.uiY

				$aPrevOutPos = $oPrevNode.calcOutXY(($oNode.input.at($i)).nodeOut)

				$x1 = $x2+$aPrevOutPos[0]+15
				$y1 = $y2+$aPrevOutPos[1]+15
				$x2 = $x+$aInPos[0]
				$y2 = $y+$aInPos[1]+15
				$dX = Abs($x2-$x1)

				;_GDIPlus_GraphicsDrawLine($hGpx, $x2+$aPrevOutPos[0]+15, $y2+$aPrevOutPos[1]+15, $x+$aInPos[0], $y+$aInPos[1]+15, $pConnector)
				_GDIPlus_GraphicsDrawBezier($hGpx, $x1, $y1, $x1+$dX/2, $y1, $x2-$dX/2, $y2, $x2, $y2, $pConnector)
			EndIf
		Next

		For $i = 0 To ($oNode.output.count-1)
			$aInPos = $oNode.calcOutXY($i)

			_GDIPlus_GraphicsFillPie($hGpx, $x+$aInPos[0]+5, $y+$aInPos[1]+5, 20, 20, 90, 180, $bOutput)
			_GDIPlus_GraphicsDrawArc($hGpx, $x+$aInPos[0]+5, $y+$aInPos[1]+5, 20, 20, 90, 180, $pOutline)

			_GDIPlus_GraphicsDrawStringRect($hGpx, StringUpper(($oNode.output.at($i)).name), $x+20, $y+$aInPos[1]+3, 160, 30, $v4Setting_UI_FontFamily, 12, 0, 2, 0, 0, 0xFF002755)
		Next
	Next

	_GDIPlus_PenDispose($pConnector)

	_GDIPlus_BrushDispose($bInput)
	_GDIPlus_BrushDispose($bOutput)

	_GDIPlus_PenDispose($pOutline)
	_GDIPlus_BrushDispose($bNodeFill)

	_GDIPlus_GraphicsDispose($hGpx)

	$tHBMP = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($oSelf.ctrl), 0x172, 0, $tHBMP))
	_WinAPI_DeleteObject($tHBMP)

	$oSelf.fullBmp = $hBmp
	$oSelf.renderOnce = 0
EndFunc

Func __Blank($v1, $v2)
EndFunc

Func __Node_UIOnPress($ctrl, $state)
	$obj = _Node_GetObjFromCtrl($ctrl)

	Switch $state
		Case 1
			$cInfo = GUIGetCursorInfo($obj.hwnd)
			$aCtrlPos = _ControlGetPos($obj.ctrl)

			$cInfo[0] -= $aCtrlPos[0]
			$cInfo[1] -= $aCtrlPos[1]

			$obj.isPressed = 1
			$obj.renderOnce = 1

			If Not IsObj($obj.currentNode) Then $obj.currentNode = _Node_GetNodeFromXY($obj, $cInfo[0], $cInfo[1])

			If IsObj($obj.currentNode) And $obj.isConnecting = 0 And $obj.isMoving = 0 And $obj.isDisconnecting = 0 Then
				$arr = _Node_GetNodePos($obj, $obj.currentNode)
				$x = $cInfo[0]-$arr[0]
				$y = $cInfo[1]-$arr[1]
				If $y > 40 And $y < ($obj.currentNode.uiHeight-20) And $x > 185 Then
					$obj.currentInput = Int(($y-30*$obj.currentNode.input.count-40-$obj.currentNode.crender(0, 0, 0, 0, 0))/30)

					$obj.connectX = $cInfo[0]
					$obj.connectY = $cInfo[1]

					$obj.isConnecting = 1
				ElseIf $y > 40 And $y < ($obj.currentNode.uiHeight-20) And $x < 15 Then
					$obj.currentInput = Int(($y-40-$obj.currentNode.crender(0, 0, 0, 0, 0))/30)
					$obj.currentOutput = ($obj.currentNode.input.at($obj.currentInput)).nodeOut

					$node2 = ($obj.currentNode.input.at($obj.currentInput)).node

					$obj.currentNode2 = $obj.currentNode
					$obj.currentNode = $node2

					If IsObj($obj.currentNode) Then
						$aPos = _Node_GetNodePos($obj, $obj.currentNode)
						$aOutPos = $obj.currentNode.calcOutXY($obj.currentOutput)

						$obj.connectX = $aPos[0]+$aOutPos[0]+15
						$obj.connectY = $aPos[1]+$aOutPos[1]+15

						$obj.isDisconnecting = 1
					EndIf
				Else
					$obj.isMoving = 1
					$obj.moveDx = $cInfo[0]-$arr[0]
					$obj.moveDy = $cInfo[1]-$arr[1]
				EndIf
			EndIf

			If $obj.isConnecting = 1 Then
				$obj.renderOnConnect($cInfo[0], $cInfo[1])
			ElseIf $obj.isDisconnecting = 1 Then
				$obj.renderOnConnect($cInfo[0], $cInfo[1])
			ElseIf $obj.isMoving = 1 Then
				$arr = _Node_GetNodePos($obj, $obj.currentNode)
				$dX = $cInfo[0]-($obj.moveDx+$arr[0])
				$dY = $cInfo[1]-($obj.moveDy+$arr[1])

				$obj.currentNode.uiX += $dX
				$obj.currentNode.uiY += $dY

				$obj.renderOnMove()
			EndIf
		Case 2
			If $obj.currentNode = 0 Then Return 0

			$cInfo = GUIGetCursorInfo($obj.hwnd)
			$aCtrlPos = _ControlGetPos($obj.ctrl)

			$cInfo[0] -= $aCtrlPos[0]
			$cInfo[1] -= $aCtrlPos[1]

			If $obj.isConnecting = 1 Then
				$cInfo = GUIGetCursorInfo()
				$aCtrlPos = _ControlGetPos($obj.ctrl)

				$cInfo[0] -= $aCtrlPos[0]
				$cInfo[1] -= $aCtrlPos[1]

				$oNode = _Node_GetNodeFromXY($obj, $cInfo[0], $cInfo[1])

				If IsObj($oNode) And $obj.currentNode.nodeId <> $oNode.nodeId Then
					$arr = _Node_GetNodePos($obj, $oNode)
					$x = $cInfo[0]-$arr[0]
					$y = $cInfo[1]-$arr[1]
					If $x < 15 And $y > 40 And $y < ($oNode.uiHeight-20) Then
						$iInput = Int(($y-40-$obj.currentNode.crender(0, 0, 0, 0, 0))/30)
						$oInput = $oNode.input.at($iInput)
						$oInput.node = $obj.currentNode
						$oInput.nodeOut = $obj.currentInput

						If $obj.change <> "" Then Call($obj.change, $obj.list)
					EndIf
				EndIf
			ElseIf $obj.isDisconnecting = 1 Then

				$oInput = $obj.currentNode2.input.at($obj.currentInput)

				$oNewInput = _Node_GetNodeFromXY($obj, $cInfo[0], $cInfo[1])
				$bSwitch = False
				$iNewInput = 0

				If IsObj($oNewInput) Then
					$arr = _Node_GetNodePos($obj, $oNewInput)
					$x = $cInfo[0]-$arr[0]
					$y = $cInfo[1]-$arr[1]

					If $y > 40 And $y < ($oNewInput.uiHeight-20) And $x < 15 Then
						$iNewInput = Int(($y-40-$obj.currentNode.crender(0, 0, 0, 0, 0))/30)
						If $iNewInput < $oNewInput.input.count Then $bSwitch = True
					EndIf
				EndIf

				If $bSwitch Then
					If $obj.currentNode.nodeId <> $oNewInput.nodeId Then
						$oInput2 = $oNewInput.input.at($iNewInput)
						$tempNode = $oInput2.node
						$tempNodeOut = $oInput2.nodeOut

						$oInput2.node = $oInput.node
						$oInput2.nodeOut = $oInput.nodeOut

						$oInput.node = $tempNode
						$oInput.nodeOut = $tempNodeOut
					Else
						$oInput.node = 0
						$oInput.nodeOut = 0
					EndIf
				Else
					$oInput.node = 0
					$oInput.nodeOut = 0
				EndIf

				If $obj.change <> "" Then Call($obj.change, $obj.list)
			EndIf

			$obj.isPressed = 0
			$obj.isMoving = 0
			$obj.isConnecting = 0
			$obj.isDisconnecting = 0
			$obj.currentNode = 0
			$obj.render()
	EndSwitch
EndFunc

Func _ControlGetPos($cidCtrl)
	$hCtrl = GUICtrlGetHandle($cidCtrl)

	Return ControlGetPos(_WinAPI_GetParent($hCtrl), "", $cidCtrl)
EndFunc
