#include-once

Func _CreateEffectLayer($sEffectString)
	$obj = _AutoItObject_Create()

	$split = StringSplit($sEffectString, ";")

	_AutoItObject_AddProperty($obj, "type", $ELSCOPE_PUBLIC, $V4_LT_EFFECT)
	_AutoItObject_AddProperty($obj, "name", $ELSCOPE_PUBLIC, $split[1])

	_AutoItObject_AddProperty($obj, "string", $ELSCOPE_PUBLIC, $sEffectString)

	_AutoItObject_AddProperty($obj, "isVisible", $ELSCOPE_PUBLIC, 1)
	_AutoItObject_AddProperty($obj, "lockMode", $ELSCOPE_PUBLIC, $V4_LL_NONE)

	_AutoItObject_AddProperty($obj, "canDraw", $ELSCOPE_PUBLIC, 1)
	_AutoItObject_AddProperty($obj, "isSmart", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "ref", $ELSCOPE_PUBLIC, 1)

	;_AutoItObject_AddProperty($obj, "bmp", $ELSCOPE_PUBLIC, $hBmp) no rendering here

	_AutoItObject_AddMethod($obj, "clone", "_EffectLayer_Clone")
	_AutoItObject_AddMethod($obj, "apply", "_EffectLayer_Apply")
	_AutoItObject_AddMethod($obj, "dispose", "_EffectLayer_Dispose")

	_AutoItObject_AddDestructor($obj, "_EffectLayer_GdipEffect_Dispose")

	Return $obj
EndFunc

Func _EffectLayer_Apply($oSelf, $hBmp)
	$split = StringSplit($oSelf.string, ";")
	$fnFXFunc = $split[2]

	$sCall = 'Call("'&$fnFXFunc&'"'

	For $p = 3 To $split[0]
		$sCall &= ", "&$split[$p]
	Next

	$sCall &= ", $hBmp)"

	Execute($sCall)
EndFunc

Func _EffectLayer_Clone($oSelf)
	Return _CreateEffectLayer($oSelf.string)
EndFunc

Func _EffectLayer_Dispose(ByRef $oSelf)
	$oSelf = 0
EndFunc
