#include-once

Func _CreateImageLayer($hBmp, $iX = 0, $iY = 0, $iW = 0, $iH = 0)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "type", $ELSCOPE_PUBLIC, $V4_LT_IMAGE)
	_AutoItObject_AddProperty($obj, "name", $ELSCOPE_PUBLIC, "Image")
	_AutoItObject_AddProperty($obj, "opacity", $ELSCOPE_PUBLIC, 100)
	_AutoItObject_AddProperty($obj, "blendMode", $ELSCOPE_PUBLIC, $IF_NORMAL) ; see Base/Experimental/Interference/Interference.au3 for more

	_AutoItObject_AddProperty($obj, "enableRouting", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "routeFlags", $ELSCOPE_PUBLIC, 0x00010203)

	_AutoItObject_AddProperty($obj, "isVisible", $ELSCOPE_PUBLIC, 1)
	_AutoItObject_AddProperty($obj, "lockMode", $ELSCOPE_PUBLIC, $V4_LL_NONE)

	_AutoItObject_AddProperty($obj, "x", $ELSCOPE_PUBLIC, $iX)
	_AutoItObject_AddProperty($obj, "y", $ELSCOPE_PUBLIC, $iY)

	_AutoItObject_AddProperty($obj, "canDraw", $ELSCOPE_PUBLIC, 1)
	_AutoItObject_AddProperty($obj, "isSmart", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "ref", $ELSCOPE_PUBLIC, 1)

	_AutoItObject_AddProperty($obj, "width", $ELSCOPE_PUBLIC, _GDIPlus_ImageGetWidth($hBmp))
	_AutoItObject_AddProperty($obj, "height", $ELSCOPE_PUBLIC, _GDIPlus_ImageGetHeight($hBmp))

	_AutoItObject_AddProperty($obj, "bmp", $ELSCOPE_PUBLIC, $hBmp)

	_AutoItObject_AddMethod($obj, "clone", "_ImageLayer_Clone")
	_AutoItObject_AddMethod($obj, "render", "_ImageLayer_Render")
	_AutoItObject_AddMethod($obj, "dispose", "_ImageLayer_Dispose")

	_AutoItObject_AddDestructor($obj, "_ImageLayer_Dispose")

	Return $obj
EndFunc

Func _ImageLayer_Render($oSelf, $iQuality = 0)
	; nothing!
EndFunc

Func _ImageLayer_Clone($oSelf)
	$layer = _CreateImageLayer(_GDIPlus_ImageClone($oSelf.bmp), $oSelf.x, $oSelf.y)

	$layer.name = $oSelf.name
	$layer.opacity = $oSelf.opacity
	$layer.blendMode = $oSelf.blendMode
	$layer.enableRouting = $oSelf.enableRouting
	$layer.routeFlags = $oSelf.routeFlags
	$layer.isVisible = $oSelf.isVisible
	$layer.lockMode = $oSelf.lockMode
	$layer.canDraw = $oSelf.canDraw
	$layer.isSmart = $oSelf.isSmart

	Return $layer
EndFunc

Func _ImageLayer_Dispose(ByRef $oSelf)
	_GDIPlus_BitmapDispose($oSelf.bmp)
	$oSelf = 0
EndFunc
