#include-once

Func _CreateTextLayer($sText, $iX, $iY, $sFont, $iSize, $iStyle, $iColor)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "type", $ELSCOPE_PUBLIC, $V4_LT_TEXT)
	_AutoItObject_AddProperty($obj, "name", $ELSCOPE_PUBLIC, "Text")

	_AutoItObject_AddProperty($obj, "width", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "height", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "x", $ELSCOPE_PUBLIC, $iX)
	_AutoItObject_AddProperty($obj, "y", $ELSCOPE_PUBLIC, $iY)

	_AutoItObject_AddProperty($obj, "text", $ELSCOPE_PUBLIC, $sText)
	_AutoItObject_AddProperty($obj, "font", $ELSCOPE_PUBLIC, $sFont)
	_AutoItObject_AddProperty($obj, "size", $ELSCOPE_PUBLIC, $iSize)
	_AutoItObject_AddProperty($obj, "style", $ELSCOPE_PUBLIC, $iStyle)
	_AutoItObject_AddProperty($obj, "color", $ELSCOPE_PUBLIC, $iColor)

	_AutoItObject_AddProperty($obj, "bmp", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddMethod($obj, "clone", "_CreateTextLayer_Clone")
	_AutoItObject_AddMethod($obj, "render", "_CreateTextLayer_Render")
	_AutoItObject_AddMethod($obj, "dispose", "_CreateTextLayer_Dispose")

	_AutoItObject_AddMethod($obj, "showContext", "_CreateTextLayer_ContextMenu")

	_AutoItObject_AddDestructor($obj, "_CreateTextLayer_Dispose")

	Return $obj
EndFunc

Func _CreateTextLayer_Render($oSelf)
	If $oSelf.bmp <> 0 Then _GDIPlus_BitmapDispose($oSelf.bmp)

	$tBmp = _GDIPlus_BitmapCreateFromScan0($oSelf.width, $oSelf.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)
	_GDIPlus_GraphicsSetTextRenderingHint($tGpx, 3)

	$hBrush = _GDIPlus_BrushCreateSolid($oSelf.color)
	$hFormat = _GDIPlus_StringFormatCreate()
	$hFamily = _GDIPlus_FontFamilyCreate($oSelf.font)
	$hFont = _GDIPlus_FontCreate($hFamily, $oSelf.size, $oSelf.style)
	$tLayout = _GDIPlus_RectFCreate($oSelf.x, $oSelf.y, 0, 0)
	$aInfo = _GDIPlus_GraphicsMeasureString($tGpx, $oSelf.text, $hFont, $tLayout, $hFormat)

	_GDIPlus_GraphicsDrawStringEx($tGpx, $oSelf.text, $hFont, $aInfo[0], $hFormat, $hBrush)

	_GDIPlus_FontDispose($hFont)
	_GDIPlus_FontFamilyDispose($hFamily)
	_GDIPlus_StringFormatDispose($hFormat)
	_GDIPlus_BrushDispose($hBrush)

	_GDIPlus_GraphicsDispose($tGpx)

	$oSelf.bmp = $tBmp
EndFunc

Func _CreateTextLayer_Clone($oSelf)
	Return _CreateTextLayer($oSelf.text, $oSelf.x, $oSelf.y, $oSelf.font, $oSelf.size, $oSelf.style, $oSelf.color)
EndFunc

Func _CreateTextLayer_Dispose(ByRef $oSelf)
	$oSelf = 0
EndFunc
