#include-once

Func _CreateSelection($sName)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "name", $ELSCOPE_PUBLIC, $sName)
	_AutoItObject_AddProperty($obj, "rgn", $ELSCOPE_PUBLIC, _GDIPlus_RegionCreate())

	_AutoItObject_AddMethod($obj, "clone", "_Selection_Clone")
	_AutoItObject_AddMethod($obj, "dispose", "_Selection_Dispose")

	_AutoItObject_AddDestructor($obj, "_Selection_Dispose")

	Return $obj
EndFunc

Func _Selection_Dispose(ByRef $oSelf)
	_GDIPlus_RegionDispose($oSelf.rgn)
	$oSelf = 0
EndFunc

Func _Selection_Clone($oSelf)
	Local $obj = _CreateSelection($oSelf.name)

	_GDIPlus_RegionDispose($obj.rgn)
	$obj.rgn = _GDIPlus_RegionClone($oSelf.rgn)

	Return $obj
EndFunc