#include-once

Func _POV_CreatePerspectiveCamera($oPos, $oLookAt, $fAngle = 75)
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "pos", $ELSCOPE_PUBLIC, $oPos)
	_AutoItObject_AddProperty($obj, "lookat", $ELSCOPE_PUBLIC, $oLookAt)
	_AutoItObject_AddProperty($obj, "fov", $ELSCOPE_PUBLIC, $fAngle)

	_AutoItObject_AddMethod($obj, "Clone", "_POV_ClonePerspectiveCamera")
	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GeneratePerspectiveCameraCode")

	Return $obj
EndFunc

Func _POV_ClonePerspectiveCamera($oSelf)
	Return _POV_CreatePerspectiveCamera($oSelf.pos.Clone(), $oSelf.lookat.Clone(), $oSelf.fov)
EndFunc

Func _POV_GeneratePerspectiveCameraCode($oSelf)
	Local $sCode

	$sCode = "camera {"&@CRLF

	$sCode &= "location <"&$oSelf.pos.v1&", "&$oSelf.pos.v2&", "&$oSelf.pos.v3&">"&@CRLF
	$sCode &= "look_at <"&$oSelf.lookat.v1&", "&$oSelf.lookat.v2&", "&$oSelf.lookat.v3&">"&@CRLF

	$sCode &= "}"&@CRLF

	Return $sCode
EndFunc
