#include-once

Func _POV_CreateFactory($oObjectList = LinkedList(), $oLightList = LinkedList(), $oCamera = 0, $oIncludeList = LinkedList())
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "objects", $ELSCOPE_PUBLIC, $oObjectList)
	_AutoItObject_AddProperty($obj, "lights", $ELSCOPE_PUBLIC, $oLightList)
	_AutoItObject_AddProperty($obj, "camera", $ELSCOPE_PUBLIC, $oCamera)
	_AutoItObject_AddProperty($obj, "includes", $ELSCOPE_PUBLIC, $oIncludeList)

	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GenerateFactoryCode")

	Return $obj
EndFunc

Func _POV_GenerateFactoryCode($oSelf)
	Local $sCode

	For $sInclude In $oSelf.includes
		$sCode &= '#include "'&$sInclude&'"'&@CRLF
	Next

	$sCode &= $oSelf.camera.GenCode()&@CRLF

	For $oLight In $oSelf.lights
		$sCode &= $oLight.GenCode()&@CRLF
	Next

	For $oObject In $oSelf.objects
		$sCode &= $oObject.GenCode()&@CRLF
	Next

	Return $sCode
EndFunc
