#include-once
#include "PluginEvents.au3"

Global $aExternalPlugins[1] = [0]
_ScanForPlugins()

Func _ScanForPlugins()
	Local $i = 0
	$fArr = _FileListToArray(@ScriptDir&"\Plugins", "*.ini", 1)
	If Not IsArray($fArr) Then Return

	For $i = 1 To $fArr[0]
		$obj = _CreatePlugin(@ScriptDir&"\Plugins\"&$fArr[$i])

		_ArrayAdd($aExternalPlugins, $obj)
		$aExternalPlugins[0] += 1
	Next
EndFunc

Func _CreatePlugin($sFile)
	Local $i = 0
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "name", $ELSCOPE_PUBLIC, IniRead($sFile, "Plugin", "Name", ""))
	_AutoItObject_AddProperty($obj, "author", $ELSCOPE_PUBLIC, IniRead($sFile, "Plugin", "Author", ""))

	_AutoItObject_AddProperty($obj, "dlls", $ELSCOPE_PUBLIC, LinkedList())

	$sections = IniReadSectionNames($sFile)
	If Not IsArray($sections) Then Return $obj

	For $i = 1 To $sections[0]
		If $sections[$i] <> "Plugin" Then
			$dll = IniRead($sFile, $sections[$i], "File", "")
			$uidef = IniRead($sFile, $sections[$i], "UIDefinition", "")
			$menuitem = IniRead($sFile, $sections[$i], "MenuItem", "")

			$obj.dlls.add(_CreatePluginDLL($dll, $uidef, $menuitem))
		EndIf
	Next

	Return $obj
EndFunc

Func _CreatePluginDLL($sDLL, $sUIDef, $sMenuItem)
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "dll", $ELSCOPE_PUBLIC, @ScriptDir&"\Plugins\"&$sDLL)
	_AutoItObject_AddProperty($obj, "uiDef", $ELSCOPE_PUBLIC, _ParseUIDefinition(@ScriptDir&"\Plugins\"&$sUIDef))
	_AutoItObject_AddProperty($obj, "menuItem", $ELSCOPE_PUBLIC, $sMenuItem)

	_AutoItObject_AddProperty($obj, "eventCtrl", $ELSCOPE_PUBLIC, 0) ; will be filled when creating main window

	Return $obj
EndFunc

Func _ParseUIDefinition($sUIDef)
	Local $i = 0
	Local $obj = LinkedList()

	$ctrls = IniReadSectionNames($sUIDef)
	If Not IsArray($ctrls) Then Return $obj

	For $i = 1 To $ctrls[0]
		Local $ctrl = _AutoItObject_Create()

		Local $ctrlProps = IniReadSection($sUIDef, $ctrls[$i])
		For $j = 1 To $ctrlProps[0][0]
			_AutoItObject_AddProperty($ctrl, $ctrlProps[$j][0], $ELSCOPE_PUBLIC, $ctrlProps[$j][1])
		Next

		_AutoItObject_AddProperty($ctrl, "name", $ELSCOPE_PUBLIC, $ctrls[$i])
		_AutoItObject_AddProperty($ctrl, "uiCtrl", $ELSCOPE_PUBLIC, 0) ; will be set when you'll use the plugin
		$obj.add($ctrl)
	Next

	Return $obj
EndFunc
