#include-once

Func _EffectPlugin_Event()
	If Not $isOpen Then Return

	Local $dllObj = -1

	For $i = 1 To $aExternalPlugins[0]
		$obj = $aExternalPlugins[$i]

		For $dll In $obj.dlls
			If $dll.eventCtrl = @GUI_CtrlId Then
				$dllObj = $dll
				ExitLoop
			EndIf
		Next

		If $dllObj <> -1 Then ExitLoop
	Next

	ConsoleWrite("Plugin: "&$dllObj.dll&@CRLF)

	$hPlugin = DllOpen($dllObj.dll)

	$vRet = _ShowPluginUI($dllObj, $hPlugin)

	If $vRet <> -1 Then
		$pStruct = DllStructGetPtr($vRet)

		$hBmp = $oCurrentThread.thread.currentLayer.bmp

		$iW = _GDIPlus_ImageGetWidth($hBmp)
		$iH = _GDIPlus_ImageGetHeight($hBmp)
		$tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
		$iScan0 = DllStructGetData($tBData, "Scan0")

		$aCall = DllCall($hPlugin, "int:cdecl", "ApplyEffect", "ptr", $iScan0, "int", $iW, "int", $iH, "ptr", $pStruct)

		_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

		$oCurrentThread.historyAdd()
		_RenderDrawingArea()
	EndIf

	DllClose($hPlugin)
EndFunc

Func _ShowPluginUI($dllObj, $hPlugin)
	Local $guiW = 312
	Local $guiH = 53+67*$dllObj.uiDef.count()
	Local $vReturn = -1

	$iOpt = Opt("GUIOnEventMode", 0)

	$hPluginUI = GUICreate($dllObj.menuItem, $guiW, $guiH, -1, -1, -1, -1, $hMainUI)

	Local $x = 10

	For $ctrl In $dllObj.uiDef
		GUICtrlCreateLabel($ctrl.DisplayName, 8, $x, 297, 24)
		GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

		$uiCtrl = 0
		Switch $ctrl.Type
			Case "Integer"
				$uiCtrl = GUICtrlCreateSlider(8, $x+24, 297, 33)
				GUICtrlSetLimit(-1, $ctrl.Max, $ctrl.Min)
			Case "Float"
				$uiCtrl = GUICtrlCreateSlider(8, $x+24, 297, 33)
				GUICtrlSetLimit(-1, 500, 0)
			Case "Popup"
				$uiCtrl = GUICtrlCreateCombo("", 8, $x+24, 297, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
				GUICtrlSetData(-1,$ctrl.PopupString, $ctrl.Default)
				GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")
			Case "Color"
				$uiCtrl = GUICtrlCreateLabel("color:"&0xFF0000, 8, $x+24, 297, 25, $WS_BORDER)
				GUICtrlSetBkColor(-1, 0xFF0000)
				GUICtrlSetColor(-1, 0xFF0000)
		EndSwitch

		$ctrl.uiCtrl = $uiCtrl

		$x += 67
	Next

	$cidAbout = GUICtrlCreateButton("About", 8, $guiH-43, 89, 33)

	$cidCancel = GUICtrlCreateButton("Cancel", 216, $guiH-43, 89, 33)
	$cidOK = GUICtrlCreateButton("OK", 120, $guiH-43, 89, 33)

	GUISetState()

	While 1
		Switch GUIGetMsg()
			Case -3, $cidCancel
				ExitLoop
			Case $cidAbout
				;GetAboutStr
				$aCall = DllCall($hPlugin, "wstr:cdecl", "GetAboutStr")
				MsgBox(0, "About plugin", $aCall[0], 0, $hPluginUI)
			Case $cidOK
				$sStruct = ""
				For $ctrl In $dllObj.uiDef
					Switch $ctrl.Type
						Case "Integer", "Popup", "Color"
							$sStruct &= "int;"
						Case "Float"
							$sStruct &= "float;"
					EndSwitch
				Next

				$tStruct = DllStructCreate($sStruct)
				$index = 1
				For $ctrl In $dllObj.uiDef
					Switch $ctrl.Type
						Case "Integer"
							DllStructSetData($tStruct, $index, GUICtrlRead($ctrl.uiCtrl))
						Case "Float"
							$value = GUICtrlRead($ctrl.uiCtrl)
							$value = $ctrl.Min + ($value/500)*($ctrl.Max-$ctrl.Min)

							DllStructSetData($tStruct, $index, $value)
						Case "Popup"
							DllStructSetData($tStruct, $index, _GUICtrlComboBox_GetCurSel($ctrl.uiCtrl))
						Case "Color"
							DllStructSetData($tStruct, $index, StringTrimLeft(GUICtrlRead($ctrl.uiCtrl), 6))
					EndSwitch

					$index += 1
				Next

				$vReturn = $tStruct

				ExitLoop
			Case Else
				$idCtrl = GUIGetMsg()
				If StringLeft(GUICtrlRead($idCtrl), 6) = "color:" Then
					ConsoleWrite("d")
					For $ctrl In $dllObj.uiDef
						If $ctrl.type = "Color" And $ctrl.uiCtrl = $idCtrl Then
							$iColor = _ColorPicker($ctrl.DisplayName, StringTrimLeft(GUICtrlRead($ctrl.uiCtrl), 6))
							GUICtrlSetBkColor($ctrl.uiCtrl, $iColor)
							GUICtrlSetColor($ctrl.uiCtrl, $iColor)
							GUICtrlSetData($ctrl.uiCtrl, "color:"&$iColor)
							ExitLoop
						EndIf
					Next
				EndIf
		EndSwitch
	WEnd

	GUIDelete($hPluginUI)
	Opt("GUIOnEventMode", $iOpt)

	Return $vReturn
EndFunc
