#include-once

Global Enum $GID_BEGIN = 1, _
			$GID_END, _
			$GID_ZOOM, _
			$GID_PAN, _
			$GID_ROTATE, _
			$GID_TWOFINGERTAP, _
			$GID_PRESSANDDTAP

Global $iGestureStartX, $iGestureStartY

Global Const $tagPOINTS = "struct;short X;short Y;endstruct"
Global Const $tagGESTUREINFO = "UINT cbSize; DWORD dwFlags; DWORD dwID; HWND hwndTarget;"  & $tagPOINTS &  ";DWORD dwInstanceID; DWORD dwSequenceID; UINT64 ullArgumengs; UINT cbExtraArgs"

Func WM_GESTURE($hWnd, $iMsg, $wParam, $lParam)
	$tGestureInfo = DllStructCreate($tagGESTUREINFO)
	DllStructSetData($tGestureInfo, "cbSize", DllStructGetSize($tGestureInfo))
	$pGestureInfo = DllStructGetPtr($tGestureInfo)
	DllCall("User32.dll", "BOOL", "GetGestureInfo", "HANDLE", $lParam, "struct*", $pGestureInfo)

	$isHandled = 0

	Switch $tGestureInfo.dwID
		Case $GID_BEGIN
			$iGestureStartX = $tGestureInfo.X
			$iGestureStartY = $tGestureInfo.Y
		Case $GID_END
			$iGestureStartX = 0
			$iGestureStartY = 0
		Case $GID_PAN
			If $isOpen Then
				$iDiffX = $tGestureInfo.X-$iGestureStartX
				$iDiffY = $tGestureInfo.Y-$iGestureStartY

				$oCurrentThread.viewDx += $iDiffX/$oCurrentThread.zoom
				$oCurrentThread.viewDy += $iDiffY/$oCurrentThread.zoom

				$iGestureStartX = $tGestureInfo.X
				$iGestureStartY = $tGestureInfo.Y
			EndIf

			ConsoleWrite("+> Gesture: PAN"&@CRLF)
			$isHandled = 1
		Case $GID_ROTATE
			$fAngle = _GestureRotateAngleFromArgument($tGestureInfo.ullArgumengs)
			$iDeg = _Degree($fAngle)

			ConsoleWrite("+> Gesture: ROTATE, Angle: "&$iDeg&@CRLF)
			$isHandled = 1
		Case $GID_TWOFINGERTAP
			_SwapForeBack()

			ConsoleWrite("+> Gesture: TWOFINGERTAP"&@CRLF)
			$isHandled = 1
		Case $GID_PRESSANDDTAP

			ConsoleWrite("+> Gesture: PRESSANDTAP"&@CRLF)
			$isHandled = 1
	EndSwitch

	DllCall("user32.dll", "bool", "CloseGestureInfoHandle", "handle", $lParam)

	If $isHandled Then Return 0
	Return $GUI_RUNDEFMSG
EndFunc

; Macro from winuser.h
Func _GestureRotateAngleFromArgument($ullArgument)
	Return ((($ullArgument/ 65535.0) * 4.0 * 3.14159265) - 2.0 * 3.14159265)
EndFunc
