#include-once

Func _D2D1_GeometrySinkSetFillMode($oGeometrySink, $iFillMode = $D2D1_FILL_MODE_ALTERNATE)
	$oGeometrySink.SetFillMode($iFillMode)
EndFunc

Func _D2D1_GeometrySinkBeginFigure($oGeometrySink, $fStartX, $fStartY, $iBeginMode = $D2D1_FIGURE_BEGIN_FILLED)
	$oGeometrySink.BeginFigure($fStartX, $fStartY, $iBeginMode)
EndFunc

Func _D2D1_GeometrySinkEndFigure($oGeometrySink, $iEndMode = $D2D1_FIGURE_END_OPEN)
	$oGeometrySink.EndFigure($iEndMode)
EndFunc

Func _D2D1_GeometrySinkAddArc($oGeometrySink, $oArcSegment)
	$oGeometrySink.AddArc($oArcSegment())
EndFunc

Func _D2D1_GeometrySinkAddLine($oGeometrySink, $fX, $fY)
	$oGeometrySink.AddLine($fX, $fY)
EndFunc

Func _D2D1_GeometrySinkAddLines($oGeometrySink, $aPoints)
	Local $oPoints = __D2D1_CreatePointList($aPoints)

	$oGeometrySink.AddLines($oPoints(), $aPoints[0][0])
EndFunc

Func _D2D1_GeometrySinkAddBezier($oGeometrySink, $fX1, $fY1, $fX2, $fY2, $fX3, $fY3)
	Local $aPoints[4][2] = [[3, 0], [$fX1, $fY1], [$fX2, $fY2], [$fX3, $fY3]]
	Local $oPoints = __D2D1_CreatePointList($aPoints)

	$oGeometrySink.AddBezier($oPoints())
EndFunc

Func _D2D1_GeometrySinkAddQuadraticBeziers($oGeometrySink, $aPoints)
	Local $oPoints = __D2D1_CreatePointList($aPoints)

	$oGeometrySink.AddQuadraticBeziers($oPoints(), $aPoints[0][0]/2)
EndFunc

Func _D2D1_GeometrySinkClose($oGeometrySink)
	$oGeometrySink.Close()
EndFunc
