#include-once

Func _D2D1_CreateHWNDRenderTarget($oFactory, $oRenderTargetProperties, $oHWNDRenderTargetProperties)
	Local $aCall = $oFactory.CreateHwndRenderTarget($oRenderTargetProperties(), $oHWNDRenderTargetProperties(), 0)

	Local $pRenderTarget = $aCall[3]
	Local $oRenderTarget = _AutoItObject_WrapperCreate($pRenderTarget, $dtagID2D1RenderTarget)

	Return $oRenderTarget
EndFunc

Func _D2D1_CreateDCRenderTarget($oFactory, $oRenderTargetProperties)
	Local $aCall = $oFactory.CreateDCRenderTarget($oRenderTargetProperties(), 0)

	Local $pRenderTarget = $aCall[2]
	Local $oRenderTarget = _AutoItObject_WrapperCreate($pRenderTarget, $dtagID2D1DCRenderTarget)

	Return $oRenderTarget
EndFunc

Func _D2D1_BindDC($oDCRenderTarget, $hDC, $tRect)
	$oDCRenderTarget.BindDC(Number($hDC), Number(DllStructGetPtr($tRect)))
EndFunc

Func _D2D1_BeginDraw($oRenderTarget)
	$oRenderTarget.BeginDraw()
EndFunc

Func _D2D1_EndDraw($oRenderTarget)
	$oRenderTarget.EndDraw(0, 0)
EndFunc

Func _D2D1_Clear($oRenderTarget, $oColorF)
	$oRenderTarget.Clear($oColorF())
EndFunc

Func _D2D1_SetAntialiasMode($oRenderTarget, $iMode)
	$oRenderTarget.SetAntialiasMode($iMode)
EndFunc

Func _D2D1_GetAntialiasMode($oRenderTarget)
	Return $oRenderTarget.GetAntialiasMode()
EndFunc
