#include-once

Global $tagD2D1_BITMAP_PROPERTIES = "dword format;dword alphaMode;FLOAT dpiX;FLOAT dpiY;"
Global $tagD2D1_GRADIENT_STOP = "FLOAT position;FLOAT r;FLOAT g;FLOAT b;"
Global $tagD2D1_BITMAP_BRUSH_PROPERTIES = "dword extendModeX;dword extendModeY;dword interpolationMode;"
Global $tagD2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES = "FLOAT startX;FLOAT startY;FLOAT endX;FLOAT endY;"

Global $tagD2D1_RECTF = "float left;float top; float right;float bottom;"
Global $tagD2D1_ELLIPSE = "float centerX;float centerY; float radiusX;float radiusY;"
Global $tagD2D1_ROUNDED_RECT = $tagD2D1_RECTF & "float radiusX; float radiusY;"
Global $tagD2D1_ARC_SEGMENT = "float endX;float endY;float radiusX;float radiusY;float rotationAngle;dword sweepDirection;dword arcSize;"

Global $tagD2D1_SIZE_F = "float width; float height;"
Global $tagD2D1_SIZE_U = "uint width; uint height;"

Global $tagD2D1_STROKE_PROPERTIES = "dword startCap;dword endCap;dword dashCap;dword lineJoin;float miterLimit;dword dashStyle; float dashOffset;"

Func _D2D1_CreateBitmapProperties($iFormat = 0, $iAlphaMode = 0, $fDpiX = 96, $fDpiY = 96)
	Local $oReturn = _AutoItObject_DllStructCreate($tagD2D1_BITMAP_PROPERTIES)

	$oReturn.format = $iFormat
	$oReturn.alphaMode = $iAlphaMode
	$oReturn.dpiX = $fDpiX
	$oReturn.dpiY = $fDpiY

	Return $oReturn
EndFunc

Func _D2D1_CreateArcSegment($fX, $fY, $fRadiusX, $fRadiusY, $fAngle = 45, $iSweepDir = $D2D1_SWEEP_DIRECTION_CLOCKWISE, $iSize = $D2D1_ARC_SIZE_SMALL)
	Local $oReturn = _AutoItObject_DllStructCreate($tagD2D1_ARC_SEGMENT)

	$oReturn.endX = $fX
	$oReturn.endY = $fY
	$oReturn.radiusX = $fRadiusX
	$oReturn.radiusY = $fRadiusY
	$oReturn.rotationAngle = $fAngle
	$oReturn.sweepDirection = $iSweepDir
	$oReturn.arcSize = $iSize

	Return $oReturn
EndFunc

Func _D2D1_CreateSizeF($fWidth, $fHeight)
	Local $oReturn = _AutoItObject_DllStructCreate($tagD2D1_SIZE_F)

	$oReturn.width = $fWidth
	$oReturn.height = $fHeight

	Return $oReturn
EndFunc

Func _D2D1_CreateSizeU($iWidth, $iHeight)
	Local $oReturn = _AutoItObject_DllStructCreate($tagD2D1_SIZE_U)

	$oReturn.width = $iWidth
	$oReturn.height = $iHeight

	Return $oReturn
EndFunc

Func _D2D1_CreateRectF($fX, $fY, $fWidth, $fHeight)
	Local $oReturn = _AutoItObject_DllStructCreate($tagD2D1_RECTF)

	$oReturn.left = $fX
	$oReturn.top = $fY
	$oReturn.right = $fX+$fWidth
	$oReturn.bottom = $fY+$fHeight

	Return $oReturn
EndFunc

Func _D2D1_CreateEllipse($fCenterX, $fCenterY, $fRadiusX, $fRadiusY)
	Local $oReturn = _AutoItObject_DllStructCreate($tagD2D1_ELLIPSE)

	$oReturn.centerX = $fCenterX
	$oReturn.centerY = $fCenterY
	$oReturn.radiusX = $fRadiusX
	$oReturn.radiusY = $fRadiusY

	Return $oReturn
EndFunc

Func _D2D1_CreateRoundedRect($fX, $fY, $fWidth, $fHeight, $fRadiusX, $fRadiusY)
	Local $oReturn = _AutoItObject_DllStructCreate($tagD2D1_ROUNDED_RECT)

	$oReturn.left = $fX
	$oReturn.top = $fY
	$oReturn.right = $fX+$fWidth
	$oReturn.bottom = $fY+$fHeight
	$oReturn.radiusX = $fRadiusX
	$oReturn.radiusY = $fRadiusY

	Return $oReturn
EndFunc

Func _D2D1_CreateStrokeProperties($iStartCap = $D2D1_CAP_STYLE_FLAT, $iEndCap = $D2D1_CAP_STYLE_FLAT, $iDashCap = $D2D1_CAP_STYLE_FLAT, $iLineJoin = $D2D1_LINE_JOIN_MITER, $fMiterLimit = 10, $iDashStyle = $D2D1_DASH_STYLE_SOLID, $fDashOffset = 0)
	Local $oReturn = _AutoItObject_DllStructCreate($tagD2D1_STROKE_PROPERTIES)

	$oReturn.startCap = $iStartCap
	$oReturn.endCap = $iEndCap
	$oReturn.dashCap = $iDashCap
	$oReturn.lineJoin = $iLineJoin
	$oReturn.miterLimit = $fMiterLimit
	$oReturn.dashStyle = $iDashStyle
	$oReturn.dashOffset = $fDashOffset

	Return $oReturn
EndFunc

Func _D2D1_CreateRenderTargetProperties($iType = 0, $iFormat = 0, $iAlphaMode = 0, $iDpiX = 0, $iDpiY = 0, $iUsage = 0, $iFeatureLevel = 0)
	Local $oReturn = _AutoItObject_DllStructCreate("dword type;dword format;dword alphaMode;float dpiX;float dpiY;dword usage;dword featureLevel;")

	$oReturn.type = $iType
	$oReturn.format = $iFormat
	$oReturn.alphaMode = $iAlphaMode
	$oReturn.dpiX = $iDpiX
	$oReturn.dpiY = $iDpiY
	$oReturn.usage = $iUsage
	$oReturn.featureLevel = $iFeatureLevel

	Return $oReturn
EndFunc

Func _D2D1_CreateHWNDRenderTargetProperties($hWnd, $iPixelSizeX, $iPixelSizeY, $iPresentOptions = 0)
	Local $oReturn = _AutoItObject_DllStructCreate("hwnd HWND;dword pixelSizeX;dword pixelSizeY;dword presentOptions")
	$oReturn.HWND = Number($hWnd)
	$oReturn.pixelSizeX = $iPixelSizeX
	$oReturn.pixelSizeY = $iPixelSizeY
	$oReturn.presentOptions = $iPresentOptions

	Return $oReturn
EndFunc

Func _D2D1_CreateLinearGradientBrushProperties($fStartX, $fStartY, $fEndX, $fEndY)
	Local $oReturn = _AutoItObject_DllStructCreate("float startpointX;float startpointY;float endpointX;float endpointY;")

	$oReturn.startpointX = $fStartX
	$oReturn.startpointY = $fStartY
	$oReturn.endpointX = $fEndX
	$oReturn.endpointY = $fEndY

	Return $oReturn
EndFunc
