; ------------------------------------------------------------------
; The Embedded Flat Assembler 1.69 UDF (2011.6.4)
; Purpose: Provide the ability to write assembly language in AutoIt
; Author:  Ward
; Flat Assembler Copyright (C) 2004-2010 Tomasz Grysztar
; ------------------------------------------------------------------

#cs
; Functions List:
;  FasmAdd			(ByRef $FasmObj, $Text)
;  FasmCompile		(ByRef $FasmObj)
;  FasmExit			(ByRef $FasmObj)
;  FasmGetBasePtr	(ByRef $FasmObj)
;  FasmGetBinary	(ByRef $FasmObj)
;  FasmGetFuncPtr	(ByRef $FasmObj)
;  FasmGetLastError	()
;  FasmGetSource	(ByRef $FasmObj)
;  FasmGetVersion	()
;  FasmInit			($MaxStructSize = 65536, $PassesLimit = 100)
;  FasmReset		(ByRef $FasmObj)
;  FasmSetSource	(ByRef $FasmObj, $Text)
;  FasmShutdown		()
;  FasmStartup		()
#ce

#Include-once
#Include <MemoryDll.au3>

Global $_FasmDll = 0, $_FasmLastError = 0

Global Const $FASM_OK 					= 0
Global Const $FASM_WORKING				= 1
Global Const $FASM_ERROR				= 2
Global Const $FASM_INVALID_PARAMETER	= -1
Global Const $FASM_OUT_OF_MEMORY		= -2
Global Const $FASM_STACK_OVERFLOW		= -3
Global Const $FASM_SOURCE_NOT_FOUND			= -4
Global Const $FASM_UNEXPECTED_END_OF_SOURCE	= -5
Global Const $FASM_CANNOT_GENERATE_CODE		= -6
Global Const $FASM_FORMAT_LIMITATIONS_EXCEDDED	= -7
Global Const $FASM_WRITE_FAILED					= -8

Global Const $FASMERR_FILE_NOT_FOUND				= -101
Global Const $FASMERR_ERROR_READING_FILE			= -102
Global Const $FASMERR_INVALID_FILE_FORMAT			= -103
Global Const $FASMERR_INVALID_MACRO_ARGUMENTS		= -104
Global Const $FASMERR_INCOMPLETE_MACRO				= -105
Global Const $FASMERR_UNEXPECTED_CHARACTERS			= -106
Global Const $FASMERR_INVALID_ARGUMENT				= -107
Global Const $FASMERR_ILLEGAL_INSTRUCTION			= -108
Global Const $FASMERR_INVALID_OPERAND 				= -109
Global Const $FASMERR_INVALID_OPERAND_SIZE			= -110
Global Const $FASMERR_OPERAND_SIZE_NOT_SPECIFIED	= -111
Global Const $FASMERR_OPERAND_SIZES_DO_NOT_MATCH	= -112
Global Const $FASMERR_INVALID_ADDRESS_SIZE			= -113
Global Const $FASMERR_ADDRESS_SIZES_DO_NOT_AGREE	= -114
Global Const $FASMERR_PREFIX_CONFLICT 				= -115
Global Const $FASMERR_LONG_IMMEDIATE_NOT_ENCODABLE	= -116
Global Const $FASMERR_RELATIVE_JUMP_OUT_OF_RANGE	= -117
Global Const $FASMERR_INVALID_EXPRESSION			= -118
Global Const $FASMERR_INVALID_ADDRESS 				= -119
Global Const $FASMERR_INVALID_VALUE					= -120
Global Const $FASMERR_VALUE_OUT_OF_RANGE			= -121
Global Const $FASMERR_UNDEFINED_SYMBOL				= -122
Global Const $FASMERR_INVALID_USE_OF_SYMBOL			= -123
Global Const $FASMERR_NAME_TOO_LONG					= -124
Global Const $FASMERR_INVALID_NAME					= -125
Global Const $FASMERR_RESERVED_WORD_USED_AS_SYMBOL	= -126
Global Const $FASMERR_SYMBOL_ALREADY_DEFINED		= -127
Global Const $FASMERR_MISSING_END_QUOTE				= -128
Global Const $FASMERR_MISSING_END_DIRECTIVE			= -129
Global Const $FASMERR_UNEXPECTED_INSTRUCTION		= -130
Global Const $FASMERR_EXTRA_CHARACTERS_ON_LINE		= -131
Global Const $FASMERR_SECTION_NOT_ALIGNED_ENOUGH	= -132
Global Const $FASMERR_SETTING_ALREADY_SPECIFIED		= -133
Global Const $FASMERR_DATA_ALREADY_DEFINED			= -134
Global Const $FASMERR_TOO_MANY_REPEATS				= -135

Global Const $_foSTRUCT		= 0
Global Const $_foSOURCE		= 1
Global Const $_foCOMPILED	= 2
Global Const $_foSTATE		= 3
Global Const $_foPASSLMT	= 4

Global Const $FASMERRINDEX_CODE			= 0
Global Const $FASMERRINDEX_MESSAGE		= 1
Global Const $FASMERRINDEX_LINENUMBER	= 2
Global Const $FASMERRINDEX_LINE			= 3

Func FasmStartup()
	If $_FasmDll = 0 Then
		If @AutoItX64 Then Exit MsgBox(16, "Flat Assembler Failed", "AutoIt x64 version is not supported !")

		; The binary for fasm.dll v1.69, source from http://board.flatassembler.net/topic.php?t=6239, by Tomasz Grysztar
		Local $Code = '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= 'XB3juVm4SQMRC8O8bLCwLpgQAFB2WMGktkY4O+Q2OL4AholL4RFO7AA3V0a4e19zCHRbASSEnXdA0AohJyCdigC5HsxR6Q+nNvZwAEILBVa8l5aoAMHmhO1mO3V6B+Idcfb78A0XWFoDi4UqqNjv6rZAlQQHfLk9/PefCEKATLvYV5nwAIc0bQxWa148YGSqiDBgMQB0O4CDECTFmgWtHA5Mr8Phdsjd1i4DAVYEC0LzoKXcVwE+E0eBfJQ6MPqYAA0fs0U8EjfjABG7wZqFWydfSr0AFQTclxBuAE51Eh5mDmJ2Hms3+IHrJLosBuDl4gArCGexbWsY47hvAPCBY5I5gw9OAAq8kSJ0p0WGKA4N4ADRQjyNCpItbD7r3QCMkxN5QDmFADLic4NxdFmBB+NNxpyTwKZpywpyBgDr7VNecjKa5RzgPt7d0kCE8Z1A67IAl60fK+QY3QQAkZsOD+IlJzlQyabeOeHTJEFODKiRRAJ8WAByjsf1/A48B1w4ywCwXpM7uAHi4KsEBYC8EMqAzsOD4QdeyOfkdmNac8tj2PMVugBLVwuKl4DPtXONAG2oBH3H/nUUCVWIGBAArZR+eOEH2G8GuWywQC8nJFz++QCfkhRzPqLuAHfWR5osxy56AAEKpwSoebI8Hvs9ZJyqAKzNFuXJ8vSaATsCxNcXq2f4yFryIwDVFfQWJVCD5h5dBo6AdAm5yoXAALEq4RKJ/6FtC/lR5ekALwIELAc6z/IAzfcDPe98530mwBnfftc+2DDkVhQ82ikAQb0DZ3u27xsAR1sXKl0Hp5b6eef8mX0DkSOJuYdm2GCBTgCXUMR08MBTax7lyhhALbCZ+mFcAEp8cxkzI/3oBVWJfkU+gMwtqZ7m/HfsAJ+7qwc8hT1n7K0BXBesgMiMt7qtgQeEgW4Qgtl2MJcxALM0iU826noGACfk6P5zEE0JAV9/JD3w8ZTc00QA4rAoqq3eggUA/0M6dbdc62YAEIS0Ycd4VlIABqV/MEhbg/gAD7t1shKxyAIHeXSAISPR7K4tYFrfACXOZiynQEZWBQFBIkKwg7UfudxM1PRfAHILPKkHY6frAM251dhLFLACCapPq4qA3uqA0GAHW9thX1r1gYN9sPgJM3oA8UBmq/YxVbEAKG0Fe+BpRfMeeSpQQJ0LiH7wfTxOjHo/zA2AXF4i5S5LFgczV8d6wKAoWBCacMsAdmrVA5sVF2sAmInyD7fDrn45mYUAzJrrpkEIIg6foX02APaRKc8YAJ7U0eEmFsiDHVgcuwHZIrcKTdxzdQBGILS/BcaNXHUGAFNRY7Nmu1Ur6K8HOd5kTCDgwNqJxwBlkI8SeBlsvgC3KHUqIW7NXQByvNuwC1rwewCqbFmMsRVUMABpPh3YCNtGhiyiUN4FYCkWg6cOmIddDHv2BCWsMZ+wgK9bG8QTF1xtAAV1NFY+jQNN1XDHXgH3P6MngrmwU7/1HEKMVwAxchE8pg0AiOCA5A8LW/x38OZgHHUD6oMBBe8x6DZPkwDnnvoEcNJOVPi2AH/3OLfrBrD/uMLofQExKhhGZztq9Lw9OHXygB+79nS9fA2VAHo+LBTdAPPr2MDXCLwEePEA02lUnfvbERs8g7kfdgiAhz4XgNmbABmUMyl11hziALKD/VFIvjZ0BAsy7MZGwQkdLugiLQD3EMLBp96A4w8IS4mY78Ng2PIbx0DwBT24D74hgIUNsfF3PyIXVfDoAAIFfGABmQ4P4xJvwK/elcs5AOl1lItH6+RLASx0AYldgMPcKv8B7cG7AgmKB++Y/tw/AAFy6HcFOkdAHgNwhd52AGS3WcC/JQHrRopHAsNWcPSAPPn3dg//C3dOL+kEckmAsxyN0vCBAMMF+7t6tg0UAATbL4nQ0eiNAH0S8a3Ffq/H8jwAA4g3fHcgchoHIm31FgHnGJ6APZ0QbLUA0Me87vdeW2sAlNoX0epxlXAAB4N5PrCF0nx6uT4Ed4drKzz5I2+mBAWoo5zPgE0DEHcORD83aEMkJ83uDABqJQOyW8F9FgByEIwK'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '39n0gGT8Cs923QBeQqL9hzkIVQDYgRzJr5M9DDpN+AFIsw6ABHL8tjjy9Q9G412xZkCmSAC3ShDHWYwF3Q44e6Fw4Ng3thgCAwgcKceHEsA7HjgAJjAWxI/5wVgAgfbG7wS0Ak0AWkvpN1R8+7roBgBiNFKJxsHuVgDADqqDvkZmfwApormNnk4dBQDLb0diWYR1NPYpOQRGgCuwLbnwHrhyAQHW+DAGDZpa0A4YOcfxewA7WKd2kkYkCQBA8Dij0i5WqAD7IWLpIE24hQC5QAGUt1cCGnfGLHEHQwp0bdwBAwoQZIlwazwA6Cu3vxhAjXrmvgUxkn0+pMDI/47PJZObfMB5BCvivw7f/v8yvj7DJQJ8woIDdLP/V8XGj5DWoYBnArZgDnX+1QCC9nt+x5uBPvrGAInowhdEHHpOAAa2hFhie4PhAfwFCYyPHHPFVNOTkeDOukAATb0J8IdWGN4DL36NdyXuv6BADmApB/LBFCAIQeL228iyBHIjUEnbBwBWAoXSdR2rtxzf/bo9gAHRKsF0HnIAIVEa6QNBH6IAkydfbAXnkFkD4IKXrGRY2NAK7RfNvAYPdkqBjQgv3PRLegD4ow88XoH+uQAQK6soWMDQbQDZGhQT1Uf4QwAF6PGQyI2BCACdobBAcwxHogCDal0LzfZtJAASKch2BxUECgCzBlt42DZGCB0MuKVA/0gF9rkbwFjoDgcDFgAiKrRS1EbfIwC5mtluh8M8OQDHwCaxUAtZiQeMxabO/gAKm3AsF0wBCAB2LWMl2wdYMIEBNNhlQQ0YQLcdMQwA8gM4ZIa0MAXsvh0lasvMhKpOgH13OxpZHhthXKxYqLK2RgHA14BdgYP07A74flMA69HWCGAbSgF4qvTBAA9QgzzLCQKxAAvdbZlrgcOFAFHUjx+R/aHLACAH0pAu4D9mAKOIFbjrxbIKAXIH3y83t8jQImMA/wkckFKAfnV/NQ+oC6UQZAoywGVXsfEPP4snZiB0QgPztgEVNEP6V4/uyIzUAAaHuGYp0UgLesH8KwC8t4D7ZFWBJefAudUAFsBDk+F1GNEAsKm120AXPNge62taBwHwCpGNp5TEqhgexFkGwCdVr7sT4AAOj+aHCFJXAwCmPeIyoiB9DD+hYoAo9UQ06l8LA8cm65HfOMBa1mZMR8UAsYOHxROsOgC0jsiJ8pcIPgDKCuggBBQ7RQBsgVgW0CtmlgHULgISVJIay6he08kAF4nFnfjY+oIAscDSh8EIzUcwdpnQQFBFfmYALD45EN1eq9wAAz0CWxRAQkh3tgDXjB0uXJOruAK7y7W9gw3gXmkaAwFF6bFvt7Ml4RTgyBYP/AsBP8quWbY0U8hhZT8DagDyptsoMS4kOPAvBwsC0kzgDTAsOABpcl3Ev+qChABFvEo8a8Ac/j7f3YMoCdsFu6gUAes5S9O5Q57jKQKJ2RCsQE8iAwGN2AK/fYcM4JwgAFlUi0o4SayxAB0E+PfRIcjrTHIYDii9f+CM9BxJWgAUjVwaGIlrvwAF6rYXA/JsYQKGdO17FFVBmEf4DCQAYOAxyQPWTLM4CdGBBP8Rt8/izCvCOIPZALMC3CDrDxAAMBteVnTySjT/cEw7ANuI5CH4KJKjAMUNw4ALAQRf5pgPDnkG+x8BShcgDQkgXOQPxgh9FkBI6KSZvQDg//EfBY1LKAADUlQrLyA50T52F4Ba2IO80CxjC5rfuQIAHsHDcNodb0SMyVZoUCp8IDoFYAC6hzfcETFBP1dRgLcJVjXlj0QLgMkFFgDEbBBcu+Bk9isARfkLhjA2GScd+IQQgOGzyf8uF+DrACUhDkKwKWEmcgf08QADxUCs6hl0SwAaroBI5foUXQftf8CHDiBMwnjHdEQAfMhsEp8B+vX+jP6IP+yEgHATCevPiq4/yViDcZ68Wlvg5LZlABdU1DeLCwcv9PYAV22IwQTT4IUA+i0rIcR4awkPCOuEi0kEgHeChQIUDyYFcpNEVQfA7FYcmw8EDfEPIHo4oHIlAMZvFB4ZqP0rA2tI5EmNRACg'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= 'paDgcOnFAH35RnYNRVuvANrm02oJ/zYKHoVQeACqWMNsLuEALTkPO0BxYzAASyDsGeuzXigPnZyM2N5Fkw67q4ZT9g/TxxIIoM8KdA/MAI0Erv0hFI8JADmd/A65gVo6ctcczwQlA94HiPCQ/BPtALuOKs2WixGAOecHneYCgNk+2/8GDj6u/oAIpWA3WdOSABoP2FQU6xmeDk3Cpz3gEjw+ahsA8egvos2UMLwBNrCkrbnBx9xogBL7AVr6AB4KI8tmllwCJRwEY8lZpXAm89OwOUikAD4hOvzR3ESJAB33AXkJp70lACOXOTXY3Mnu7OYAB9Am4cPOtrwABEZ0GIYS08kDLpAHyIo55yesgLFl7HIA6uiOdx95Rgb+dg5uJ0cCwJDlh1sSOeQagXL8ONYmJ3CSFgeLkXl0qsBCnB1kOwH5vSyBHg/kMneF1z4IzoC5yTYnxlpYHm63DkEL4wG+HOQ4IFyXDC4HjwwGiBQPHhAON09SIYkBACFdptjR+E24lhvkySgwkw2hR/LAOcQ5N64T2FkAj3ARGWsIBxBiSMRmhyLwsGwLMgB2FnBJbvMlPAAmO4cdM0AqtAkcSp7xgd03emvMTiAeA3ZYQrQP+TbgUS4QACdu7ZJyqTwHPxmQ8HP4OyMcg8vzQ4Pl45z3UBhygIYA5yA8CPWw16vygRzOBJ4Bv6DhJAfMiCUARRNWYYoj3AMCIdnsFTZ2wJv6EfYLABjq8zWCU1kQBs1bdaTYmgDCUW0BMIkGsgAbiIw1OSTsvh5lHQpSfAD0KhB65iEu31kNB4RKDDBYRrsPAHIFwCU5ZdEJDic1VRNm80K4Aasg9DRGHTLk3OjumAcqgJlT1ODp2LDLB86XB+ugwEJLYG4Dstl/FjlV8A0h1X6zOy6IAy9kTzQ+kAwKJR43VjBABTywR0IaDvgzRepgsnOVQGoOcTRwZQDntdrIKwCagIGgihhnJABYQu6QLsf9JgOMMzvJDkTKFIOASEfYtAGGoMxJOHg5exIAHe7YjNplEPAd8YomUgEHVNt0twRQ2cIxqwKubKpkH95AXz6TAhcg3DIFO8CKkk4AqVfYSQjFViY9bE2A5Pug3I9DggCGVfl9CIVCUgOxswHaGSXIe5opACpmIGIrJztLA3DclRQVbpnvdvB0ZXNqC2C7PfYAZUCO8G0AYTUYAfr9MWUA7jvs7w0VeuHoWADJhHyG7TDMvgAfrGAtb/Q5gPTALbA69uQA2WK9iTHzAHVAyItUJXF5LAG7nQ+y2uCfG0Cq3gBWhi9pH29mYXkhLC1tPAc9gFwgPAvZbAc0CdDdVpBXD4KtAIpUT3QFOSECAMUXQ4zbLztYAQm6cwxTwLwglbQAJQsjZTDk2Yx8IRYUuVEWlAD4AtvfyiYDsk3JJHK7yPIYkgAOWZ7GLxUJIAANbGZUSEEMggDxJD3eifIOCejWAPMDOcYQHotxAy94zB3IY7BVDTEAZrje+0Nuw1YBCtrputkB69wFEA5M9n/fHkAEst2IxokA82waGcC/u/EfhBY+Ht5C5gOAzuBNS7YA3SxeFQjGF8BMeFQAUu6bR6frNwAMSz5shF/sCnu4OuFIdwGyDyAEON0wboCEdZUuAIzqQHATnBFmADQoMiUvYdllAGAuAgbBHgs5ALCbqm16JV8jLBY1uQCDNgEIYJAA1EDYQbH1Ld0/3+AP/59sYOHbttrrdAbt0QLg34j8kwC8pML8wS3EAegaHN1tCwTUmzGAMdZ11wChH0YuknaFVAKzKcRlLEXg0BhtAPtyfOKSk+xMDi0SZTqOQKCzgTRJUgA9QrZbCfAsSgM6v0FTrwfTPOh0nWYAG5uEvPYn/k0DKd0iIBIooMDr6gDHLkUVBHBvgPQMB9Dj1TlUYGvaEEECDmS3ciwq4Z903BYu9hcACViGe/JbCCgAECYPpDYDNC4ALB4Jih0B3C8AxXRN7P0WEQ8ANVIwyYYNPTxM1x4Ocv8rgMr6DnOnAIpYiB0TDe+AAFpQLLC27PLAASkWsfktz4/QzIUADaxSp0yV4QUA'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= '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'
		$Code &= 'HG4bZ504EGw2ZbUccGZkb0l0NAy2NAk5qQhFuAlmVQ8wjjBnRAlzBWNNSHChmwxvhUwCnDNmQWEzJSANc2cFUG0FYko0ciCzDCczkUwhZ2ZFMEN1yoR5SrMkaHB1pRRsnKnKCTKQswQxgi2vChsJMihUWW2mbHodZUdpeVkMaGGVGS50ZVAIPLxWpoxTc7TMMVE2q+42DDOtAlQ0MFDZTURkwXVS6HS+No80FjoZbWlPXbRUXjTeZHQQDqZ4kUiSQUyCTXFE4EzhypuA1IysVqaypZLMAiSRzplUPWGSLXN0YimKjgIJBBGx1BIwVbzSCDu4M+Ax7iIJ/iAOE0UcAAFLRVJzTgdMMzIuRFqVvI9vYWSjaWJytyV5HK8nQRtQ7G9j9GTj/9NzQP6qafx0G3VhbCm5ZWPquRBBy55Kjg5uRlg1fLFyEwSIlAOmBGZUIWAJRGwIsilkIwkOTHshicoJmzChoAJGQVNNmJpmYR9zbV9ohXZlOmJsVg6FRmlkEkuwVn6eCWlvER/wkYQMFm0/LvzmAA=='

		$_FasmDll = MemoryDllOpen(_FasmCodeDecompress($Code))
		If Not $_FasmDll Then _FasmFailed()

		OnAutoItExitRegister("FasmShutdown")
	EndIf
EndFunc

Func FasmShutdown()
	If $_FasmDll Then
		MemoryDllClose($_FasmDll)
		$_FasmDll = 0
	EndIf
EndFunc

Func _FasmCodeDecompress($Code)
	Local $Opcode = '0x89C0608B7424248B7C2428FCB28031DBA4B302E86D00000073F631C9E864000000731C31C0E85B0000007323B30241B010E84F00000010C073F7753FAAEBD4E84D00000029D97510E842000000EB28ACD1E8744D11C9EB1C9148C1E008ACE82C0000003D007D0000730A80FC05730683F87F770241419589E8B3015689FE29C6F3A45EEB8E00D275058A164610D2C331C941E8EEFFFFFF11C9E8E7FFFFFF72F2C32B7C2428897C241C61C389D28B442404C70000000000C6400400C2100089F65557565383EC1C8B6C243C8B5424388B5C24308B7424340FB6450488028B550083FA010F84A1000000733F8B5424388D34338954240C39F30F848B0100000FB63B83C301E8CD0100008D57D580FA5077E50FBED20FB6041084C00FBED078D78B44240CC1E2028810EB6B83FA020F841201000031C083FA03740A83C41C5B5E5F5DC210008B4C24388D3433894C240C39F30F84CD0000000FB63B83C301E8740100008D57D580FA5077E50FBED20FB6041084C078DA8B54240C83E03F080283C2018954240CE96CFFFFFF8B4424388D34338944240C39F30F84D00000000FB63B83C301E82E0100008D57D580FA5077E50FBED20FB6141084D20FBEC278D78B4C240C89C283E230C1FA04C1E004081189CF83C70188410139F374750FB60383C3018844240CE8EC0000000FB654240C83EA2B80FA5077E00FBED20FB6141084D20FBEC278D289C283E23CC1FA02C1E006081739F38D57018954240C8847010F8533FFFFFFC74500030000008B4C240C0FB60188450489C82B44243883C41C5B5E5F5DC210008D34338B7C243839F3758BC74500020000000FB60788450489F82B44243883C41C5B5E5F5DC210008B54240CC74500010000000FB60288450489D02B442438E9B1FEFFFFC7450000000000EB9956578B7C240C8B7424108B4C241485C9742FFC83F9087227F7C7010000007402A449F7C702000000740566A583E90289CAC1E902F3A589D183E103F3A4EB02F3A45F5EC3E8500000003EFFFFFF3F3435363738393A3B3C3DFFFFFFFEFFFFFF000102030405060708090A0B0C0D0E0F10111213141516171819FFFFFFFFFFFF1A1B1C1D1E1F202122232425262728292A2B2C2D2E2F3031323358C3'
	Local $AP_Decompress = (StringInStr($Opcode, "89C0") - 3) / 2
	Local $B64D_DecodeData = (StringInStr($Opcode, "89F6") - 3) / 2
	$Opcode = Binary($Opcode)

	Local $CodeBufferMemory = _MemVirtualAlloc(0, BinaryLen($Opcode), $MEM_COMMIT, $PAGE_EXECUTE_READWRITE)
	Local $CodeBuffer = DllStructCreate("byte[" & BinaryLen($Opcode) & "]", $CodeBufferMemory)
	DllStructSetData($CodeBuffer, 1, $Opcode)
	Local $CodeBufferPtr = DllStructGetPtr($CodeBuffer)

	Local $B64D_State = DllStructCreate("byte[16]")
	Local $Length = StringLen($Code)
	Local $Output = DllStructCreate("byte[" & $Length & "]")

	DllCall("user32.dll", "int", "CallWindowProc", "ptr", $CodeBufferPtr + $B64D_DecodeData, _
													"str", $Code, _
													"uint", $Length, _
													"ptr", DllStructGetPtr($Output), _
													"ptr", DllStructGetPtr($B64D_State))

	Local $ResultLen = DllStructGetData(DllStructCreate("uint", DllStructGetPtr($Output)), 1)
	Local $Result = DllStructCreate("byte[" & ($ResultLen + 16) & "]")

	Local $Ret = DllCall("user32.dll", "uint", "CallWindowProc", "ptr", $CodeBufferPtr + $AP_Decompress, _
													"ptr", DllStructGetPtr($Output) + 4, _
													"ptr", DllStructGetPtr($Result), _
													"int", 0, _
													"int", 0)


	_MemVirtualFree($CodeBufferMemory, 0, $MEM_RELEASE)
	Return BinaryMid(DllStructGetData($Result, 1), 1, $Ret[0])
EndFunc

Func FasmInit($MaxStructSize = 65536, $PassesLimit = 100)
	FasmStartup()

	Local $FasmObj[5] = [DllStructCreate("int state;int length;ptr output;byte binary[" & $MaxStructSize & "]"), "" & @LF, False, 0, $PassesLimit]
	Return $FasmObj
EndFunc

Func FasmExit(ByRef $FasmObj)
	$FasmObj = 0
	$_FasmLastError = 0
EndFunc

Func FasmGetVersion()
	FasmStartup()

	Local $Ret = MemoryDllCall($_FasmDll, "uint", "fasm_GetVersion")
	If Not IsArray($Ret) Then _FasmFailed()
	Return BitAND($Ret[0], 0xffff) & "." & BitShift($Ret[0], 16)
EndFunc

Func _FasmCheck(ByRef $FasmObj)
	If IsArray($FasmObj) And UBound($FasmObj) = 5 And IsDllStruct($FasmObj[0]) Then
		Return True
	EndIf
	Return False
EndFunc

Func _FasmFailed()
	Exit MsgBox(16, "Flat Assembler Failed", "FASM.DLL or MemoryDll is not working !")
EndFunc

Func _FasmError()
	Local $Error = FasmGetLastError()
	If IsArray($Error) And UBound($Error) = 4 Then
		Local $ErrorCode = $Error[0], $ErrorMsg = $Error[1], $ErrorLineNumber = $Error[2], $ErrorLine = $Error[3]
		If $ErrorLine >= 0 Then $ErrorMsg &= @CRLF & "LINE NUMBER: " & $ErrorLineNumber & @CRLF & 'ERROR LINE: "' & $ErrorLine & '"'

		MsgBox(16, "Flat Assembler Error: " & $ErrorCode, $ErrorMsg)
	EndIf
	Exit
EndFunc

Func _FasmErrorCodeToMsg($Code)
	Local $Errors = "FASM_INVALID_PARAMETER,FASM_OUT_OF_MEMORY,FASM_STACK_OVERFLOW,FASM_SOURCE_NOT_FOUND,FASM_UNEXPECTED_END_OF_SOURCE,FASM_CANNOT_GENERATE_CODE,FASM_FORMAT_LIMITATIONS_EXCEDDED,FASM_WRITE_FAILED,FASMERR_FILE_NOT_FOUND,FASMERR_ERROR_READING_FILE,FASMERR_INVALID_FILE_FORMAT,FASMERR_INVALID_MACRO_ARGUMENTS,FASMERR_INCOMPLETE_MACRO,FASMERR_UNEXPECTED_CHARACTERS,FASMERR_INVALID_ARGUMENT,FASMERR_ILLEGAL_INSTRUCTION,FASMERR_INVALID_OPERAND,FASMERR_INVALID_OPERAND_SIZE,FASMERR_OPERAND_SIZE_NOT_SPECIFIED,FASMERR_OPERAND_SIZES_DO_NOT_MATCH,FASMERR_INVALID_ADDRESS_SIZE,FASMERR_ADDRESS_SIZES_DO_NOT_AGREE,FASMERR_PREFIX_CONFLICT,FASMERR_LONG_IMMEDIATE_NOT_ENCODABLE,FASMERR_RELATIVE_JUMP_OUT_OF_RANGE,FASMERR_INVALID_EXPRESSION,FASMERR_INVALID_ADDRESS,FASMERR_INVALID_VALUE,FASMERR_VALUE_OUT_OF_RANGE,FASMERR_UNDEFINED_SYMBOL,FASMERR_INVALID_USE_OF_SYMBOL,FASMERR_NAME_TOO_LONG,FASMERR_INVALID_NAME,FASMERR_RESERVED_WORD_USED_AS_SYMBOL,FASMERR_SYMBOL_ALREADY_DEFINED,FASMERR_MISSING_END_QUOTE,FASMERR_MISSING_END_DIRECTIVE,FASMERR_UNEXPECTED_INSTRUCTION,FASMERR_EXTRA_CHARACTERS_ON_LINE,FASMERR_SECTION_NOT_ALIGNED_ENOUGH,FASMERR_SETTING_ALREADY_SPECIFIED,FASMERR_DATA_ALREADY_DEFINED,FASMERR_TOO_MANY_REPEATS"
	$Errors = StringSplit($Errors, ",")

	For $i = 1 To $Errors[0]
		If $Code = Eval($Errors[$i]) Then
			Local $Msg = StringReplace($Errors[$i], "FASM_", "")
			$Msg = StringReplace($Msg, "FASMERR_", "")
			$Msg = StringReplace($Msg, "_", " ")
			Return $Msg
		EndIf
	Next
	Return ""
EndFunc

Func FasmGetLastError()
	If _FasmCheck($_FasmLastError) Then
		Local $ErrorCode, $ErrorMsg, $ErrorLineNumber = -1, $ErrorLine = ""

		$ErrorCode = $_FasmLastError[$_foSTATE]
		If $ErrorCode = $FASM_ERROR Then
			$ErrorCode = DllStructGetData($_FasmLastError[$_foSTRUCT], "length")
			Local $LineHeader = DllStructCreate("ptr;int;uint;uint", Ptr(DllStructGetData($_FasmLastError[$_foSTRUCT], "output")))

			If DllStructGetData($LineHeader, 2) < 0 Then
				Local $MacroLineHeader = DllStructCreate("ptr;int;uint;uint", Ptr(DllStructGetData($LineHeader, 4)))
				$LineHeader = $MacroLineHeader
			EndIf
			$ErrorLineNumber = DllStructGetData($LineHeader, 2)

			Local $Lines = StringSplit($_FasmLastError[$_foSOURCE], @LF)
			$ErrorLine = $Lines[$ErrorLineNumber]
		EndIf
		$ErrorMsg = _FasmErrorCodeToMsg($ErrorCode)

		Local $Error[4] = [$ErrorCode, $ErrorMsg, $ErrorLineNumber, $ErrorLine]
		Return $Error
	Else
		Local $Error[4] = [0, "", -1, ""]
		Return $Error
	EndIf
EndFunc

Func FasmCompile(ByRef $FasmObj)
	If Not _FasmCheck($FasmObj) Then Return SetError(1, $FASM_INVALID_PARAMETER, False)

	If $FasmObj[$_foCOMPILED] Then
		Return SetError($FasmObj[$_foSTATE] <> $FASM_OK, $FasmObj[$_foSTATE], $FasmObj[$_foSTATE] <> $FASM_OK)
	Else
		Local $StructPtr = DllStructGetPtr($FasmObj[$_foSTRUCT])
		Local $StructSize = DllStructGetSize($FasmObj[$_foSTRUCT])
		$FasmObj[$_foSOURCE] = StringStripWS($FasmObj[$_foSOURCE], 3)
		Local $Ret = MemoryDllCall($_FasmDll, "int", "fasm_Assemble", "str", $FasmObj[$_foSOURCE], "ptr", $StructPtr, "uint", $StructSize, "uint", $FasmObj[$_foPASSLMT], "uint", 0)
		If Not IsArray($Ret) Then _FasmFailed()

		$FasmObj[$_foCOMPILED] = TRUE
		$FasmObj[$_foSTATE] = $Ret[0]
		If $FasmObj[$_foSTATE] = $FASM_OK Then
			Local $CodePtr = DllStructGetData($FasmObj[$_foSTRUCT], "output")
			Local $CodeLen = DllStructGetData($FasmObj[$_foSTRUCT], "length")
			Local $Offset = Number($CodePtr - $StructPtr) - 12
			Local $Binary = BinaryMid(DllStructGetData($FasmObj[$_foSTRUCT], "binary"), $Offset + 1, $CodeLen)
			DllStructSetData($FasmObj[$_foSTRUCT], "binary", $Binary)
			Return SetError(0, $FasmObj[$_foSTATE], True)
		Else
			$_FasmLastError = $FasmObj
			Return SetError(1, $FasmObj[$_foSTATE], False)
		EndIf
	EndIf
EndFunc

Func FasmGetBinary(ByRef $FasmObj)
	If Not _FasmCheck($FasmObj) Then Return SetError(1, $FASM_INVALID_PARAMETER, Binary(""))

	If Not $FasmObj[$_foCOMPILED] Then FasmCompile($FasmObj)
	If $FasmObj[$_foSTATE] = $FASM_OK Then
		Local $CodeLen = DllStructGetData($FasmObj[$_foSTRUCT], "length")
		Return BinaryMid(DllStructGetData($FasmObj[$_foSTRUCT], "binary"), 1, $CodeLen)
	Else
		$_FasmLastError = $FasmObj
		Return SetError(1, $FasmObj[$_foSTATE], Binary(""))
	EndIf
EndFunc

Func FasmGetFuncPtr(ByRef $FasmObj)
	If Not _FasmCheck($FasmObj) Then Return SetError(1, $FASM_INVALID_PARAMETER, Ptr(0))

	If Not $FasmObj[$_foCOMPILED] Then FasmCompile($FasmObj)
	If $FasmObj[$_foSTATE] = $FASM_OK Then
		Return DllStructGetPtr($FasmObj[$_foSTRUCT], "binary")
	Else
		$_FasmLastError = $FasmObj
		Return DllCallbackGetPtr(DllCallbackRegister("_FasmError", "int:cdecl", ""))
	EndIf
EndFunc

Func FasmGetBasePtr(ByRef $FasmObj)
	If Not _FasmCheck($FasmObj) Then Return SetError(1, $FASM_INVALID_PARAMETER, Ptr(0))

	Return DllStructGetPtr($FasmObj[$_foSTRUCT], "binary")
EndFunc

Func FasmAdd(ByRef $FasmObj, $Text)
	If Not _FasmCheck($FasmObj) Then Return SetError(1, $FASM_INVALID_PARAMETER)

	If $Text Then
		$FasmObj[$_foSOURCE] &= $Text & @LF
		$FasmObj[$_foCOMPILED] = False
	EndIf
EndFunc

Func FasmGetSource(ByRef $FasmObj)
	If Not _FasmCheck($FasmObj) Then Return SetError(1, $FASM_INVALID_PARAMETER, "")

	Return $FasmObj[$_foSOURCE]
EndFunc

Func FasmSetSource(ByRef $FasmObj, $Text)
	If Not _FasmCheck($FasmObj) Then Return SetError(1, $FASM_INVALID_PARAMETER)

	$FasmObj[$_foSOURCE] = $Text
	$FasmObj[$_foCOMPILED] = False
EndFunc

Func FasmReset(ByRef $FasmObj)
	FasmSetSource($FasmObj, "")
EndFunc
