#include-once

Func _Tool_Eraser_Start($oSelf, $iX, $iY)
	$oSelf.lastX = $iX
	$oSelf.lastY = $iY
	$oSelf.gpx = _Util_GetCurrentGraphics()
	$oSelf.extra1 = 0
EndFunc

#cs
	REMARK #7: Wait, where's my Direct2D? [scintilla4evr]

	You may ask, vPaint is using Direct2D, so why there aren't
	many lines of code actually using Direct2D? The answer is simple.
	There is no functionality for now, where using Direct2D would
	boost up the performance.

#ce
Func _Tool_Eraser_Draw($oSelf, $iX, $iY)
	If $iEraserMode = 0 Then
		$hPen = _GDIPlus_PenCreate(0xFF000000, $iEraserWidth)
		_GDIPlus_PenSetLineCap($hPen, 2, 2, 2)

		$hPath = _GDIPlus_PathCreate()
		_GDIPlus_PathAddLine($hPath, $iX, $iY, $oSelf.lastX, $oSelf.lastY)
		_GDIPlus_PathWiden($hPath, $hPen)

		$hPath2 = _GDIPlus_PathCreate()
		_GDIPlus_PathAddRectangle($hPath, -10, -10, $oCurrentThread.thread.width+20, $oCurrentThread.thread.height+20)
		_GDIPlus_PathAddPath($hPath2, $hPath, False)

		$hTex = _GDIPlus_TextureCreate($oCurrentThread.thread.currentLayer.bmp)

		$hBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.width, $oCurrentThread.thread.height)
		$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
		_GDIPlus_GraphicsSetSmoothingMode($hGpx, 5)
		_GDIPlus_GraphicsSetPixelOffsetMode($hGpx, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)

		_GDIPlus_GraphicsFillPath($hGpx, $hPath2, $hTex)

		_GDIPlus_GraphicsDispose($hGpx)
		_GDIPlus_BitmapDispose($oCurrentThread.thread.currentLayer.bmp)
		$oCurrentThread.thread.currentLayer.bmp = $hBmp

		_GDIPlus_BrushDispose($hTex)

		_GDIPlus_PathDispose($hPath)
		_GDIPlus_PathDispose($hPath2)

		_GDIPlus_PenDispose($hPen)

		$oSelf.lastX = $iX
		$oSelf.lastY = $iY
	EndIf
EndFunc

Func _Tool_Eraser_End($oSelf, $iX, $iY)
	If $iEraserMode = 1 Then _Util_StartFloodFill($oCurrentThread.thread.currentLayer.bmp, Int($iX), Int($iY), 0)
	_GDIPlus_GraphicsDispose($oSelf.gpx)
EndFunc

Func _Tool_Eraser_DrawHUD($oSelf, $hGpx, $iX, $iY)
	If $iEraserMode = 0 Then
		$tPen = _GDIPlus_PenCreate(0xAAFFFFFF, 3)
		_GDIPlus_GraphicsDrawEllipse($hGpx, $iX-($iEraserWidth/2)*$oCurrentThread.zoom, $iY-($iEraserWidth/2)*$oCurrentThread.zoom, $iEraserWidth*$oCurrentThread.zoom, $iEraserWidth*$oCurrentThread.zoom, $tPen)
		_GDIPlus_PenDispose($tPen)

		$tPen = _GDIPlus_PenCreate(0xAA000000)
		_GDIPlus_GraphicsDrawEllipse($hGpx, $iX-($iEraserWidth/2)*$oCurrentThread.zoom, $iY-($iEraserWidth/2)*$oCurrentThread.zoom, $iEraserWidth*$oCurrentThread.zoom, $iEraserWidth*$oCurrentThread.zoom, $tPen)
		_GDIPlus_PenDispose($tPen)
	Else
		$tPen = _GDIPlus_PenCreate(0xAAFFFFFF, 3)
		_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
		_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
		_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
		_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)
		_GDIPlus_PenDispose($tPen)

		$tPen = _GDIPlus_PenCreate(0xAA000000)
		_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
		_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
		_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
		_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)
		_GDIPlus_PenDispose($tPen)
	EndIf
EndFunc

Func _Tool_Eraser_DrawD2DHUD($oSelf, $oRenderTarget, $iX, $iY)
	Local $hBrush1 = _D2D1_CreateSolidBrush($oRenderTarget, _D2D1_CreateColorF(0, 0, 0, 0.7))
	Local $hBrush2 = _D2D1_CreateSolidBrush($oRenderTarget, _D2D1_CreateColorF(1, 1, 1, 0.7))
	Local $tEllipse = _D2D1_CreateEllipse($iX, $iY, $iBrushWidth*$oCurrentThread.zoom/2, $iBrushWidth*$oCurrentThread.zoom/2)

	_D2D1_DrawEllipse($oRenderTarget, $tEllipse, $hBrush2, 3)
	_D2D1_DrawEllipse($oRenderTarget, $tEllipse, $hBrush1, 1)

	_AutoItObject_IUnknownRelease($hBrush1)
	_AutoItObject_IUnknownRelease($hBrush2)
EndFunc

Func _Tool_Eraser_ShowUI($oSelf)
	$hEraserUI = GUICreate("", 700, 40, 0, 30*$iUIScaleFactor, $WS_CHILD+$WS_VISIBLE, -1, $hMainUI)

	Global $cidEraserTool_EraserMode0 = _Tiles_CreateButton('D', 0, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetTip(-1, "Eraser brush")
	GUICtrlSetOnEvent(-1, "_Tool_Eraser_SetMode")

	Global $cidEraserTool_EraserMode1 = _Tiles_CreateButton('G', 40, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetTip(-1, "Magic eraser")
	GUICtrlSetOnEvent(-1, "_Tool_Eraser_SetMode")

	_Tiles_CreateButton('A', 100, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Eraser_ResetWidth")
	GUICtrlSetTip(-1, "Eraser width (click to reset)")

	Global $cidEraser_WidthSlider = GUICtrlCreateSlider(140, 5, 120, 40)
	GUICtrlSetData(-1, $iEraserWidth)
	GUICtrlSetBkColor(-1, 0xF0F0F0)
	GUICtrlSetTip(-1, $iEraserWidth)
	GUICtrlSetOnEvent(-1, "_Tool_Eraser_SetWidth")

	GUISwitch($hMainUI)

	Return $hEraserUI
EndFunc

Func _Tool_Eraser_SetMode()
	_Tiles_ButtonSetBkColor(Eval("cidEraserTool_EraserMode"&$iEraserMode), 0xFFF0F0F0, 0xFFE0E0E0)
	_Tiles_ButtonSetTextColor(Eval("cidEraserTool_EraserMode"&$iEraserMode), 0xFF111111)

	Switch @GUI_CtrlId
		Case $cidEraserTool_EraserMode0
			$iEraserMode = 0
		Case $cidEraserTool_EraserMode1
			$iEraserMode = 1
	EndSwitch

	_Tiles_ButtonSetBkColor(Eval("cidEraserTool_EraserMode"&$iEraserMode), 0xFFE0E0E0, 0xFFD0D0D0)
	_Tiles_ButtonSetTextColor(Eval("cidEraserTool_EraserMode"&$iEraserMode), 0xFF000000)
EndFunc

Func _Tool_Eraser_ResetWidth()
	$iEraserWidth = 16
	GUICtrlSetData($cidEraser_WidthSlider, $iEraserWidth)
	GUICtrlSetTip($cidEraser_WidthSlider, $iEraserWidth)
EndFunc

Func _Tool_Eraser_SetWidth()
	$iEraserWidth = GUICtrlRead(@GUI_CtrlId)
	GUICtrlSetData(@GUI_CtrlId, $iEraserWidth)
	GUICtrlSetTip(@GUI_CtrlId, $iEraserWidth)
EndFunc

Func _Tool_Eraser_CanBypassLock($oSelf, $iLockMode)
	Switch $iLockMode
		Case $V4_LL_NONE, $V4_LL_POS
			Return 1
		Case Else
			Return 0
	EndSwitch
EndFunc
