#include-once

Func _V4ISave($oThread, $sFile)
	Local $i = 0
	FileDelete($sFile)

	; create a .V4I zip file
	_Zip_Create($sFile&".zip")

	$sPrefix = _Util_GenerateRandomPrefix()
	$dir = @TempDir&"\"&$sPrefix
	DirCreate($dir)

	$hManifestXML = _AXml_LoadFile(@ScriptDir&"\Data\XML\v4i_base.xml")

	_AXml_XPathNode($hManifestXML, "/v4i")

	$oCurrentThread.thread.serialize($hManifestXML, $dir, $sFile&".zip")

	_AXml_SaveFile($hManifestXML, $dir&"\ImageManifest.xml")
	_Zip_AddFile($sFile&".zip", $dir&"\ImageManifest.xml")

	FileCopy($sFile&".zip", $sFile)
	FileDelete($sFile&".zip")
EndFunc

Func _V4IOpen($sFile)
	$dir = $TEMPORARYDIR&"\Extract\"&_Util_GenerateRandomPrefix()

	; unpack .V4I
	FileCopy($sFile, $sFile&".zip")
	DirCreate($dir)
	_Zip_UnzipAll($sFile&".zip", $dir)

	; create an empty thread
	$oThread = _CreateThread(1, 1)

	$hManifestXML = _AXml_LoadFile($dir&"\ImageManifest.xml")
	$oThread.deserialize($hManifestXML, $dir)

	; create ThreadManager
	$oThreadMgm = _CreateThreadManager($oThread)
	$oThreadMgm.name = _WinAPI_PathFindFileName($sFile)
	$oThreadMgm.file = $sFile
	$oThreadMgm.historyAdd()
	$oThreadMgm.type = $V4_TT_IMAGE

	; end the party
	_AddThread($oThreadMgm)
	_SelectThread($aThreads[0])

	$isOpen = 1

	FileDelete($sFile&".zip")
EndFunc
