#include-once

#include "API\Threads.au3"

Global $sCLSID_vPaintAPI = "vPaint4xAPI"

; register Generic
Global $o_vPaintAPI = _API_Create()
Global $iROT_vPaintAPI = _AutoItObject_RegisterObject($o_vPaintAPI, $sCLSID_vPaintAPI)

Func _API_Create()
	Local $oAPI = _AutoItObject_Create()

	Local $oVersion = _AutoItObject_Create()
	_AutoItObject_AddProperty($oVersion, "AppVersion", $ELSCOPE_PUBLIC, $APPVERSION)
	_AutoItObject_AddProperty($oVersion, "AppBranch", $ELSCOPE_PUBLIC, $APPBRANCH)
	_AutoItObject_AddProperty($oVersion, "AppVersionFullString", $ELSCOPE_PUBLIC, $APPVERSION_FULLSTRING)

	_AutoItObject_AddProperty($oAPI, "Version", $ELSCOPE_PUBLIC, $oVersion)

	Local $oThreads = _AutoItObject_Create()

	_API_Threads($oThreads)

	_AutoItObject_AddProperty($oAPI, "Threads", $ELSCOPE_PUBLIC, $oThreads)

	Return $oAPI
EndFunc

Func _API_Unregister()
	_AutoItObject_UnregisterObject($iROT_vPaintAPI)
EndFunc
