#include-once

Func _API_Threads($oObj)
	; Threads
	_AutoItObject_AddMethod($oObj, "CreateThread", "__API_Threads_CreateThread")
	_AutoItObject_AddMethod($oObj, "GetCurrentThread", "__API_Threads_GetCurrentThread")
	_AutoItObject_AddMethod($oObj, "GetThread", "__API_Threads_GetThread")
	_AutoItObject_AddMethod($oObj, "GetThreadCount", "__API_Threads_GetThreadCount")
EndFunc

Func __API_Threads_CreateThread($oSelf, $iWidth, $iHeight)
	Return __API_Threads_CreateThreadRaw(_CreateThread($iWidth, $iHeight))
EndFunc

Func __API_Threads_GetCurrentThread($oSelf)
	Return __API_Threads_CreateThreadRaw($oCurrentThread.thread)
EndFunc

Func __API_Threads_GetThread($oSelf, $iThread)
	Return __API_Threads_CreateThreadRaw($aThreads[$iThread])
EndFunc

Func __API_Threads_GetThreadCount($oSelf)
	Return $aThreads[0]
EndFunc

Func __API_Threads_CreateThreadRaw($oRawThread)
	Local $oThread = _AutoItObject_Create()

	_AutoItObject_AddProperty($oThread, "thread", $ELSCOPE_PUBLIC, $oRawThread)

	_AutoItObject_AddMethod($oThread, "GetRegion", "__API_Thread_GetRegion")
	_AutoItObject_AddMethod($oThread, "GetWidth", "__API_Thread_GetWidth")
	_AutoItObject_AddMethod($oThread, "GetHeight", "__API_Thread_GetHeight")

	_AutoItObject_AddMethod($oThread, "GetLayerCount", "__API_Thread_GetLayerCount")
	_AutoItObject_AddMethod($oThread, "GetLayer", "__API_Thread_GetLayer")
	_AutoItObject_AddMethod($oThread, "GetCurrentLayer", "__API_Thread_GetCurrentLayer")

	Return $oThread
EndFunc

Func __API_Thread_GetRegion($oSelf)
	Return _GDIPlus_RegionClone($oSelf.thread.selection)
EndFunc

Func __API_Thread_GetWidth($oSelf)
	Return $oSelf.thread.width
EndFunc

Func __API_Thread_GetHeight($oSelf)
	Return $oSelf.thread.height
EndFunc

Func __API_Thread_GetLayerCount($oSelf)
	Return $oSelf.thread.layers.count
EndFunc

Func __API_Thread_GetLayer($oSelf, $iLayer)
	Return __API_Threads_CreateLayerRaw($oSelf.thread.layers.at($iLayer))
EndFunc

Func __API_Thread_GetCurrentLayer($oSelf)
	Return __API_Threads_CreateLayerRaw($oSelf.thread.currentLayer)
EndFunc

Func __API_Threads_CreateLayerRaw($oRawLayer)
	Local $oLayer = _AutoItObject_Create()

	_AutoItObject_AddProperty($oLayer, "layer", $ELSCOPE_PUBLIC, $oRawLayer)

	_AutoItObject_AddMethod($oLayer, "GetName", "__API_Layer_GetName")
	_AutoItObject_AddMethod($oLayer, "GetWidth", "__API_Layer_GetWidth")
	_AutoItObject_AddMethod($oLayer, "GetHeight", "__API_Layer_GetHeight")
	_AutoItObject_AddMethod($oLayer, "GetVisibility", "__API_Layer_GetVisibility")

	_AutoItObject_AddMethod($oLayer, "LockBitmap", "__API_Layer_LockBitmap")
	_AutoItObject_AddMethod($oLayer, "LockBitmapArea", "__API_Layer_LockBitmapArea")
	_AutoItObject_AddMethod($oLayer, "UnlockBitmap", "__API_Layer_UnlockBitmap")

	Return $oLayer
EndFunc

Func __API_Layer_GetName($oSelf)
	Return $oSelf.layer.name
EndFunc

Func __API_Layer_GetWidth($oSelf)
	Return $oSelf.layer.width
EndFunc

Func __API_Layer_GetHeight($oSelf)
	Return $oSelf.layer.height
EndFunc

Func __API_Layer_GetVisibility($oSelf)
	Return $oSelf.layer.isVisible
EndFunc

Func __API_Layer_LockBitmap($oSelf)
	$tBitmapData = _GDIPlus_BitmapLockBits($oSelf.layer.bmp, 0, 0, $oSelf.layer.width, $oSelf.layer.height, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)

	Return Int(DllStructGetPtr($tBitmapData))
EndFunc

Func __API_Layer_LockBitmapArea($oSelf, $iX, $iY, $iW, $iH)
	$tBitmapData = _GDIPlus_BitmapLockBits($oSelf.layer.bmp, $iX, $iY, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)

	Return Int(DllStructGetPtr($tBitmapData))
EndFunc

Func __API_Layer_UnlockBitmap($oSelf, $pBitmapData)
	_GDIPlus_BitmapUnlockBits($oSelf.layer.bmp, DllStructCreate($tagGDIPBITMAPDATA, $pBitmapData))
EndFunc