#include-once

Global Enum $COMP_TYPE_INVERT = 0x200, _
			$COMP_TYPE_GRAYSCALE

#cs
	NODE DEFINITION
	INVERT
	Inverts the image colors.

	INPUTS:
	Image [GDI+ Bitmap]

	OUTPUTS:
	Image [GDI+ Bitmap]

#ce
Func _CompAdd_Invert($iX = 0, $iY = 0, $oTMgm = $oCurrentThread)
	Local $oNode = _Node_CreateNode("Invert", "_CompProc_Invert", $COMP_TYPE_INVERT, $iX, $iY)
	$oNode.input.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.output.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.calcSize()

	$oTMgm.compList.add($oNode)

	Return $oNode
EndFunc

Func _CompProc_Invert($oSelf, $iWantedOutput, $aInputs)
	$tCm = _GDIPlus_ColorMatrixCreateNegative()

	$hEffect = _GDIPlus_EffectCreateColorMatrix($tCm)
	_GDIPlus_BitmapApplyEffect($aInputs[0], $hEffect)
	_GDIPlus_EffectDispose($hEffect)

	Return $aInputs[0]
EndFunc

#cs
	NODE DEFINITION
	GRAYSCALE
	Turns the image into grayscale.

	INPUTS:
	Image [GDI+ Bitmap]

	OUTPUTS:
	Image [GDI+ Bitmap]

#ce
Func _CompAdd_Grayscale($iX = 0, $iY = 0, $oTMgm = $oCurrentThread)
	Local $oNode = _Node_CreateNode("Grayscale", "_CompProc_Grayscale", $COMP_TYPE_GRAYSCALE, $iX, $iY)
	$oNode.input.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.output.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.calcSize()

	$oTMgm.compList.add($oNode)

	Return $oNode
EndFunc

Func _CompProc_Grayscale($oSelf, $iWantedOutput, $aInputs)
	$tCm = _GDIPlus_ColorMatrixCreateGrayScale()

	$hEffect = _GDIPlus_EffectCreateColorMatrix($tCm)
	_GDIPlus_BitmapApplyEffect($aInputs[0], $hEffect)
	_GDIPlus_EffectDispose($hEffect)

	Return $aInputs[0]
EndFunc
