#include-once
#include "IO.au3"
#include "Color.au3"
#include "Effect.au3"
#include "Merge.au3"
#include "AfterEffects.au3"

#cs
	REMARK #10: The Compositor [scintilla4evr]

	Before 3.9.5 (Source Release #5), the center place of vPaint's
	workflow was the drawing area (now the Drawing mode). When
	creating Viewport Modes, I focused on the Compositor, not the
	Drawing mode.
	Compositor (or Compositing mode if you'd like) is a node-based
	workflow to edit the way image is processed before rendering.
	In vPaint, the Compositor also handles animations and calculations.

#ce
Func _CreateBasicComposition($oThreadMgm)
	$oIn = _CompAdd_FullInput(-250, -50, $oThreadMgm)
	$oOut = _CompAdd_Output(50, -20, $oThreadMgm)

	$oInput = $oOut.input.at(0)
	$oInput.node = $oIn
	$oInput.nodeOut = 0

	$oThreadMgm.compOutNode = $oOut
EndFunc

Func _RenderComposite()
	$oCurrentThread.compOutNode.exec(0)

	_ChangeViewportRender(1)
	_SetViewMode(0)
EndFunc

Func _AddNodeToComposition()
	$sName = StringReplace(StringReplace(GUICtrlRead(@GUI_CtrlId, 1), " ", ""), "-", "")

	$oNode = Call("_CompAdd_"&$sName)

	_RefreshCompositing()
EndFunc
