#include-once

Global Enum $COMP_TYPE_FULLINPUT = 0x100, _
			$COMP_TYPE_SINGLELAYERINPUT, _
			$COMP_TYPE_OUTPUT, _
			$COMP_TYPE_DE4KIZE

#cs
	NODE DEFINITION
	FULL INPUT
	Retrieves the image displayed in the drawing area.

	INPUTS:
	<none>

	OUTPUTS:
	Image [GDI+ Bitmap]

#ce
Func _CompAdd_FullInput($iX = 0, $iY = 0, $oTMgm = $oCurrentThread)
	Local $oNode = _Node_CreateNode("Full Input", "_CompProc_FullInput", $COMP_TYPE_FULLINPUT, $iX, $iY)
	$oNode.output.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.calcSize()

	$oTMgm.compList.add($oNode)

	Return $oNode
EndFunc

Func _CompProc_FullInput($oSelf, $iWantedOutput, $aInputs)
	Return $oCurrentThread.thread.render(0, 1)
EndFunc

#cs
	NODE DEFINITION
	OUTPUT
	Sends the composition back to vPaint for rendering.

	INPUTS:
	Image [GDI+ Bitmap]

	OUTPUTS:
	<None>

#ce
Func _CompAdd_Output($iX = 0, $iY = 0, $oTMgm = $oCurrentThread)
	Local $oNode = _Node_CreateNode("Output", "_CompProc_Output", $COMP_TYPE_OUTPUT, $iX, $iY)
	$oNode.input.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.lockDelete = 1
	$oNode.calcSize()

	$oTMgm.compList.add($oNode)

	Return $oNode
EndFunc

Func _CompProc_Output($oSelf, $iWantedOutput, $aInputs)
	If $aInputs[0] = Null Then Return 0
	If $oCurrentThread.compBmp <> 0 Then _GDIPlus_BitmapDispose($oCurrentThread.compBmp)
	$oCurrentThread.compBmp = $aInputs[0]
EndFunc

#cs
	NODE DEFINITION
	DE-4K-IZE
	Downgrades the image if composition quality is set to Draft.

	INPUTS:
	Image [GDI+ Bitmap]

	OUTPUTS:
	Image [GDI+ Bitmap]

#ce
Func _CompAdd_De4KIze($iX = 0, $iY = 0, $oTMgm = $oCurrentThread)
	Local $oNode = _Node_CreateNode("De-4K-ize", "_CompProc_De4KIze", $COMP_TYPE_FULLINPUT, $iX, $iY)
	$oNode.input.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.output.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.calcSize()

	$oTMgm.compList.add($oNode)

	Return $oNode
EndFunc

Func _CompProc_De4KIze($oSelf, $iWantedOutput, $aInputs)
	If $oCurrentThread.compQuality = $V4_CQ_DRAFT Then
		$tBmp = _GDIPlus_ImageResize($aInputs[0], _GDIPlus_ImageGetWidth($aInputs[0])/4, _GDIPlus_ImageGetHeight($aInputs[0])/4)
		_GDIPlus_BitmapDispose($aInputs[0])
		$aInputs[0] = $tBmp
	EndIf

	Return $aInputs[0]
EndFunc
