#include-once

Func _Tool_Eyedropper_Start($oSelf, $iX, $iY)
EndFunc

Func _Tool_Eyedropper_Draw($oSelf, $iX, $iY)
	$color = _GDIPlus_BitmapGetPixel($oCurrentThread.thread.currentLayer.bmp, $iX, $iY)

	If _IsPressed("12") Then
		$iBackground = _SetAlpha($color, 255)
		GUICtrlSetBkColor($cidBackground, _SetAlpha($color, 0))
	Else
		$iForeground = _SetAlpha($color, 255)
		GUICtrlSetBkColor($cidForeground, _SetAlpha($color, 0))
	EndIf
EndFunc

Func _Tool_Eyedropper_End($oSelf, $iX, $iY)
EndFunc

Func _Tool_Eyedropper_DrawHUD($oSelf, $hGpx, $iX, $iY)
	$tPath = _GDIPlus_PathCreate()
	_GDIPlus_PathAddEllipse($tPath, $iX-100, $iY-100, 200, 200)
	_GDIPlus_PathAddEllipse($tPath, $iX-70, $iY-70, 140, 140)

	$tPen = _GDIPlus_PenCreate(0xAAFFFFFF, 3)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)

	_GDIPlus_GraphicsDrawPath($hGpx, $tPath, $tPen)
	_GDIPlus_PenDispose($tPen)

	$tPen = _GDIPlus_PenCreate(0xAA000000)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)
	_GDIPlus_PenDispose($tPen)

	$iX2 = $iX
	$iY2 = $iY
	_Util_ConvertClientToBitmap($iX2, $iY2)

	$color = _GDIPlus_BitmapGetPixel($oCurrentThread.thread.currentLayer.bmp, $iX2, $iY2)

	_GDIPlus_GraphicsFillPath($hGpx, $tPath, $hTransparency)

	_GDIPlus_PathReset($tPath)
	_GDIPlus_PathAddPie($tPath, $iX-100, $iY-100, 200, 200, -90, 120)
	_GDIPlus_PathAddPie($tPath, $iX-70, $iY-70, 140, 140, -90, 120)

	$tBrush = _GDIPlus_BrushCreateSolid($color)
	_GDIPlus_GraphicsFillPath($hGpx, $tPath, $tBrush)
	_GDIPlus_BrushDispose($tBrush)

	_GDIPlus_PathReset($tPath)
	_GDIPlus_PathAddPie($tPath, $iX-100, $iY-100, 200, 200, -90, -120)
	_GDIPlus_PathAddPie($tPath, $iX-70, $iY-70, 140, 140, -90, -120)

	$tBrush = _GDIPlus_BrushCreateSolid(_SetAlpha($color, 255))
	_GDIPlus_GraphicsFillPath($hGpx, $tPath, $tBrush)
	_GDIPlus_BrushDispose($tBrush)

	_GDIPlus_PathReset($tPath)
	_GDIPlus_PathAddPie($tPath, $iX-100, $iY-100, 200, 200, 30, 120)
	_GDIPlus_PathAddPie($tPath, $iX-70, $iY-70, 140, 140, 30, 120)

	$tBrush = _GDIPlus_BrushCreateSolid(_IsPressed("12") ? $iBackground : $iForeground)
	_GDIPlus_GraphicsFillPath($hGpx, $tPath, $tBrush)
	_GDIPlus_BrushDispose($tBrush)

	_GDIPlus_PathDispose($tPath)
EndFunc

Func _Tool_Eyedropper_DrawD2DHUD($oSelf, $oRenderTarget, $iX, $iY)
	$iX2 = $iX
	$iY2 = $iY
	_Util_ConvertClientToBitmap($iX2, $iY2)

	Local $color = _D2D1_CreateColorFFromARGB(_GDIPlus_BitmapGetPixel($oCurrentThread.thread.currentLayer.bmp, $iX2, $iY2))
	$color.a = 1

	Local $hBrush1 = _D2D1_CreateSolidBrush($oRenderTarget, $color)
	Local $hBrush2 = _D2D1_CreateSolidBrush($oRenderTarget, _D2D1_CreateColorF(1, 1, 1, 0.7))

	Local $tEllipse = _D2D1_CreateEllipse($iX, $iY, 50, 50)

	_D2D1_DrawEllipse($oRenderTarget, $tEllipse, $hBrush2, 3)
	_D2D1_FillEllipse($oRenderTarget, $tEllipse, $hBrush1)

	_AutoItObject_IUnknownRelease($hBrush1)
	_AutoItObject_IUnknownRelease($hBrush2)
EndFunc

Func _Tool_Eyedropper_CanBypassLock($oSelf, $iLockMode)
	Return 1
EndFunc

Func _Tool_Eyedropper_ShowUI($oSelf)
	Return 0
EndFunc
