#include-once

Func _Tool_Path_Start($oSelf, $iX, $iY)
	$oSelf.lastX = $iX
	$oSelf.lastY = $iY

	If $oCurrentThread.thread.currentPath = -1 Then
		ConsoleWrite("d")
		$oPath = _CreatePath("Path "&($oCurrentThread.thread.paths.count+1))
		$oCurrentThread.thread.currentPath = $oCurrentThread.thread.paths.count
		$oCurrentThread.thread.paths.add($oPath)
	EndIf

	$oSelf.extra1 = $oCurrentThread.thread.paths.at($oCurrentThread.thread.currentPath)

	#cs

		Modes of path editing:
		0 - creating the point and moving BOTH arms, but controlling Arm1 (Arm2 follows along all by itself!)

		1 - controlling the position of Arm1 ONLY
		2 - controlling the position of Base and moving the rest
		3 - controlling the position of Arm2 ONLY

		The "Draw" function doesn't need to know if we're adding a new point or modifying an existing one.
		The $oSelf.extra2 is "a point" that exists in the path object. Period.

	#ce
	$oSelf.extra3 = 0

	If $oSelf.extra1.points.count > 0 Then
		$startP = $oSelf.extra1.points.at(0)
		If _Util_Distance($iX, $iY, $startP.baseX, $startP.baseY) < 10 Then
			$oSelf.extra1.closed = 1
			$oSelf.extra3 = 4 ; do nothing!
			Return
		EndIf
	EndIf

	$oPathPoint = -3 ; an arbitrary number. useless!
	For $point In $oSelf.extra1.points
		; Priority of selection: Arm1 => Arm2 => Base

		If _Util_Distance($iX, $iY, $point.arm1X, $point.arm1Y) < 20 Then
			$oPathPoint = $point
			$oSelf.extra3 = 1
			ExitLoop
		ElseIf _Util_Distance($iX, $iY, $point.arm2X, $point.arm2Y) < 20 Then
			$oPathPoint = $point
			$oSelf.extra3 = 3
			ExitLoop
		ElseIf _Util_Distance($iX, $iY, $point.baseX, $point.baseY) < 20 Then
			$oPathPoint = $point
			$oSelf.extra3 = 2
			ExitLoop
		EndIf
	Next

	If $oSelf.extra3 = 0 And $oSelf.extra1.closed Then
		$oPath = _CreatePath("Path "&($oCurrentThread.thread.paths.count+1))
		$oCurrentThread.thread.currentPath = $oCurrentThread.thread.paths.count
		$oCurrentThread.thread.paths.add($oPath)
	EndIf

	$oSelf.extra1 = $oCurrentThread.thread.paths.at($oCurrentThread.thread.currentPath)

	If Not IsObj($oPathPoint) Then
		$oPathPoint = _CreatePathPoint($iX, $iY, $iX, $iY, $iX, $iY) ; so many!
		$oSelf.extra1.points.add($oPathPoint)
	EndIf
	$oSelf.extra2 = $oPathPoint
EndFunc

Func _Tool_Path_Draw($oSelf, $iX, $iY)
	Switch $oSelf.extra3
		Case 0
			$arm2X = $oSelf.lastX-($iX-$oSelf.lastX)
			$arm2Y = $oSelf.lastY-($iY-$oSelf.lastY)
			$oSelf.extra2.arm1X = $iX
			$oSelf.extra2.arm1Y = $iY
			$oSelf.extra2.arm2X = $arm2X
			$oSelf.extra2.arm2Y = $arm2Y
		Case 1
			$oSelf.extra2.arm1X = $iX
			$oSelf.extra2.arm1Y = $iY
		Case 2
			$lastX = $oSelf.extra2.baseX
			$lastY = $oSelf.extra2.baseY

			$oSelf.extra2.baseX = $iX
			$oSelf.extra2.baseY = $iY
			$oSelf.extra2.arm1X = $iX + ($oSelf.extra2.arm1X-$lastX)
			$oSelf.extra2.arm1Y = $iY + ($oSelf.extra2.arm1Y-$lastY)
			$oSelf.extra2.arm2X = $iX + ($oSelf.extra2.arm2X-$lastX)
			$oSelf.extra2.arm2Y = $iY + ($oSelf.extra2.arm2Y-$lastY)
		Case 3
			$oSelf.extra2.arm2X = $iX
			$oSelf.extra2.arm2Y = $iY
	EndSwitch
EndFunc

Func _Tool_Path_End($oSelf, $iX, $iY)
EndFunc

Func _Tool_Path_DrawHUD($oSelf, $hGpx, $iX, $iY)
	$tPen = _GDIPlus_PenCreate(0xAAFFFFFF, 3)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)
	_GDIPlus_PenDispose($tPen)

	$tPen = _GDIPlus_PenCreate(0xAA000000)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)
	_GDIPlus_PenDispose($tPen)
EndFunc

Func _Tool_Path_DrawD2DHUD($oSelf, $oRenderTarget, $iX, $iY)
	Local $hPath1 = _D2D1_CreateSolidPath($oRenderTarget, _D2D1_CreateColorF(0, 0, 0, 0.7))
	Local $hPath2 = _D2D1_CreateSolidPath($oRenderTarget, _D2D1_CreateColorF(1, 1, 1, 0.7))
	Local $tEllipse = _D2D1_CreateEllipse($iX, $iY, $iPathWidth*$oCurrentThread.zoom/2, $iPathWidth*$oCurrentThread.zoom/2)

	_D2D1_DrawEllipse($oRenderTarget, $tEllipse, $hPath2, 3)
	_D2D1_DrawEllipse($oRenderTarget, $tEllipse, $hPath1, 1)

	_AutoItObject_IUnknownRelease($hPath1)
	_AutoItObject_IUnknownRelease($hPath2)
EndFunc

Func _Tool_Path_ShowUI($oSelf)
	$hPathUI = GUICreate("", 300, 40, 0, 30*$iUIScaleFactor, $WS_CHILD+$WS_VISIBLE, -1, $hMainUI)

	GUISwitch($hMainUI)

	Return $hPathUI
EndFunc

Func _Tool_Path_CanBypassLock($oSelf, $iLockMode)
	Return 1
EndFunc
