#include-once
;_Util_PopulateLayerListComboBox

Func _Anaglyph_Event()
	If Not $isOpen Then Return 0

	$iOpt = Opt("GUIOnEventMode", 0)

	$hDistortUI = GUICreate("Anaglyph", 314, 211, -1, -1, -1, -1, $hMainUI)

	GUICtrlCreateLabel("Left image", 8, 8, 36, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidLeft = GUICtrlCreateCombo("", 8, 32, 297, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")
	_Util_PopulateLayerListComboBox($cidLeft, $V4_LT_IMAGE)

	GUICtrlCreateLabel("Right image", 8, 80, 36, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidRight = GUICtrlCreateCombo("", 8, 104, 297, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")
	_Util_PopulateLayerListComboBox($cidRight, $V4_LT_IMAGE)

	$cidCancel = GUICtrlCreateButton("Cancel", 216, 168, 89, 33)
	$cidOK = GUICtrlCreateButton("OK", 120, 168, 89, 33)

	GUISetState()

	While 1
		Switch GUIGetMsg()
			Case -3, $cidCancel
				ExitLoop
			Case $cidOK
				$oLayerLeft = _Util_LayerNameToObject(GUICtrlRead($cidLeft))
				$oLayerRight = _Util_LayerNameToObject(GUICtrlRead($cidRight))

				_GDIPlus_BitmapDispose($oCurrentThread.thread.currentLayer.bmp)
				$oCurrentThread.thread.currentLayer.bmp = _GDIPlus_ImageClone($oLayerLeft.bmp)

				_Interference_Anaglyph($oCurrentThread.thread.currentLayer.bmp, $oLayerRight.bmp, $IF_REDCYAN)

				$oCurrentThread.historyAdd()
				ExitLoop
		EndSwitch
	WEnd

	GUIDelete($hDistortUI)
	GUISwitch($hMainUI)

	_RenderDrawingArea()

	Opt("GUIOnEventMode", $iOpt)
EndFunc