#include-once

Func _UEZFXEv_PenSketch()
	If Not $isOpen Then Return 0

	_ProgressOn("Applying effect...", "This can take a while.")
	$hBmp = $oCurrentThread.thread.currentLayer.bmp
	$hNewBmp = _GDIPlus_BitmapApplyFilter_PenSketch2($hBmp, 50)
	_GDIPlus_BitmapDispose($oCurrentThread.thread.currentLayer.bmp)
	$oCurrentThread.thread.currentLayer.bmp = $hNewBmp

	_ProgressOff()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

Func _UEZFXEv_Jitter()
	If Not $isOpen Then Return 0

	_ProgressOn("Applying effect...", "This can take a while.")
	$hBmp = $oCurrentThread.thread.currentLayer.bmp

	$sFile1 = _TempFile($TEMPORARYDIR, "~", ".png")
	$sFile2 = _TempFile($TEMPORARYDIR, "~", ".png")
	_GDIPlus_ImageSaveToFile($hBmp, $sFile1)
	RunWait('"'&@ScriptDir&'\vpaint_proc.exe" "'&$sFile1&'" "'&$sFile2&'" Jitter 15')
	$hNewBmp = _GDIPlus_ImageLoadFromFile($sFile2)

	$oCurrentThread.thread.currentLayer.bmp = $hNewBmp
	_GDIPlus_BitmapDispose($hBmp)

	_ProgressOff()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc

Func _UEZFXEv_Median()
	If Not $isOpen Then Return 0

	$iOpt = Opt("GUIOnEventMode", 0)

	$hFXUI = GUICreate("Median", 314, 162, -1, -1, -1, -1, $hMainUI)

	GUICtrlCreateLabel("Radius:", 8, 8, 77, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidRadius = GUICtrlCreateSlider(8, 32, 297, 33)
	GUICtrlSetLimit(-1, 25, 1)
	GUICtrlSetData(-1, 5)

	$cidCancel = GUICtrlCreateButton("Cancel", 216, 120, 89, 33)
	$cidOK = GUICtrlCreateButton("OK", 120, 120, 89, 33)

	GUISetState()

	While 1
		Switch GUIGetMsg()
			Case -3, $cidCancel
				ExitLoop
			Case $cidOK
				$hBmp = $oCurrentThread.thread.currentLayer.bmp

				$sFile1 = _TempFile($TEMPORARYDIR, "~", ".png")
				$sFile2 = _TempFile($TEMPORARYDIR, "~", ".png")
				_GDIPlus_ImageSaveToFile($hBmp, $sFile1)
				RunWait('"'&@ScriptDir&'\vpaint_proc.exe" "'&$sFile1&'" "'&$sFile2&'" Median '&GUICtrlRead($cidRadius))
				$hNewBmp = _GDIPlus_ImageLoadFromFile($sFile2)

				_GDIPlus_BitmapDispose($oCurrentThread.thread.currentLayer.bmp)
				$oCurrentThread.thread.currentLayer.bmp = $hNewBmp
				$oCurrentThread.historyAdd()

				ExitLoop
		EndSwitch
	WEnd

	GUIDelete($hFXUI)
	GUISwitch($hMainUI)

	_RenderDrawingArea()

	Opt("GUIOnEventMode", $iOpt)
EndFunc
