#include-once

; #VARIABLES# ===================================================================================================================
Global $__Tiles_aButtonObjectList[1] = [0]
; ===============================================================================================================================

Func _Tiles_CreateButton($sText, $iX, $iY, $iW, $iH, $iBgColor = 0xFFcccccc, $iHoverColor = 0xFFd8d8d8, $iTextColor = 0xFF212121, $sFont = "Segoe UI Semibold", $iSize = 11, $iBlank = 30)
	Local $cidBtn, $oObj

	Local $aSize = _GDIPlus_GraphicsGetStringBounds(String($sText), $sFont, 11)
	If IsKeyword($iW) = 1 and IsArray($aSize) Then $iW = $aSize[0]+$iBlank

	$cidBtn = GUICtrlCreateLabel("", $iX, $iY, $iW, $iH, $SS_BITMAP)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKTOP+$GUI_DOCKSIZE)
	GUICtrlSetTip(-1, StringStripWS($sText, 7))

	$oObj = _AutoItObject_Create()
	_AutoItObject_AddProperty($oObj, "ctrl", Default, $cidBtn)
	_AutoItObject_AddProperty($oObj, "text", Default, $sText)
	_AutoItObject_AddProperty($oObj, "bgcolor", Default, $iBgColor)
	_AutoItObject_AddProperty($oObj, "hovercolor", Default, $iHoverColor)
	_AutoItObject_AddProperty($oObj, "textcolor", Default, $iTextColor)

	_AutoItObject_AddProperty($oObj, "font", Default, $sFont)
	_AutoItObject_AddProperty($oObj, "size", Default, $iSize)

	_AutoItObject_AddProperty($oObj, "extra", Default, 0)

	_AutoItObject_AddMethod($oObj, "Render", "__Tiles_RenderButton")

	$oObj.Render()
	_GUICtrl_OnHoverRegister($cidBtn, "_Tiles_RenderBtnOnHoverLeave", "_Tiles_RenderBtnOnHoverLeave", "_Tiles_RenderBtnOnPress", "_Tiles_RenderBtnOnPress")

	_ArrayAdd($__Tiles_aButtonObjectList, $oObj)
	$__Tiles_aButtonObjectList[0] += 1

	Return SetExtended($iW, $cidBtn)
EndFunc

Func _Tiles_CreateButton2($sText, $iX, $iY, $iW, $iH, $iBgColor = 0xFFcccccc, $iHoverColor = 0xFFd8d8d8, $iPressColor = 0xFFbbbbbb, $iTextColor = 0xFF212121, $sFont = "Segoe UI Semibold", $iSize = 11, $hImage = 0, $iImgOffsetV = 0, $iTextOffsetV = 0, $iOffsetH = 0)
	Local $cidBtn, $oObj

	Local $aSize = _GDIPlus_GraphicsGetStringBounds(String($sText), $sFont, 11)
	If IsKeyword($iW) = 1 and IsArray($aSize) Then $iW = $aSize[0]

	$cidBtn = GUICtrlCreateLabel("", $iX, $iY, $iW, $iH, $SS_BITMAP)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKTOP+$GUI_DOCKSIZE)
	GUICtrlSetTip(-1, StringStripWS($sText, 7))

	$oObj = _AutoItObject_Create()
	_AutoItObject_AddProperty($oObj, "ctrl", Default, $cidBtn)
	_AutoItObject_AddProperty($oObj, "text", Default, $sText)
	_AutoItObject_AddProperty($oObj, "bgcolor", Default, $iBgColor)
	_AutoItObject_AddProperty($oObj, "hovercolor", Default, $iHoverColor)
	_AutoItObject_AddProperty($oObj, "presscolor", Default, $iPressColor)
	_AutoItObject_AddProperty($oObj, "textcolor", Default, $iTextColor)

	_AutoItObject_AddProperty($oObj, "font", Default, $sFont)
	_AutoItObject_AddProperty($oObj, "size", Default, $iSize)

	_AutoItObject_AddProperty($oObj, "image", Default, $hImage)
	_AutoItObject_AddProperty($oObj, "voffset", Default, $iImgOffsetV)

	_AutoItObject_AddProperty($oObj, "voffset2", Default, $iTextOffsetV)
	_AutoItObject_AddProperty($oObj, "hoffset", Default, $iOffsetH)

	_AutoItObject_AddProperty($oObj, "extra", Default, 0)

	_AutoItObject_AddMethod($oObj, "Render", "__Tiles_RenderButton2")

	$oObj.Render()
	_GUICtrl_OnHoverRegister($cidBtn, "_Tiles_RenderBtnOnHoverLeave", "_Tiles_RenderBtnOnHoverLeave", "_Tiles_RenderBtnOnPress", "_Tiles_RenderBtnOnPress")

	_ArrayAdd($__Tiles_aButtonObjectList, $oObj)
	$__Tiles_aButtonObjectList[0] += 1

	Return SetExtended($iW, $cidBtn)
EndFunc

Func _Tiles_CreateExtButton($sText, $sHeader, $iX, $iY, $iW, $iH, $iBgColor = 0xFFcccccc, $iHoverColor = 0xFFd8d8d8, $iTextColor = 0xFF212121)
	Local $cidBtn, $oObj

	$cidBtn = GUICtrlCreateLabel("", $iX, $iY, $iW, $iH, $SS_BITMAP)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKTOP+$GUI_DOCKSIZE)
	GUICtrlSetTip(-1, $sText, $sHeader)

	$oObj = _AutoItObject_Create()
	_AutoItObject_AddProperty($oObj, "ctrl", Default, $cidBtn)
	_AutoItObject_AddProperty($oObj, "text", Default, $sText)
	_AutoItObject_AddProperty($oObj, "header", Default, $sHeader)
	_AutoItObject_AddProperty($oObj, "bgcolor", Default, $iBgColor)
	_AutoItObject_AddProperty($oObj, "hovercolor", Default, $iHoverColor)
	_AutoItObject_AddProperty($oObj, "textcolor", Default, $iTextColor)

	_AutoItObject_AddProperty($oObj, "extra", Default, 0)

	_AutoItObject_AddMethod($oObj, "Render", "__Tiles_RenderExtButton")

	$oObj.Render()
	_GUICtrl_OnHoverRegister($cidBtn, "_Tiles_RenderBtnOnHoverLeave", "_Tiles_RenderBtnOnHoverLeave", "_Tiles_RenderBtnOnPress", "_Tiles_RenderBtnOnPress")

	_ArrayAdd($__Tiles_aButtonObjectList, $oObj)
	$__Tiles_aButtonObjectList[0] += 1

	Return $cidBtn
EndFunc

Func _Tiles_ButtonGetExtra($ctrl)
	Local $iIndex = _Tiles_GetButtonIndexFromCtrl($ctrl)
	Local $oObj = $__Tiles_aButtonObjectList[$iIndex]

	Return $oObj.extra
EndFunc

Func _Tiles_ButtonSetExtra($ctrl, $extra)
	Local $iIndex = _Tiles_GetButtonIndexFromCtrl($ctrl)
	Local $oObj = $__Tiles_aButtonObjectList[$iIndex]

	$oObj.extra = $extra
EndFunc

Func _Tiles_Button2SetColors($ctrl, $bg, $hover, $press)
	Local $iIndex = _Tiles_GetButtonIndexFromCtrl($ctrl)
	Local $oObj = $__Tiles_aButtonObjectList[$iIndex]

	$oObj.bgcolor = $bg
	$oObj.hovercolor = $hover
	$oObj.presscolor = $press

	$oObj.render()
EndFunc

Func _Tiles_ButtonSetTextColor($ctrl, $color)
	Local $iIndex = _Tiles_GetButtonIndexFromCtrl($ctrl)
	Local $oObj = $__Tiles_aButtonObjectList[$iIndex]

	$oObj.textcolor = $color

	$oObj.render()
EndFunc

Func _Tiles_ButtonSetBkColor($ctrl, $bg, $hover)
	Local $iIndex = _Tiles_GetButtonIndexFromCtrl($ctrl)
	Local $oObj = $__Tiles_aButtonObjectList[$iIndex]

	$oObj.bgcolor = $bg
	$oObj.hovercolor = $hover

	$oObj.render()
EndFunc

Func _Tiles_ButtonSetImage($ctrl, $image)
	Local $iIndex = _Tiles_GetButtonIndexFromCtrl($ctrl)
	Local $oObj = $__Tiles_aButtonObjectList[$iIndex]

	$oObj.image = $image
	$oObj.Render()
EndFunc

Func _Tiles_ButtonDelete($ctrl)
	Local $iIndex = _Tiles_GetButtonIndexFromCtrl($ctrl)
	Local $oObj = $__Tiles_aButtonObjectList[$iIndex]

	$oObj = 0
	GUICtrlDelete($ctrl)
	_ArrayDelete($__Tiles_aButtonObjectList, $iIndex)
	$__Tiles_aButtonObjectList[0] -= 1
EndFunc

Func __Tiles_RenderButton($obj, $mode = $TEV_NORMAL)
	Local $aPos = ControlGetPos(_WinAPI_GetParent(GUICtrlGetHandle($obj.ctrl)), "", $obj.ctrl)

	Local $tBmp = _GDIPlus_BitmapCreateFromScan0($aPos[2], $aPos[3])

	Local $tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)
	_GDIPlus_GraphicsSetTextRenderingHint($tGpx, $__Tiles_iTextRenderingHint)

	If $mode <> $TEV_NORMAL Then
		Local $tBrush = _GDIPlus_BrushCreateSolid(($mode = $TEV_HOVER) ? $obj.hovercolor : 0xFF000000)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, $aPos[2], $aPos[3], $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	Else
		Local $tBrush = _GDIPlus_BrushCreateSolid($obj.bgcolor)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, $aPos[2], $aPos[3], $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	EndIf

	;_GDIPlus_GraphicsDrawStringRect($hGraphics, $sString, $nX, $nY, $nWidth, $nHeight, $sFont = "Arial", $nSize = 10, $iStyle = 0, $iAlign = 0, $iVertAlign = 0, $iFormat = 0, $iColor = 0xFF000000)
	_GDIPlus_GraphicsDrawStringRect($tGpx, $obj.text, 0, 0, $aPos[2], $aPos[3], $obj.font, $obj.size, 0, 1, 1, 0, ($mode = $TEV_PRESSED) ? 0xFFFFFFFF : $obj.textcolor)

	_GDIPlus_GraphicsDispose($tGpx)

	Local $tHbmp = _GDIPlus_BitmapCreateDIBFromBitmap($tBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $tHbmp))
	_WinAPI_DeleteObject($tHbmp)

	_GDIPlus_BitmapDispose($tBmp)
EndFunc

Func __Tiles_RenderButton2($obj, $mode = $TEV_NORMAL, $hOutput = 0, $iOutX = 0, $iOutY = 0, $iOutScale = 1)
	Local $aPos = ControlGetPos(_WinAPI_GetParent(GUICtrlGetHandle($obj.ctrl)), "", $obj.ctrl)

	Local $tBmp = _GDIPlus_BitmapCreateFromScan0($aPos[2], $aPos[3])

	Local $tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)
	_GDIPlus_GraphicsSetTextRenderingHint($tGpx, $__Tiles_iTextRenderingHint)

	If $mode <> $TEV_NORMAL Then
		Local $tBrush = _GDIPlus_BrushCreateSolid(($mode = $TEV_HOVER) ? $obj.hovercolor : $obj.presscolor)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, $aPos[2], $aPos[3], $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	Else
		Local $tBrush = _GDIPlus_BrushCreateSolid($obj.bgcolor)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, $aPos[2], $aPos[3], $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	EndIf

	If $obj.image <> 0 Then
		_GDIPlus_GraphicsDrawImageRect($tGpx, $obj.image, 10+$obj.hoffset, Int(($aPos[3]-_GDIPlus_ImageGetHeight($obj.image))/2)+$obj.voffset, _GDIPlus_ImageGetWidth($obj.image), _GDIPlus_ImageGetHeight($obj.image))
	EndIf

	Local $aSize = _StringSize(String($obj.text), $obj.size, 400, 0, $obj.font)
	_GDIPlus_GraphicsDrawString_($tGpx, $obj.text, 10+($obj.image ? _GDIPlus_ImageGetWidth($obj.image)+8 : 0)+$obj.hoffset, ($aPos[3]-$aSize[3])/2+$obj.voffset2, $obj.font, $obj.size, 0, 0, $obj.textcolor)

	_GDIPlus_GraphicsDispose($tGpx)

	If $hOutput = 0 Then
		Local $tHbmp = _GDIPlus_BitmapCreateDIBFromBitmap($tBmp)
		_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $tHbmp))
		_WinAPI_DeleteObject($tHbmp)
	Else
		_GDIPlus_GraphicsDrawImageRect($hOutput, $tBmp, $iOutX, $iOutY, $aPos[2]*$iOutScale, $aPos[3]*$iOutScale)
	EndIf

	_GDIPlus_BitmapDispose($tBmp)
EndFunc

Func __Tiles_RenderExtButton($obj, $mode = $TEV_NORMAL)
	Local $aPos = ControlGetPos(_WinAPI_GetParent(GUICtrlGetHandle($obj.ctrl)), "", $obj.ctrl)

	Local $tBmp = _GDIPlus_BitmapCreateFromScan0($aPos[2], $aPos[3])

	Local $tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)
	_GDIPlus_GraphicsClear($tGpx, $obj.bgcolor)
	_GDIPlus_GraphicsSetTextRenderingHint($tGpx, $__Tiles_iTextRenderingHint)

	If $mode <> $TEV_NORMAL Then
		Local $tBrush = _GDIPlus_BrushCreateSolid(($mode = $TEV_HOVER) ? $obj.hovercolor : 0xFF000000)
		_GDIPlus_GraphicsFillRect($tGpx, 0, 0, $aPos[2], $aPos[3], $tBrush)
		_GDIPlus_BrushDispose($tBrush)
	EndIf

	Local $aSize = _StringSize(String($obj.header), 16, 400, 0, "Segoe UI Light")
	_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 5, 4, "Segoe UI Light", 16, 0, 0, ($mode = $TEV_PRESSED) ? 0xFFFFFFFF : $obj.textcolor)

	Local $aSize = _StringSize(String($obj.text), 11, 400, 0, "Segoe UI", Int($aPos[2]-14))
	_GDIPlus_GraphicsDrawString_($tGpx, $aSize[0], 7, 30, "Segoe UI", 11, 0, 0, ($mode = $TEV_PRESSED) ? 0xFFFFFFFF : $obj.textcolor)

	_GDIPlus_GraphicsDispose($tGpx)

	Local $tHbmp = _GDIPlus_BitmapCreateDIBFromBitmap($tBmp)
	_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($obj.ctrl), 0x0172, 0, $tHbmp))
	_WinAPI_DeleteObject($tHbmp)

	_GDIPlus_BitmapDispose($tBmp)
EndFunc

Func _Tiles_RenderBtnOnHoverLeave($ctrl, $mode)
	Local $iIndex = _Tiles_GetButtonIndexFromCtrl($ctrl)
	Local $oObj = $__Tiles_aButtonObjectList[$iIndex]

	Switch $mode
		Case 1
			$oObj.Render($TEV_HOVER)
		Case 2
			$oObj.Render($TEV_NORMAL)
	EndSwitch
EndFunc

Func _Tiles_RenderBtnOnPress($ctrl, $mode)
	Local $iIndex = _Tiles_GetButtonIndexFromCtrl($ctrl)
	Local $oObj = $__Tiles_aButtonObjectList[$iIndex]

	Switch $mode
		Case 1
			$oObj.Render($TEV_PRESSED)
		Case 2
			$oObj.Render($TEV_HOVER)
	EndSwitch
EndFunc

Func _Tiles_GetButtonObject($cidCtrl)
	Return $__Tiles_aButtonObjectList[_Tiles_GetButtonIndexFromCtrl($cidCtrl)]
EndFunc

Func _Tiles_GetButtonIndexFromCtrl($cidCtrl)
	Local $oObj

	If _Tiles_GetButtonCount() = 0 Then Return False

	For $i = _Tiles_GetButtonCount() To 1 Step -1
		$oObj = $__Tiles_aButtonObjectList[$i]
		If $oObj.ctrl = $cidCtrl Then Return $i
	Next

	Return False
EndFunc

Func _Tiles_GetButtonCount()
	Return $__Tiles_aButtonObjectList[0]
EndFunc
