#include-once

Func _CreatePovLayer($sFile, $iX = 0, $iY = 0, $iW = 0, $iH = 0)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "type", $ELSCOPE_PUBLIC, $V4_LT_POVRAY)
	_AutoItObject_AddProperty($obj, "name", $ELSCOPE_PUBLIC, "Image")

	_AutoItObject_AddProperty($obj, "isVisible", $ELSCOPE_PUBLIC, 1)
	_AutoItObject_AddProperty($obj, "lockMode", $ELSCOPE_PUBLIC, $V4_LL_NONE)

	_AutoItObject_AddProperty($obj, "x", $ELSCOPE_PUBLIC, $iX)
	_AutoItObject_AddProperty($obj, "y", $ELSCOPE_PUBLIC, $iY)

	_AutoItObject_AddProperty($obj, "canDraw", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "isSmart", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "ref", $ELSCOPE_PUBLIC, 1)

	_AutoItObject_AddProperty($obj, "width", $ELSCOPE_PUBLIC, $iW)
	_AutoItObject_AddProperty($obj, "height", $ELSCOPE_PUBLIC, $iH)

	_AutoItObject_AddProperty($obj, "bmp", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "onRenderBmp", $ELSCOPE_PUBLIC, _GDIPlus_ImageLoadFromFile(@ScriptDir&"\Data\AppUI\RenderingOverlay.png"))
	_AutoItObject_AddProperty($obj, "renderedBmp", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "povFile", $ELSCOPE_PUBLIC, $sFile)
	_AutoItObject_AddProperty($obj, "outFile", $ELSCOPE_PUBLIC, StringTrimRight($sFile, 4)&".png")

	_AutoItObject_AddMethod($obj, "clone", "_PovLayer_Clone")
	_AutoItObject_AddMethod($obj, "render", "_PovLayer_Render")
	_AutoItObject_AddMethod($obj, "dispose", "_PovLayer_Dispose")

	_AutoItObject_AddMethod($obj, "createIni", "_PovLayer_CreateIniFile")
	_AutoItObject_AddMethod($obj, "renderFile", "_PovLayer_RenderFile")

	_AutoItObject_AddDestructor($obj, "_PovLayer_Dispose")

	Return $obj
EndFunc

Func _PovLayer_Render($oSelf, $iQuality = 0)
	If FileExists($oSelf.outFile) Then
		$tmp = _TempFile($TEMPORARYDIR, "~", ".png")
		FileCopy($oSelf.outFile, $tmp)
		$oSelf.renderedBmp = _GDIPlus_ImageLoadFromFile($tmp)
		$oSelf.bmp = _GDIPlus_ImageClone($oSelf.renderedBmp)
		_GDIPlus_ImageDispose($oSelf.renderedBmp)
		$oSelf.renderedBmp = 0
	Else
		$oSelf.bmp = $oSelf.onRenderBmp
	EndIf
EndFunc

Func _PovLayer_RenderFile($oSelf, $bWait = False)
	$oSelf.renderedBmp = 0

	FileDelete($oSelf.outFile)

	$oSelf.render()
	_RenderDrawingArea()

	$sExeFile = @ScriptDir&"\Data\Libraries\pvengine.exe"
	$sIniFile = $oSelf.createIni

	If $bWait Then
		$PID = RunWait('"'&$sExeFile&'" /RENDER "'&$sIniFile&'"', _WinAPI_PathRemoveFileSpec($oSelf.povFile), @SW_HIDE)
	Else
		Run('"'&$sExeFile&'" /RENDER "'&$sIniFile&'"', _WinAPI_PathRemoveFileSpec($oSelf.povFile), @SW_HIDE)
	EndIf
EndFunc

Func _PovLayer_Clone($oSelf)
	$layer = _CreatePovLayer($oSelf.povFile, $oSelf.x, $oSelf.y)

	$layer.name = $oSelf.name
	$layer.isVisible = $oSelf.isVisible
	$layer.lockMode = $oSelf.lockMode
	$layer.canDraw = $oSelf.canDraw
	$layer.isSmart = $oSelf.isSmart

	$layer.render()

	Return $layer
EndFunc

Func _PovLayer_Dispose(ByRef $oSelf)
	_GDIPlus_BitmapDispose($oSelf.bmp)
	$oSelf = 0
EndFunc

Func _PovLayer_CreateIniFile($oSelf, $iQuality = 0)
	$file = _TempFile(@ScriptDir&"\Data\Pov\RenderIni", "", ".ini")

	FileWrite($file, "Quality=10"&@CRLF)
	FileWrite($file, "Width="&$oSelf.width&@CRLF)
	FileWrite($file, "Height="&$oSelf.height&@CRLF)
	FileWrite($file, "+a0.3"&@CRLF)
	FileWrite($file, "Verbose=Off"&@CRLF)
	FileWrite($file, "Display=Off"&@CRLF)
	FileWrite($file, "Output_to_File=On"&@CRLF)
	FileWrite($file, "Output_File_Type=N"&@CRLF)
	FileWrite($file, "Output_Alpha=On"&@CRLF)
	FileWrite($file, "Input_File_Name="&$oSelf.povFile&@CRLF)
	FileWrite($file, "Library_Path=..\Include"&@CRLF)
	FileWrite($file, "Version=3.7"&@CRLF)

	Return $file
EndFunc

Func _Pov_CheckIsAllRendered()
	If $isOpen Then
		For $Layer In $oCurrentThread.thread.layers
			If $Layer.type = $V4_LT_POVRAY Then
				If FileExists($Layer.outFile) Then
					Return True
				EndIf
			EndIf
		Next
	EndIf

	Return False
EndFunc

Func _Pov_RefreshLayers()
	If $isOpen Then
		For $Layer In $oCurrentThread.thread.layers
			If $Layer.type = $V4_LT_POVRAY Then
				ConsoleWrite($Layer.outFile&@CRLF)
				$Layer.render()
			EndIf
		Next

		_RenderDrawingArea()
	EndIf
EndFunc

Func _Pov_RefreshViewportImage()
	$Layer = $oCurrentThread.thread.currentLayer
	$Layer.render()

	_RenderDrawingArea()
EndFunc

Func _Pov_RenderCurrentLayer()
	$Layer = $oCurrentThread.thread.currentLayer

	$Layer.renderFile(True)
	$Layer.render()

	_RenderDrawingArea()
EndFunc
