#include-once

Func _POV_CreateDiffuseFinish($fAmount)
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "amount", $ELSCOPE_PUBLIC, $fAmount)

	_AutoItObject_AddMethod($obj, "Clone", "_POV_CloneDiffuseFinish")
	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GenerateDiffuseFinishCode")

	Return $obj
EndFunc

Func _POV_CloneDiffuseFinish($oSelf)
	Return _POV_CreateDiffuseFinish($oSelf.amount)
EndFunc

Func _POV_GenerateDiffuseFinishCode($oSelf)
	Local $sCode

	$sCode = "diffuse "&$oSelf.amount

	Return $sCode
EndFunc

Func _POV_CreateAmbientFinish($oColor)
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "color", $ELSCOPE_PUBLIC, $oColor)

	_AutoItObject_AddMethod($obj, "Clone", "_POV_CloneAmbientFinish")
	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GenerateAmbientFinishCode")

	Return $obj
EndFunc

Func _POV_CloneAmbientFinish($oSelf)
	Return _POV_CreateAmbientFinish($oSelf.color.Clone())
EndFunc

Func _POV_GenerateAmbientFinishCode($oSelf)
	Local $sCode

	$sCode = "ambient <"&$oSelf.color.v1&", "&$oSelf.color.v2&", "&$oSelf.color.v3&">"

	Return $sCode
EndFunc

Func _POV_CreatePhongFinish($fAmount = 0, $fSize = 40)
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "amount", $ELSCOPE_PUBLIC, $fAmount)
	_AutoItObject_AddProperty($obj, "size", $ELSCOPE_PUBLIC, $fSize)

	_AutoItObject_AddMethod($obj, "Clone", "_POV_ClonePhongFinish")
	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GeneratePhongFinishCode")

	Return $obj
EndFunc

Func _POV_ClonePhongFinish($oSelf)
	Return _POV_CreatePhongFinish($oSelf.amount, $oSelf.size)
EndFunc

Func _POV_GeneratePhongFinishCode($oSelf)
	Local $sCode

	$sCode = "phong "&$oSelf.amount&@CRLF
	$sCode &= "phong_size "&$oSelf.size

	Return $sCode
EndFunc

Func _POV_CreateSpecularFinish($fAmount = 0, $fRoughness = 0.05)
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "amount", $ELSCOPE_PUBLIC, $fAmount)
	_AutoItObject_AddProperty($obj, "rough", $ELSCOPE_PUBLIC, $fRoughness)

	_AutoItObject_AddMethod($obj, "Clone", "_POV_CloneSpecularFinish")
	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GenerateSpecularFinishCode")

	Return $obj
EndFunc

Func _POV_CloneSpecularFinish($oSelf)
	Return _POV_CreatePhongFinish($oSelf.amount, $oSelf.rough)
EndFunc

Func _POV_GenerateSpecularFinishCode($oSelf)
	Local $sCode

	$sCode = "specular "&$oSelf.amount&" roughness "&$oSelf.rough

	Return $sCode
EndFunc

Func _POV_CreateMetallicFinish()
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddMethod($obj, "Clone", "_POV_CloneMetallicFinish")
	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GenerateMetallicFinishCode")

	Return $obj
EndFunc

Func _POV_CloneMetallicFinish($oSelf)
	Return _POV_CreateMetallicFinish()
EndFunc

Func _POV_GenerateMetallicFinishCode($oSelf)
	Local $sCode

	$sCode = "metallic"

	Return $sCode
EndFunc

Func _POV_CreateReflectionFinish($oColor, $fMetallic = 0, $bConserveEnergy = 0)
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "color", $ELSCOPE_PUBLIC, $oColor)
	_AutoItObject_AddProperty($obj, "metallic", $ELSCOPE_PUBLIC, $fMetallic)
	_AutoItObject_AddProperty($obj, "conserve", $ELSCOPE_PUBLIC, $bConserveEnergy)

	_AutoItObject_AddMethod($obj, "Clone", "_POV_CloneReflectionFinish")
	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GenerateReflectionFinishCode")

	Return $obj
EndFunc

Func _POV_CloneReflectionFinish($oSelf)
	Return _POV_CreateReflectionFinish($oSelf.color.Clone(), $oSelf.metallic)
EndFunc

Func _POV_GenerateReflectionFinishCode($oSelf)
	Local $sCode

	$sCode = "reflection {"&@CRLF

	$sCode &= "<"&$oSelf.color.v1&", "&$oSelf.color.v2&", "&$oSelf.color.v3&">"&@CRLF

	If $oSelf.metallic > 0 Then $sCode &= "metallic "&$oSelf.metallic&@CRLF

	$sCode &= "}"

	Return $sCode
EndFunc

Func _POV_CreateConserveFinish()
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddMethod($obj, "Clone", "_POV_CloneConserveFinish")
	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GenerateConserveFinishCode")

	Return $obj
EndFunc

Func _POV_CloneConserveFinish($oSelf)
	Return _POV_CreateMetallicFinish()
EndFunc

Func _POV_GenerateConserveFinishCode($oSelf)
	Local $sCode

	$sCode = "conserve_energy"

	Return $sCode
EndFunc
