#include-once

Func _AddThread($obj)
	_ArrayAdd($aThreads, $obj)
	$aThreads[0] += 1
EndFunc

Func _SelectThread($iThread)
	$oCurrentThread = $aThreads[$iThread]
	$iCurrentThread = $iThread
EndFunc

Func _CreateThreadManager($oThread)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "thread", $ELSCOPE_PUBLIC, $oThread)
	_AutoItObject_AddProperty($obj, "file", $ELSCOPE_PUBLIC, "")
	_AutoItObject_AddProperty($obj, "type", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "isNew", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "viewDx", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "viewDy", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "zoom", $ELSCOPE_PUBLIC, 1)
	_AutoItObject_AddProperty($obj, "zoomGrid", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "name", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "compList", $ELSCOPE_PUBLIC, LinkedList())
	_AutoItObject_AddProperty($obj, "compBmp", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "compOutNode", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "compQuality", $ELSCOPE_PUBLIC, $V4_CQ_DRAFT)

	_CreateBasicComposition($obj)

	_AutoItObject_AddProperty($obj, "history", $ELSCOPE_PUBLIC, LinkedList())
	_AutoItObject_AddProperty($obj, "currentPos", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddMethod($obj, "historyAdd", "_ThreadManager_HistoryAdd")
	_AutoItObject_AddMethod($obj, "historyMove", "_ThreadManager_HistoryMove")
	_AutoItObject_AddMethod($obj, "undo", "_ThreadManager_Undo")
	_AutoItObject_AddMethod($obj, "redo", "_ThreadManager_Redo")

	_AutoItObject_AddMethod($obj, "dispose", "_ThreadManager_Dispose")

	_AutoItObject_AddDestructor($obj, "_ThreadManager_Dispose")

	Return $obj
EndFunc

Func _ThreadManager_HistoryAdd($oSelf, $sLabel = "Unknown operation")
	$isWorkingOnHistory = 1

	; delete threads after current position
	If ($oSelf.history.count()-1) > $oSelf.currentPos Then
		$newlist = LinkedList()
		For $i = 0 To $oSelf.currentPos
			$newlist.add($oSelf.history.at($i).clone())
		Next

		For $thread In $oSelf.history
			$thread.dispose()
		Next

		$oSelf.history = $newlist
	EndIf

	$oSelf.thread.historyDescription = $sLabel
	$oSelf.history.add($oSelf.thread.clone())
	$oSelf.currentPos = $oSelf.currentPos+1

	$isWorkingOnHistory = 0
EndFunc

Func _ThreadManager_Undo($oSelf)
	$oSelf.historyMove(-1)
EndFunc

Func _ThreadManager_Redo($oSelf)
	$oSelf.historyMove(+1)
EndFunc

Func _ThreadManager_HistoryMove($oSelf, $iStep)
	$isWorkingOnHistory = 1

	If ($oSelf.history.count()-1) >= ($oSelf.currentPos+$iStep) And ($oSelf.currentPos+$iStep) >= 0 Then
		$oSelf.currentPos = $oSelf.currentPos+$iStep

		$thread = $oSelf.thread
		$oSelf.thread = $oSelf.history.at($oSelf.currentPos).clone()
		$thread.dispose()
	EndIf

	$isWorkingOnHistory = 0
EndFunc

Func _ThreadManager_Dispose(ByRef $oSelf)
	$oSelf.thread.dispose()

	For $thread In $oSelf.history
		$thread.dispose()
	Next

	$oSelf = 0
EndFunc
