#include-once

#cs

	This file is kept here just for your entertainment.
	vPaint now uses the XML-based file format.

#ce

Func _V4ISave($oThread, $sFile)
	Local $i = 0
	FileDelete($sFile)

	; create a .V4I zip file
	_Zip_Create($sFile&".zip")

	$sPrefix = _Util_GenerateRandomPrefix()
	$dir = @TempDir&"\"&$sPrefix
	DirCreate($dir)

	; create manifest file
	$tmpManifest = $dir&"\ImageManifest.v4m"

	; save all layers and put them into .V4I
	For $layer In $oThread.thread.layers
		Switch $layer.type
			Case $V4_LT_IMAGE
				$layer.render()

				$sTmpFile = $dir&"\Layer"&$i&".png"
				_GDIPlus_ImageSaveToFile($layer.bmp, $sTmpFile)

				_Zip_AddFile($sFile&".zip", $sTmpFile)
			Case $V4_LT_POVRAY
				$sTmpFile = $dir&"\Layer"&$i&".png"
				_GDIPlus_ImageSaveToFile($layer.bmp, $sTmpFile)
				IniWrite($tmpManifest, "V4Layer"&$i, "POVRayFile", _WinAPI_PathRelativePathTo($sFile, 0, $layer.povFile, 0))
		EndSwitch

		IniWrite($tmpManifest, "V4Layer"&$i, "LayerType", $layer.type)
		IniWrite($tmpManifest, "V4Layer"&$i, "LayerName", $layer.name)
		IniWrite($tmpManifest, "V4Layer"&$i, "IsVisible", $layer.isVisible)
		IniWrite($tmpManifest, "V4Layer"&$i, "LockMode", $layer.lockMode)

		FileDelete($sTmpFile)
		$i += 1
	Next

	IniWrite($tmpManifest, "V4Image", "LayerCount", $i)
	IniWrite($tmpManifest, "V4Image", "CreatorId", "vPaint4x")
	IniWrite($tmpManifest, "V4Image", "FormatVersion", 101)
	IniWrite($tmpManifest, "V4Image", "ImageWidth", $oThread.thread.width)
	IniWrite($tmpManifest, "V4Image", "ImageHeight", $oThread.thread.height)

	; add manifest to .V4I and delete temporary one
	_Zip_AddFile($sFile&".zip", $tmpManifest)
	FileDelete($tmpManifest)

	FileCopy($sFile&".zip", $sFile)
	FileDelete($sFile&".zip")
EndFunc

Func _V4IOpen($sFile)
	$dir = $TEMPORARYDIR&"\Extract"

	; unpack .V4I
	FileCopy($sFile, $sFile&".zip")
	DirCreate($dir)
	_Zip_UnzipAll($sFile&".zip", $dir)

	; generate random prefix
	$sPrefix = _Util_GenerateRandomPrefix()

	; move manifest
	FileCopy($dir&"\ImageManifest.v4m", $TEMPORARYDIR&"\"&$sPrefix&"ImageManifest.v4m")

	; load manifest data
	$iWidth = IniRead($TEMPORARYDIR&"\"&$sPrefix&"ImageManifest.v4m", "V4Image", "ImageWidth", 0)
	$iHeight = IniRead($TEMPORARYDIR&"\"&$sPrefix&"ImageManifest.v4m", "V4Image", "ImageHeight", 0)
	$iCount = IniRead($TEMPORARYDIR&"\"&$sPrefix&"ImageManifest.v4m", "V4Image", "LayerCount", 0)

	; move layers
	For $i = 0 To ($iCount-1)
		FileCopy($dir&"\Layer"&$i&".png", $TEMPORARYDIR&"\"&$sPrefix&"Layer"&$i&".png")
	Next

	; delete temporary dir
	DirRemove($dir, 1)

	; create an empty thread
	$oThread = _CreateThread($iWidth, $iHeight)

	; add layers
	For $i = 0 To ($iCount-1)
		$type = Int(IniRead($TEMPORARYDIR&"\"&$sPrefix&"ImageManifest.v4m", "V4Layer"&$i, "LayerType", 0))

		Switch $type
			Case $V4_LT_IMAGE
				$hBmp = _GDIPlus_ImageLoadFromFile($TEMPORARYDIR&"\"&$sPrefix&"Layer"&$i&".png")

				$oLayer = _CreateImageLayer($hBmp)
			Case $V4_LT_POVRAY
				$hBmp = _GDIPlus_ImageLoadFromFile($TEMPORARYDIR&"\"&$sPrefix&"Layer"&$i&".png")
				$sPovFile = _WinAPI_PathCanonicalize(_WinAPI_PathRemoveFileSpec($sFile)&"\"&IniRead($TEMPORARYDIR&"\"&$sPrefix&"ImageManifest.v4m", "V4Layer"&$i, "POVRayFile", ""))
				ConsoleWrite($sPovFile)

				$oLayer = _CreatePovLayer($sPovFile)
				$oLayer.bmp = $hBmp
		EndSwitch

		$oLayer.name = IniRead($TEMPORARYDIR&"\"&$sPrefix&"ImageManifest.v4m", "V4Layer"&$i, "LayerName", "Layer "&$i)
		$oLayer.isVisible = IniRead($TEMPORARYDIR&"\"&$sPrefix&"ImageManifest.v4m", "V4Layer"&$i, "IsVisible", 1)
		$oLayer.LockMode = IniRead($TEMPORARYDIR&"\"&$sPrefix&"ImageManifest.v4m", "V4Layer"&$i, "LockMode", $V4_LL_NONE)

		$oThread.addLayer($oLayer)
	Next
	$oThread.selectLayer(0)

	; create ThreadManager
	$oThreadMgm = _CreateThreadManager($oThread)
	$oThreadMgm.name = _WinAPI_PathFindFileName($sFile)
	$oThreadMgm.file = $sFile
	$oThreadMgm.historyAdd()
	$oThreadMgm.type = $V4_TT_IMAGE

	; end the party
	_AddThread($oThreadMgm)
	_SelectThread($aThreads[0])

	$isOpen = 1

	FileDelete($sFile&".zip")
EndFunc
