#include-once

#include <APIConstants.au3>

#include "COM/Direct2D.intfc"
#include "COM/WIC.intfc"

#include "Direct2DConstants.au3"

#include "Direct2DBitmap.au3"
#include "Direct2DBrush.au3"
#include "Direct2DColor.au3"
#include "Direct2DGeometry.au3"
#include "Direct2DGeometrySink.au3"
#include "Direct2DRenderTarget.au3"
#include "Direct2DShapes.au3"
#include "Direct2DStrokes.au3"
#include "Direct2DStruct.au3"

#include "Direct2DInternal.au3"

; #INDEX# =======================================================================================================================
; Title .........: Direct2D UDF
; AutoIt Version : 3.3.14.0
; Description ...: Direct2D UDF for use in AutoIt3 scripts.
; Author(s) .....: scintilla4evr, .INTFC file by trancexx
; ===============================================================================================================================

Func _D2D1_CreateFactoryObject($iType = $D2D1_FACTORY_TYPE_SINGLE_THREADED, $iDebugLevel = $D2D1_DEBUG_LEVEL_NONE)
	Local $hDll = DllOpen("d2d1.dll")
	Local $tIID_ID2D1Factory = _AutoItObject_CLSIDFromString($sIID_ID2D1Factory)
	Local $aCall = DllCall($hDll, "long", "D2D1CreateFactory", _
			"dword", $iType, _
			"ptr", DllStructGetPtr($tIID_ID2D1Factory), _
			"dword*", $iDebugLevel, _
			"ptr*", 0)
	If @error Or $aCall[0] Then Return SetError(1, 0, 0)
	Local $pD2D1Factory = $aCall[4]
	Return _AutoItObject_WrapperCreate($pD2D1Factory, $dtagID2D1Factory)
EndFunc

Func _D2D1_GetDesktopDpi($oFactory)
	Local $aCall = $oFactory.GetDesktopDpi(0, 0)
	Local $aRet[2] = [$aCall[1], $aCall[2]]
	Return $aRet
EndFunc

Func _WIC_CreateImagingFactoryObject()
	Return _AutoItObject_ObjCreate($sCLSID_WICImagingFactory, $sIID_IWICImagingFactory, $dtagIWICImagingFactory)
EndFunc
