#include-once

Global $tagD2D1_COLORF = "float r;float g; float b;float a;"

Func _D2D1_CreateColorF($fRed = 0, $fGreen = 0, $fBlue = 0, $fAlpha = 1)
	Local $oReturn = _AutoItObject_DllStructCreate($tagD2D1_COLORF)

	$oReturn.r = $fRed
	$oReturn.g = $fGreen
	$oReturn.b = $fBlue
	$oReturn.a = $fAlpha

	Return $oReturn
EndFunc

Func _D2D1_CreateColorFFromARGB($iARGB = 0xFF000000)
	Local $fA = BitShift(BitAND($iARGB, 0xFF000000), 24)/255
	Local $fR = BitShift(BitAND($iARGB, 0xFF0000), 16)/255
	Local $fG = BitShift(BitAND($iARGB, 0xFF00), 8)/255
	Local $fB = BitAND($iARGB, 0xFF)/255

	Return _D2D1_CreateColorF($fR, $fG, $fB, $fA)
EndFunc