#include-once

Func _DWrite_CreateTypography($oDWriteFactory)
	Local $aCall = $oDWriteFactory.CreateTypography(0)

	Local $oTypography = _AutoItObject_WrapperCreate($aCall[1], $dTagIDWriteTypography)

	Return $oTypography
EndFunc

Func _DWrite_TypographyAddFontFeature($oTypography, $vFeature)
	If IsString($vFeature) Then $vFeature = _DWrite_StringToOpenTypeFeatureID($vFeature)

	Return $oTypography.AddFontFeature($vFeature, 1)
EndFunc

Func _DWrite_TypographyGetFontFeature($oTypography, $iIndex)
	Local $aCall = $oTypography.GetFontFeature($iIndex, 0, 0)

	Return $aCall[2]
EndFunc

Func _DWrite_TypographyGetFontFeatureCount($oTypography)
	Local $iCall = $oTypography.GetFontFeatureCount()

	Return $iCall
EndFunc

Func _DWrite_StringToOpenTypeFeatureID($sString = "kern")
	Local $a = Hex(Asc(StringMid(StringLower($sString), 1, 1)), 2)
	Local $b = Hex(Asc(StringMid(StringLower($sString), 2, 1)), 2)
	Local $c = Hex(Asc(StringMid(StringLower($sString), 3, 1)), 2)
	Local $d = Hex(Asc(StringMid(StringLower($sString), 4, 1)), 2)

	Return Dec($d & $c & $b & $a)
EndFunc
