﻿#NoTrayIcon
#AutoIt3Wrapper_Run_AU3Check=n

#cs

	vPaint 4 (technically 3.9.12)
	Something something something

#ce

#pragma compile(Out, vpaint4.exe)
#pragma compile(Icon, icon.ico)
#pragma compile(UPX, false)
#pragma compile(AutoItExecuteAllowed, false) ; you won't use vPaint as a free AutoIt interpreter, no, no
#pragma compile(Compatibility, win7)
#pragma compile(CompanyName, scintilla4evr)
#pragma compile(FileDescription, "vPaint 4")
#pragma compile(FileVersion, 4.0.0.0)
#pragma compile(ProductName, vPaint)
#pragma compile(ProductVersion, 4.0.0.0)
#pragma compile(x64, false)

#include <GUIConstants.au3>

Global $hStartupTimer = TimerInit()

#include <WinAPIEx.au3>
#include <Array.au3>
#include <Math.au3>
#include "UDFs\_GDIPlus_BitmapApplyFilter.au3" ; <- GDI+ included right there!
#include <Timers.au3>
#include <File.au3>
#include <Misc.au3>
#include <GUIComboBox.au3>
#include <GUIImageList.au3>
#include <GUIListView.au3>
#include <GUIMenu.au3>
#include <Date.au3>
#include "UDFs\ColorEx.au3"
#include "UDFs\MoGraphics.au3"
#include "UDFs\Direct2D.au3"
#include "UDFs\DirectWrite.au3"
#include "UDFs\StringSize.au3"

#include "UDFs\AXml.au3"

; Fix for AXml.au3
$hDLL_AXml = DllOpen(@ScriptDir&"\Data\Libraries\AXml_x32.dll")

#include "Base\MsgBox.au3"

If Number(_WinAPI_GetVersion()) < 6.1 Then Exit _MsgBox("Couldn't run", "vPaint 4 needs Windows 7 or later operating system to work.")

Opt("GUIOnEventMode", 1)

; Fix for GUICtrlOnHover
If Not IsDeclared("DLL_USER32") Then Global $DLL_USER32 = DllOpen("user32.dll")

#include "UDFs\GUICtrlOnHover.au3"

#include "Base\Constants.au3"
#include "Base\Startup.au3"
#include "Base\Plugin\Plugin.au3"

#include "Base\SplashScreen.au3"

GUICtrlSetData($cidSplashScreenLabel, "Loading helper libraries...")

#include "Base\Helper\IconButtons.au3"
#include "Base\Helper\Tiles.au3"
#include "Base\Helper\Rotation.au3"
#include "Base\Helper\GDIPlusEx.au3"
#include "Base\Helper\ExtraUI.au3"
#include "Base\Helper\Zip.au3"

; Compositing node editor base
#include "Base\Helper\Node\Nodes.au3"

; POV-Ray integration
#include "Base\POVRay\POVRay.au3"

#include "Base\Async.au3"

#include "Base\Experimental\Interference\Interference.au3"
_Interference_Startup(0)

#include "Base\Color.au3"

#include "Base\Compositing\Compositing.au3"

GUICtrlSetData($cidSplashScreenLabel, "Initializing thread functionality...")

#include "Base\Layers.au3"
#include "Base\Threads.au3"
#include "Base\ThreadManager.au3"
#include "Base\Audio\AudioThread.au3"

; Objects
#include "Base\Objects\Selection.au3"
#include "Base\Objects\Path.au3"

GUICtrlSetData($cidSplashScreenLabel, "Initializing user interface...")

#include "Base\ContextMenu.au3"
#include "Base\MainWindow.au3"
#include "Base\AboutWindow.au3"
#include "Base\Progress.au3"

GUICtrlSetData($cidSplashScreenLabel, "Initializing drawing functions...")
#include "Base\Drawing\Drawing.au3"
#include "Base\Drawing\DrawingArea.au3"

GUICtrlSetData($cidSplashScreenLabel, "Initializing utilities...")
#include "Base\Utilities.au3"
#include "Base\UtilitiesD2D.au3" ; Another new and sparky clean!
#include "Base\Events.au3"

GUICtrlSetData($cidSplashScreenLabel, "Initializing revert functionality...")
#include "Base\Revert\RevertUI.au3"

GUICtrlSetData($cidSplashScreenLabel, "Loading effects...")
#include "Base\Effects\Effects.au3"

GUICtrlSetData($cidSplashScreenLabel, "Loading file format support libraries...")
#include "Base\V4I.au3"
#include "Base\FileSupport\FileSupport.au3"

; Forms & Utilities
#include "Base\Forms\BorderSelect.au3"

#include "Base\Updater.au3"

; Windows 10-specific functions
#include "Base\Win10\Win10.au3"

; API
#include "Base\API.au3"

$__Tiles_iTextRenderingHint = 3

ObjEvent("AutoIt.Error", "_ErrFunc")

#cs TODO
GUICtrlSetData($cidSplashScreenLabel, "Checking for updates...")
$aUpdates = _CheckForUpdates()
$error = @error

If $error = 1 Then
	GUICtrlSetData($cidSplashScreenLabel, "Connection failed.")
ElseIf $error = 2 Then
	GUICtrlSetData($cidSplashScreenLabel, "Trouble connecting to the update server.")
ElseIf $error <> 0 Then
	GUICtrlSetData($cidSplashScreenLabel, "Unexpected error.")
Else
	GUICtrlSetData($cidSplashScreenLabel, "Downloading update ("&$aUpdates[2]&" MB)...")
	GUICtrlSetData($cidSplashScreenLabel, "Update downloaded.")
EndIf
#ce

GUICtrlSetData($cidSplashScreenLabel, "Initializing...")

#cs
	REMARK #1: Tablet Mode: support or not? [scintilla4evr]

	In version 3.9.4 (Source Release #4), tablet mode interface and
	on-the-air switching between modes was introduced. But starting with
	version 3.9.5 (Source Release #5), vPaint's main interface is being
	reconstructed to work good for both mouse and touch devices.

#ce
_SwitchMode(0)
#cs
	REMARK #2: N/A
#ce

GUIDelete($hSplashScreen)
GUISwitch($hMainUI)


$hToolUIWindow = $oCurrentTool.showUI()

_RefreshTabs()

If RegRead("HKCU\SOFTWARE\vPaint\"&$APPVERSION, "OpenFile") <> "" Then
	_OpenFile(RegRead("HKCU\SOFTWARE\vPaint\"&$APPVERSION, "OpenFile"))
	RegWrite("HKCU\SOFTWARE\vPaint\"&$APPVERSION, "OpenFile", "REG_SZ", "")
EndIf

While 1
	_AsyncCheck()

	If Not WinActive($hMainUI) Or $isChangingUIMode Then
		Sleep(100)
		ContinueLoop
	EndIf
	#Region Drawing Events
	If $isOpen Then
		$cInfo = GUIGetCursorInfo($hMainUI)
		$aPos = ControlGetPos($hMainUI, "", $cidDrawingArea)

		If Not IsObj($oCurrentThread) Or $isWorkingOnHistory Then ContinueLoop
		Switch $oCurrentThread.type
			Case $V4_TT_IMAGE
				If $isShowingToolUI = 0 And $iViewportRenderEnabled = 0 Then
					If WinActive($hMainUI) And $cInfo[4] = $cidDrawingArea And _IsPressed(1, $DLL_USER32) And $iCurrentEvent = $V4_ST_HUDDRAW Then
						If $oCurrentThread.thread.currentLayer.canDraw And $oCurrentTool.canBypassLock($oCurrentThread.thread.currentLayer.lockMode) And $oCurrentThread.thread.currentLayer.type = $V4_LT_IMAGE Then
							$iCurrentEvent = $V4_ST_PAINTINIT

							$x = $cInfo[0]-$aPos[0]
							$y = $cInfo[1]-$aPos[1]

							_Util_ConvertClientToBitmap($x, $y)
							$oCurrentTool.start($x, $y)
						ElseIf Not ($oCurrentThread.thread.currentLayer.lockMode = $V4_LL_NONE Or $oCurrentThread.thread.currentLayer.lockMode = $V4_LL_POS) Then
							_CreateNotification("Cannot draw", "This layer is locked, so you cannot modify it.")
						ElseIf $oCurrentThread.thread.currentLayer.isSmart Then
							_CreateNotification("Cannot draw", "This layer is a Smart Object, so you'll have to rasterize it before directly editing it.")
						EndIf
					ElseIf WinActive($hMainUI) And _IsPressed(1, $DLL_USER32) And ($iCurrentEvent = $V4_ST_PAINTINIT Or $iCurrentEvent = $V4_ST_PAINT) Then
						If $oCurrentThread.thread.currentLayer.canDraw Then
							$iCurrentEvent = $V4_ST_PAINT

							$x = $cInfo[0]-$aPos[0]
							$y = $cInfo[1]-$aPos[1]

							_Util_ConvertClientToBitmap($x, $y)
							$oCurrentTool.draw($x, $y)

							_RenderDrawingArea(0, $cInfo, 1)
						EndIf
					ElseIf WinActive($hMainUI) And Not _IsPressed(1, $DLL_USER32) And Not ($iCurrentEvent = $V4_ST_PAINTEND Or $iCurrentEvent = $V4_ST_HUDDRAW Or $iCurrentEvent = $V4_ST_IDLE) Then
						If $oCurrentThread.thread.currentLayer.canDraw Then
							$iCurrentEvent = $V4_ST_PAINTEND

							$x = $cInfo[0]-$aPos[0]
							$y = $cInfo[1]-$aPos[1]

							_Util_ConvertClientToBitmap($x, $y)

							$oCurrentTool.end($x, $y)
							$oCurrentThread.historyAdd()

							_RefreshLayerList()
							_RenderDrawingArea(0, $cInfo, 1)
						EndIf
					ElseIf WinActive($hMainUI) And $cInfo[4] = $cidDrawingArea Then
						$iCurrentEvent = $V4_ST_HUDDRAW
						_RenderDrawingArea(1, $cInfo, 1)
					ElseIf $iCurrentEvent = $V4_ST_HUDDRAW And Not (WinActive($hMainUI) or $cInfo[4] = $cidDrawingArea) Then
						$iCurrentEvent = $V4_ST_IDLE
					EndIf
				ElseIf $iViewportRenderEnabled = 1 And $cInfo[4] = $cidDrawingArea And WinActive($hMainUI) Then
					_RenderDrawingArea(1, $cInfo, 1)
				EndIf

				If $isShowingToolUI And Not WinActive($hCurrentToolUI) Then
					GUIDelete($hCurrentToolUI)
					$isShowingToolUI = 0
					Sleep(100)
				EndIf
			Case $V4_TT_AUDIO
				If $oCurrentThread.isPlaying Then
					_RenderDrawingArea_Audio(1, $cInfo, 1)
				EndIf
		EndSwitch
	EndIf
	#EndRegion
WEnd

Func _ErrFunc($oError)
	; Do anything here.
	ConsoleWrite(@ScriptName & " (" & $oError.scriptline & ") : ==> COM Error intercepted !" & @CRLF & _
			@TAB & "err.number is: " & @TAB & @TAB & "0x" & Hex($oError.number) & @CRLF & _
			@TAB & "err.windescription:" & @TAB & $oError.windescription & @CRLF & _
			@TAB & "err.description is: " & @TAB & $oError.description & @CRLF & _
			@TAB & "err.source is: " & @TAB & @TAB & $oError.source & @CRLF & _
			@TAB & "err.helpfile is: " & @TAB & $oError.helpfile & @CRLF & _
			@TAB & "err.helpcontext is: " & @TAB & $oError.helpcontext & @CRLF & _
			@TAB & "err.lastdllerror is: " & @TAB & $oError.lastdllerror & @CRLF & _
			@TAB & "err.scriptline is: " & @TAB & $oError.scriptline & @CRLF & _
			@TAB & "err.retcode is: " & @TAB & "0x" & Hex($oError.retcode) & @CRLF & @CRLF)
EndFunc

#cs

	End?

#ce
