#include-once

Global Enum $COMP_TYPE_ALPHAOVER = 0x400

#cs
	NODE DEFINITION
	ALPHA OVER
	Draws one image over the another.

	INPUTS:
	Behind [GDI+ Bitmap]
	Front [GDI+ Bitmap]

	OUTPUTS:
	Image [GDI+ Bitmap]

#ce
Func _CompAdd_AlphaOver($iX = 0, $iY = 0, $oTMgm = $oCurrentThread)
	Local $oNode = _Node_CreateNode("Alpha Over", "_CompProc_AlphaOver", $COMP_TYPE_BLUR, $iX, $iY)
	$oNode.input.add(_Node_CreateIOItem("Behind", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.input.add(_Node_CreateIOItem("Front", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.output.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.calcSize()

	$oTMgm.compList.add($oNode)

	Return $oNode
EndFunc

Func _CompProc_AlphaOver($oSelf, $iWantedOutput, $aInputs)
	Local $tGpx = _GDIPlus_ImageGetGraphicsContext($aInputs[0])
	_GDIPlus_GraphicsDrawImage($tGpx, $aInputs[1], 0, 0)
	_GDIPlus_GraphicsDispose($tGpx)

	Return $aInputs[0]
EndFunc
