#include-once

Func _ShowMenu($hWnd, $idCtrl, $idContext)
	Local $aPos, $x, $y
	Local $hMenu = GUICtrlGetHandle($idContext)

	$aPos = ControlGetPos($hWnd, "", $idCtrl)

	$x = $aPos[0]
	$y = $aPos[1] + $aPos[3]

	_ClientToScreen($hWnd, $x, $y)
	_TrackPopupMenu($hWnd, $hMenu, $x, $y)
EndFunc

Func _ClientToScreen($hWnd, ByRef $x, ByRef $y)
	Local $tPoint = DllStructCreate("int;int")

	DllStructSetData($tPoint, 1, $x)
	DllStructSetData($tPoint, 2, $y)

	DllCall("user32.dll", "int", "ClientToScreen", "hwnd", $hWnd, "ptr", DllStructGetPtr($tPoint))

	$x = DllStructGetData($tPoint, 1)
	$y = DllStructGetData($tPoint, 2)

	$tPoint = 0
EndFunc

Func _TrackPopupMenu($hWnd, $hMenu, $x, $y)
	DllCall("user32.dll", "int", "TrackPopupMenuEx", "hwnd", $hMenu, "int", 0, "int", $x, "int", $y, "hwnd", $hWnd, "ptr", 0)
EndFunc

